/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.dbsource;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.MemoryTable;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.dbsource.TableManager;
import java.sql.SQLException;

public abstract class TableSourceBase {
    Table table;
    TableManager manager;
    int ref = 0;

    TableSourceBase(TableManager manager) {
        this.manager = manager;
    }

    void addUse() {
        ++this.ref;
    }

    boolean release() {
        --this.ref;
        if (this.ref == 0) {
            this.close();
        }
        return this.ref == 0;
    }

    void close() {
        if (this.table != null) {
            this.table.close();
        }
    }

    public Table get() throws SQLException, OLAPException {
        if (this.table == null) {
            this.table = this.createTable();
        } else if (this.ref > 1 && !(this.table instanceof MemoryTable)) {
            this.table = new MemoryTable(this.table);
        }
        return this.table;
    }

    public abstract Table createTable() throws SQLException, OLAPException;
}

