/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.def;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.ConnectionDef;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.SchemaChecker;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.def.TableDef;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class SchemaDef
implements Serializable {
    public String name;
    public String caption;
    public String description;
    public Properties config = new Properties();
    public ParameterDef[] parameters;
    public ConnectionDef connection;
    public TableDef[] tables;
    public SharedDimensionDef[] dimensions;
    public CubeDef[] cubes;

    public void check() throws OLAPException {
        new SchemaChecker(this).check();
    }

    public Document export() {
        return new Document(this.exportSchema());
    }

    public SharedDimensionDef getDimensionDef(String name) {
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (!this.dimensions[i].name.equalsIgnoreCase(name)) continue;
            return this.dimensions[i];
        }
        return null;
    }

    Element exportConfig() {
        Element x = new Element("Config");
        Enumeration<?> e = this.config.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.config.getProperty(name);
            Element item = new Element("Item");
            item.setAttribute("name", name);
            item.setAttribute("value", value);
            x.addContent((Content)item);
        }
        return x;
    }

    Element exportSchema() {
        int i;
        Element x = new Element("Schema");
        if (this.name != null) {
            x.setAttribute("name", this.name);
        }
        if (this.caption != null) {
            x.setAttribute("caption", this.caption);
        }
        if (this.description != null) {
            x.setAttribute("description", this.description);
        }
        if (this.config.size() > 0) {
            x.addContent((Content)this.exportConfig());
        }
        if (this.parameters != null) {
            for (i = 0; i < this.parameters.length; ++i) {
                x.addContent((Content)this.parameters[i].export());
            }
        }
        if (this.connection != null) {
            x.addContent((Content)this.connection.export());
        }
        if (this.tables != null) {
            for (i = 0; i < this.tables.length; ++i) {
                x.addContent((Content)this.tables[i].export());
            }
        }
        if (this.dimensions != null) {
            for (i = 0; i < this.dimensions.length; ++i) {
                x.addContent((Content)this.dimensions[i].export());
            }
        }
        if (this.cubes != null) {
            for (i = 0; i < this.cubes.length; ++i) {
                x.addContent((Content)this.cubes[i].export());
            }
        }
        return x;
    }

    public String toString() {
        return "[Schema '" + this.name + "']";
    }

    public TableDef getTableDef(String name) {
        for (int i = 0; i < this.tables.length; ++i) {
            if (!this.tables[i].name.equalsIgnoreCase(name)) continue;
            return this.tables[i];
        }
        return null;
    }
}

