/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl.func;

import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunctionException;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.HierarchyCalc;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractLevelCalc;

public class LevelsCalc
extends AbstractLevelCalc {
    HierarchyCalc hierarchyCalc;
    IntegerCalc ordinalCalc;

    public LevelsCalc(Exp exp, HierarchyCalc hierarchyCalc, IntegerCalc ordinalCalc) {
        super(exp, new Calc[]{hierarchyCalc, ordinalCalc});
        this.hierarchyCalc = hierarchyCalc;
        this.ordinalCalc = ordinalCalc;
    }

    @Override
    public Level evaluateLevel(Evaluator evaluator) throws OLAPException {
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
        int n = this.ordinalCalc.evaluateInteger(evaluator);
        if (hierarchy.getDimension().isParentChildrenDimension()) {
            Level level;
            for (level = hierarchy.getLevels()[0]; level != null && n > level.getDepth(); level = level.getChildLevel()) {
            }
            if (level == null) {
                throw new FunctionException("Levels Index '" + n + "' out of bounds");
            }
            return level;
        }
        Level[] levels = hierarchy.getLevels();
        if (n >= levels.length || n < 0) {
            throw new FunctionException("Levels Index '" + n + "' out of bounds");
        }
        return levels[n];
    }
}

