/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.type;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.mdx.type.ScalarType;
import com.kingdee.bos.olap.mdx.type.Type;

public class MemberType
implements Type {
    private final Hierarchy hierarchy;
    private final Level level;
    private final Member member;
    public static final MemberType Unknown = new MemberType(null, null, null);

    public MemberType(Hierarchy hierarchy, Level level, Member member) {
        this.level = level;
        this.member = member;
        this.hierarchy = hierarchy;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public boolean usesDimension(Dimension dimension) {
        return this.hierarchy != null && this.hierarchy.getDimension() == dimension;
    }

    public Type getValueType() {
        return new ScalarType();
    }

    public static MemberType forHierarchy(Hierarchy hierarchy) {
        return new MemberType(hierarchy, null, null);
    }

    public static MemberType forLevel(Level level) {
        return new MemberType(level.getHierarchy(), level, null);
    }

    public static MemberType forMember(Member member) {
        return new MemberType(member.getHierarchy(), member.getLevel(), member);
    }

    public static MemberType forType(Type type) {
        if (type instanceof MemberType) {
            return (MemberType)type;
        }
        return new MemberType(type.getHierarchy(), type.getLevel(), null);
    }
}

