/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.config.Config_CN;
import com.kingdee.bos.olap.config.Config_EN;
import com.kingdee.bos.olap.config.Config_TW;
import com.kingdee.bos.olap.dbsource.TableManager;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaParser;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.impl.BuildContext;
import com.kingdee.bos.olap.mem.impl.OLAPBuilder;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class OLAPEngine {
    private static Hashtable resources = new Hashtable();

    public static OLAPDatabase build(SchemaDef schemaDef, Map params) throws OLAPException, SQLException {
        TableManager tableManager = OLAPBuilder.getTableManager(schemaDef, params);
        BuildContext buildContext = new BuildContext(tableManager);
        SchemaImpl schema = OLAPBuilder.buildSchema(buildContext, schemaDef, (List)params.get("OLAP_KEY_MEASURE_VISIBLES"), true);
        OLAPDatabase database = OLAPBuilder.buildDatabase(buildContext, schema, schemaDef);
        tableManager.clear();
        return database;
    }

    public static OLAPDatabase buildWithoutCheck(SchemaDef schemaDef, Map params) throws OLAPException, SQLException {
        TableManager tableManager = OLAPBuilder.getTableManager(schemaDef, params);
        BuildContext buildContext = new BuildContext(tableManager);
        SchemaImpl schema = OLAPBuilder.buildSchema(buildContext, schemaDef, (List)params.get("OLAP_KEY_MEASURE_VISIBLES"), false);
        OLAPDatabase database = OLAPBuilder.buildDatabase(buildContext, schema, schemaDef);
        tableManager.clear();
        return database;
    }

    public static OLAPDatabase build(Document schema, Map parameters) throws OLAPException, SQLException, JDOMException {
        return OLAPEngine.build(SchemaParser.parse(schema), parameters);
    }

    public static OLAPDatabase build(SchemaDef schema) throws OLAPException, SQLException {
        return OLAPEngine.build(schema, new HashMap());
    }

    public static OLAPDatabase build(Document schema) throws OLAPException, SQLException {
        return OLAPEngine.build(SchemaParser.parse(schema));
    }

    public static void setLocalResource(Locale locale, Properties props) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = new Properties();
            resources.put(locale, res);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            res.setProperty(name, value);
        }
    }

    public static String getResource(String name) {
        return OLAPEngine.getResource(Locale.getDefault(), name);
    }

    public static String getResource(Locale locale, String name) {
        return OLAPEngine.getResource(locale, name, null);
    }

    public static String getResource(Locale locale, String name, String defaultValue) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = (Properties)resources.get(Locale.US);
        }
        return res.getProperty(name, defaultValue);
    }

    public static Properties getResources(Locale locale) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = (Properties)resources.get(Locale.US);
        }
        return res;
    }

    static {
        Config_CN cn = new Config_CN();
        Config_TW tw = new Config_TW();
        Config_EN en = new Config_EN();
        OLAPEngine.setLocalResource(Locale.CHINA, cn);
        OLAPEngine.setLocalResource(Locale.CHINESE, cn);
        OLAPEngine.setLocalResource(Locale.SIMPLIFIED_CHINESE, cn);
        OLAPEngine.setLocalResource(Locale.TRADITIONAL_CHINESE, tw);
        OLAPEngine.setLocalResource(Locale.TAIWAN, tw);
        OLAPEngine.setLocalResource(Locale.US, en);
        OLAPEngine.setLocalResource(Locale.UK, en);
        OLAPEngine.setLocalResource(Locale.CANADA, en);
        OLAPEngine.setLocalResource(Locale.ENGLISH, en);
    }
}

