/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.DateKey;
import com.kingdee.bos.olap.base.Key;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.mem.impl.DimensionBuildResult;
import com.kingdee.bos.olap.mem.impl.DimensionFetch;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import java.util.Date;

class DimensionUsageFetch
implements DimensionFetch {
    Key foreignKey = null;
    String foreignKeyName;
    DimensionBuildResult dbr;
    MemberImpl[] values;
    int hieCount;

    DimensionUsageFetch(DimensionBuildResult dbr, DimensionImpl dim, DimensionUsageDef def) {
        this.hieCount = dim.hies.length;
        this.foreignKeyName = def.foreignKey;
        this.dbr = dbr;
        this.values = new MemberImpl[this.hieCount];
    }

    @Override
    public MemberImpl[] fetch(Table table) throws OLAPException {
        Object keyValue;
        if (this.foreignKey == null) {
            this.foreignKey = new Key(table, this.foreignKeyName);
        }
        if ((keyValue = this.foreignKey.getCurrentValue()) instanceof Date) {
            keyValue = new DateKey((Date)keyValue);
        }
        for (int i = 0; i < this.hieCount; ++i) {
            this.values[i] = this.dbr.getHierarchyBuildResult(i).get(keyValue);
        }
        return this.values;
    }

    @Override
    public void finish() {
    }
}

