/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mem.Aggregator;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import com.kingdee.bos.olap.util.ByteArrayInputStream;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.bos.olap.util.InOutSqlUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MemCubeData
extends CubeData {
    private HashMap data = new HashMap();
    private int records = 0;

    public MemCubeData() {
    }

    public MemCubeData(Cube _cube) throws OLAPException {
        super(_cube);
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws OLAPException {
        for (int i = 0; i < members.length; ++i) {
            IMemberList children = members[i].getChildMembers();
            if (children == null || children.isEmpty()) continue;
            return;
        }
        ++this.records;
        Point p = new Point(members);
        p.detail = true;
        Object[] vs = (Object[])this.data.get(p);
        vs = this.appendValue(vs, values);
        this.data.put(p, vs);
    }

    @Override
    public void finishAddRecord() throws OLAPException {
    }

    @Override
    public void compact() {
    }

    @Override
    public void buildData(int level) throws OLAPException {
    }

    @Override
    public void finishBuildData() throws OLAPException {
    }

    @Override
    public Object[] getData(Member[] point) throws OLAPException {
        return this.getData(point, this.data);
    }

    @Override
    public Object[] getData(Member[] point, Map pinCache) throws OLAPException {
        Object[] vs;
        if (pinCache == null) {
            pinCache = new HashMap();
        }
        if ((vs = this.getData1(point, pinCache)) == null) {
            return null;
        }
        Object[] vs1 = new Object[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            vs1[i] = i > this.measures.length - 1 || this.aggs[i] == null ? vs[i] : this.aggs[i].getValue(vs[i]);
        }
        return vs1;
    }

    public Object[] getData1(Member[] members, Map pinCache) throws OLAPException {
        Point point = new Point(members);
        Object[] values = null;
        values = (Object[])pinCache.get(point);
        if (values != null) {
            return values;
        }
        values = (Object[])this.data.get(point);
        if (values != null) {
            return values;
        }
        values = new Object[this.aggs.length];
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        for (int i = 0; i < members.length; ++i) {
            IMemberList list = members[i].getChildMembers();
            Member[] sms = (Member[])list.toArray(new Member[list.size()]);
            if (sms == null || sms.length <= 0) continue;
            for (int j = 0; j < sms.length; ++j) {
                ms[i] = sms[j];
                Object[] vs = this.getData1(ms, pinCache);
                for (int k = 0; k < this.measures.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
            }
            break;
        }
        pinCache.put(point, values);
        return values;
    }

    @Override
    public Object[] appendAggregator(Object[] v1, Object[] v2) throws OLAPException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OLAPException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public Object[] appendValue(Object[] v1, Object[] v2) throws OLAPException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OLAPException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        out.writeObject(((CubeImpl)this.cube).getName());
        out.writeObject(this.aggs);
        out.writeObject(this.measures);
        Point[] ps = new Point[this.data.size()];
        this.data.keySet().toArray(ps);
        int count = 0;
        for (int i = 0; i < ps.length; ++i) {
            if (!ps[i].detail) continue;
            ++count;
        }
        out.writeInt(count);
        if (count == 0) {
            return;
        }
        int keycount = ps[0].keys.length;
        out.writeInt(keycount);
        for (int i = 0; i < ps.length; ++i) {
            if (!ps[i].detail) continue;
            for (int j = 0; j < keycount; ++j) {
                out.writeInt(ps[i].keys[j]);
            }
            Object[] values = (Object[])this.data.get(ps[i]);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            for (int k = 0; k < this.measures.length; ++k) {
                boolean valueIsCompounded = this.aggs[k] != null && this.aggs[k].valueIsCompounded();
                InOutSqlUtil.writeObject(values[k], this.measures[k].getDataType(), valueIsCompounded, this.aggs[k] == null ? null : this.aggs[k].getSerialize(), baos2);
            }
            byte[] bs = baos2.toByteArray();
            out.writeInt(bs.length);
            out.write(bs);
            if (values.length > this.measures.length) {
                out.writeBoolean(true);
                Object[] propValues = new Object[values.length - this.measures.length];
                System.arraycopy(values, this.measures.length, propValues, 0, propValues.length);
                out.writeObject(propValues);
                continue;
            }
            out.writeBoolean(false);
        }
    }

    @Override
    public void restore(ObjectInputStream in, Object info) throws IOException {
        SchemaImpl schema = (SchemaImpl)info;
        CubeImpl[] cubes = schema.cubes;
        try {
            String cubeName = (String)in.readObject();
            for (int i = 0; i < cubes.length; ++i) {
                if (!cubes[i].getName().equals(cubeName)) continue;
                this.cube = cubes[i];
                break;
            }
            this.data = new HashMap();
            this.aggs = (Aggregator[])in.readObject();
            this.measures = (Member[])in.readObject();
            boolean[] valueIsCompoundeds = new boolean[this.measures.length];
            int[] dataTypes = new int[this.measures.length];
            for (int k = 0; k < this.measures.length; ++k) {
                valueIsCompoundeds[k] = this.aggs[k] != null && this.aggs[k].valueIsCompounded();
                dataTypes[k] = this.measures[k].getDataType();
            }
            int count = in.readInt();
            int keycount = 0;
            if (count > 0) {
                keycount = in.readInt();
            }
            for (int i = 0; i < count; ++i) {
                int[] keys = new int[keycount];
                for (int j = 0; j < keycount; ++j) {
                    keys[j] = in.readInt();
                }
                int len = in.readInt();
                byte[] bs = new byte[len];
                in.readFully(bs);
                ByteArrayInputStream bais = new ByteArrayInputStream(bs);
                Object[] values = new Object[this.measures.length];
                for (int k = 0; k < this.measures.length; ++k) {
                    values[k] = InOutSqlUtil.readObject(dataTypes[k], valueIsCompoundeds[k], this.aggs[k] == null ? null : this.aggs[k].getSerialize(), bais);
                }
                Point p = new Point(keys);
                if (in.readBoolean()) {
                    Object[] propValues = (Object[])in.readObject();
                    Object[] vs = new Object[values.length + propValues.length];
                    System.arraycopy(values, 0, vs, 0, values.length);
                    System.arraycopy(propValues, 0, vs, values.length, propValues.length);
                    values = vs;
                }
                this.data.put(p, values);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
    }

    @Override
    public void release() {
        this.data.clear();
    }

    private static class Point
    implements Serializable {
        private int[] keys;
        private boolean detail = true;
        private transient int h = 0;

        public Point(Member[] members) {
            this.keys = new int[members.length];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = ((MemberImpl)members[i]).globalOrder;
            }
        }

        public Point(int[] _keys) {
            this.keys = _keys;
        }

        public int hashCode() {
            if (this.h == 0) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.h = this.h << 5 ^ this.keys[i];
                }
            }
            return this.h;
        }

        public boolean equals(Object x) {
            int[] keys1 = this.keys;
            int[] keys2 = ((Point)x).keys;
            for (int i = 0; i < keys2.length; ++i) {
                if (keys1[i] == keys2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

