/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.CellKey;
import com.kingdee.bos.olap.rel.ColumnConstraint;
import com.kingdee.bos.olap.rel.DenseSegmentDataset;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.Segment;
import com.kingdee.bos.olap.rel.SegmentDataset;
import com.kingdee.bos.olap.rel.SparseSegmentDataset;
import com.kingdee.bos.olap.rel.SqlGenerator;
import com.kingdee.bos.olap.rel.Star;
import com.kingdee.bos.olap.util.Util;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Aggregation {
    private final Star star;
    private final Star.Column[] columns;
    private final List segmentRefs;
    private static Logger logger = CommonLogger.getLogger(Aggregation.class);

    public Aggregation(Star star, Star.Column[] columns) {
        this.star = star;
        this.columns = columns;
        this.segmentRefs = new ArrayList();
    }

    public void load(Star.Column[] measures, ColumnConstraint[][] constraintses, Collection pinnedSegments) throws SQLException, OLAPException {
        long t1 = System.currentTimeMillis();
        int axisCount = this.columns.length;
        Axis[] axes = new Axis[axisCount];
        for (int i = 0; i < axisCount; ++i) {
            axes[i] = new Axis(constraintses[i]);
        }
        Segment[] segments = new Segment[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            Segment segment;
            Star.Column measure = measures[i];
            segments[i] = segment = new Segment(measure, axes);
            SoftReference<Segment> ref = new SoftReference<Segment>(segment);
            this.segmentRefs.add(ref);
            pinnedSegments.add(segment);
        }
        this.load(segments, pinnedSegments, axes);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Aggregation.load cost " + (System.currentTimeMillis() - t1) + "ms."));
        }
    }

    private void logSqlCost(String content, String sql, long cost) {
        StringBuffer sb = new StringBuffer(content).append(" cost ").append(cost).append("ms.");
        if (cost > 1000L) {
            sb.append("the sql is:\n").append(sql);
            logger.info((Object)sb.toString());
        } else {
            logger.debug((Object)sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(Segment[] segments, Collection pinnedSegments, Axis[] axes) throws SQLException, OLAPException {
        String sql = SqlGenerator.generateSQL(this, segments);
        int arity = this.columns.length;
        ResultSet resultSet = null;
        int measureCount = segments.length;
        Connection jdbcConnection = null;
        try {
            int i;
            int i2;
            long t0 = System.currentTimeMillis();
            jdbcConnection = this.star.schema.conn.getJdbcConnection();
            resultSet = RelUtil.executeQuery(jdbcConnection, sql, "Aggregation.load");
            long cost = System.currentTimeMillis() - t0;
            this.logSqlCost("executeSql ", sql, cost);
            t0 = System.currentTimeMillis();
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (resultSet.next()) {
                Object o;
                Object[] row = new Object[arity + measureCount];
                int k = 1;
                for (i2 = 0; i2 < arity; ++i2) {
                    Integer offsetInteger;
                    if ((o = resultSet.getObject(k++)) == null) {
                        o = Util.nullValue;
                    }
                    if ((offsetInteger = axes[i2].getOffset(o)) == null) {
                        axes[i2].addNextOffset(o);
                    }
                    row[i2] = o;
                }
                for (i2 = 0; i2 < measureCount; ++i2) {
                    if ((o = resultSet.getObject(k++)) == null) {
                        o = Util.nullValue;
                    }
                    row[arity + i2] = o;
                }
                rows.add(row);
            }
            logger.debug((Object)("loop cost " + (System.currentTimeMillis() - t0) + "ms,row num is " + rows.size()));
            t0 = System.currentTimeMillis();
            boolean sparse = true;
            int n = 1;
            for (i2 = 0; i2 < arity; ++i2) {
                int previous;
                Axis axis = axes[i2];
                int size = axis.loadKeys();
                if ((n *= size) >= (previous = n) && n >= size) continue;
                n = Integer.MAX_VALUE;
                sparse = true;
            }
            SegmentDataset[] datas = new SegmentDataset[segments.length];
            sparse = sparse || Aggregation.useSparse(n, rows.size());
            for (int i3 = 0; i3 < segments.length; ++i3) {
                datas[i3] = sparse ? new SparseSegmentDataset() : new DenseSegmentDataset(segments[i3], new Object[n]);
            }
            int[] pos = new int[arity];
            int count = rows.size();
            for (i = 0; i < count; ++i) {
                Object[] row = (Object[])rows.get(i);
                int k = 0;
                for (int j = 0; j < arity; ++j) {
                    int offset;
                    k *= axes[j].getKeys().length;
                    Object o = row[j];
                    Axis axis = axes[j];
                    Integer offsetInteger = axis.getOffset(o);
                    pos[j] = offset = offsetInteger.intValue();
                    k += offset;
                }
                CellKey key = null;
                if (sparse) {
                    key = new CellKey((int[])pos.clone());
                }
                for (int j = 0; j < segments.length; ++j) {
                    Object o = row[arity + j];
                    if (sparse) {
                        ((SparseSegmentDataset)datas[j]).put(key, o);
                        continue;
                    }
                    ((DenseSegmentDataset)datas[j]).set(k, o);
                }
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].setData(datas[i], pinnedSegments);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (jdbcConnection != null) {
                    jdbcConnection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private static boolean useSparse(double possibleCount, double actualCount) {
        return true;
    }

    public synchronized Object get(Star.Column measure, Object[] keys, Collection pinSet) {
        Iterator it = this.segmentRefs.iterator();
        while (it.hasNext()) {
            SoftReference ref = (SoftReference)it.next();
            Segment segment = (Segment)ref.get();
            if (segment == null) {
                it.remove();
                continue;
            }
            if (segment.measure != measure) continue;
            if (segment.isReady()) {
                Object o = segment.get(keys);
                if (o == null) continue;
                if (pinSet != null) {
                    pinSet.add(segment);
                }
                return o;
            }
            if (!segment.wouldContain(keys)) continue;
            if (pinSet != null) {
                pinSet.add(segment);
            }
            return null;
        }
        return null;
    }

    public void optimizeConstraints(Star.Column[] columns, ColumnConstraint[][] constraintses) throws OLAPException {
        long start = System.currentTimeMillis();
        Map map = this.star.getMapLevelToColumn();
        ArrayList<Hierarchy> hiers = new ArrayList<Hierarchy>();
        HashMap<RelLevelImpl, Integer> levelCounts = new HashMap<RelLevelImpl, Integer>();
        HashMap<Hierarchy, Integer> hierCounts = new HashMap<Hierarchy, Integer>();
        HashMap hierLevels = new HashMap();
        for (int i = 0; i < constraintses.length; ++i) {
            Integer count;
            ArrayList<RelLevelImpl> levels;
            ColumnConstraint[] constraints = constraintses[i];
            RelLevelImpl level = (RelLevelImpl)map.get(columns[i]);
            levelCounts.put(level, new Integer(constraints.length));
            if (!hiers.contains(level.getHierarchy())) {
                hiers.add(level.getHierarchy());
                levels = new ArrayList<RelLevelImpl>();
                hierLevels.put(level.getHierarchy(), levels);
                count = new Integer(constraints.length);
            } else {
                levels = (ArrayList<RelLevelImpl>)hierLevels.get(level.getHierarchy());
                count = (Integer)hierCounts.get(level.getHierarchy());
                count = new Integer(count + constraints.length);
            }
            levels.add(level);
            hierCounts.put(level.getHierarchy(), count);
        }
        for (RelHierarchyImpl hier : hierCounts.keySet()) {
            int realHierCount = this.star.schema.conn.schemaReader.getMemberCount(hier);
            if (hier.hasAll()) {
                --realHierCount;
            }
            int hierCount = (Integer)hierCounts.get(hier);
            ArrayList levels = (ArrayList)hierLevels.get(hier);
            boolean done = false;
            if ((double)hierCount > (double)realHierCount * this.threldHier()) {
                this.removeConstraints(columns, constraintses, levels);
                done = true;
            } else {
                int realLevelCount;
                Level level;
                int levelCount;
                for (int i = 0; i < levels.size() && (double)(levelCount = ((Integer)levelCounts.get(level = (Level)levels.get(i))).intValue()) > (double)(realLevelCount = this.star.schema.conn.schemaReader.getLevelMemberCount(level)) * this.threldLevel(); ++i) {
                    this.removeConstraints(columns, constraintses, level);
                    done = true;
                }
            }
            if (!done) {
                Level level = (Level)levels.get(0);
                Star.Column column = (Star.Column)map.get(level);
                int index = Arrays.asList(columns).indexOf(column);
                ColumnConstraint[] consts = constraintses[index];
                RelMemberImpl lastParent = null;
                boolean b = false;
                for (int i = 0; i < consts.length; ++i) {
                    RelMemberImpl member = consts[i].getMember();
                    RelMemberImpl parent = (RelMemberImpl)member.getParentMember();
                    if (parent == null) {
                        b = true;
                        break;
                    }
                    if (i == 0) {
                        lastParent = parent;
                        continue;
                    }
                    if (!parent.equals(lastParent)) {
                        b = true;
                        break;
                    }
                    lastParent = parent;
                }
                if (!b) {
                    this.removeConstraints(columns, constraintses, level);
                    done = true;
                }
            }
            long count = System.currentTimeMillis() - start;
            if (done) {
                logger.debug((Object)("optimize constraints succeed for Hierarchy " + hier.getName() + ".cost " + count + " ms."));
                continue;
            }
            logger.debug((Object)("optimize constraints failed for Hierarchy " + hier.getName() + ".cost " + count + " ms."));
        }
    }

    private double threldHier() {
        return 0.8;
    }

    private double threldLevel() {
        return 0.6;
    }

    private void removeConstraints(Star.Column[] columns, ColumnConstraint[][] constraintses, List levels) {
        Map map = this.star.getMapLevelToColumn();
        for (int i = 0; i < columns.length; ++i) {
            if (!levels.contains(map.get(columns[i]))) continue;
            constraintses[i] = null;
        }
    }

    private void removeConstraints(Star.Column[] columns, ColumnConstraint[][] constraintses, Level level) {
        Map map = this.star.getMapLevelToColumn();
        for (int i = 0; i < columns.length; ++i) {
            if (!level.equals(map.get(columns[i]))) continue;
            constraintses[i] = null;
        }
    }

    public Star.Column[] getColumns() {
        return this.columns;
    }

    public Star getStar() {
        return this.star;
    }

    public boolean isDetail() {
        Star.Column[] columns = this.getColumns();
        HashMap<Dimension, RelLevelImpl> map = new HashMap<Dimension, RelLevelImpl>();
        for (int i = 0; i < columns.length; ++i) {
            RelLevelImpl level = columns[i].level;
            RelLevelImpl level2 = (RelLevelImpl)map.get(level.getDimension());
            if (level2 != null) {
                if (level.getDepth() <= level2.getDepth()) continue;
                map.put(level.getDimension(), level);
                continue;
            }
            map.put(level.getDimension(), level);
        }
        boolean detail = true;
        for (RelLevelImpl level : map.values()) {
            if (level.child == null) continue;
            detail = false;
            break;
        }
        return detail;
    }

    public boolean isDetailExcludePC() {
        Star.Column[] columns = this.getColumns();
        HashMap<Dimension, RelLevelImpl> map = new HashMap<Dimension, RelLevelImpl>();
        for (int i = 0; i < columns.length; ++i) {
            RelLevelImpl level = columns[i].level;
            RelLevelImpl level2 = (RelLevelImpl)map.get(level.getDimension());
            if (level2 != null) {
                if (level.getDepth() <= level2.getDepth()) continue;
                map.put(level.getDimension(), level);
                continue;
            }
            map.put(level.getDimension(), level);
        }
        boolean detailExcludePC = true;
        for (RelLevelImpl level : map.values()) {
            if (level.getDimension().isParentChildrenDimension() || level.child == null) continue;
            detailExcludePC = false;
            break;
        }
        return detailExcludePC;
    }

    static class Axis {
        private final Map mapKeyToOffset;
        private Object[] keys;
        ColumnConstraint[] constraints;

        Axis(ColumnConstraint[] constraints) {
            this.constraints = constraints;
            this.mapKeyToOffset = new HashMap();
        }

        ColumnConstraint[] getConstraints() {
            return this.constraints;
        }

        Object[] getKeys() {
            return this.keys;
        }

        boolean contains(Object key) {
            if (this.constraints == null) {
                return true;
            }
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!this.constraints[i].getValue().equals(key)) continue;
                return true;
            }
            return false;
        }

        int loadKeys() {
            int size = this.mapKeyToOffset.size();
            this.keys = new Object[size];
            for (Map.Entry e : this.mapKeyToOffset.entrySet()) {
                Object key = e.getKey();
                Integer offsetInteger = (Integer)e.getValue();
                int offset = offsetInteger;
                this.keys[offset] = key;
            }
            return size;
        }

        Integer getOffset(Object key) {
            return (Integer)this.mapKeyToOffset.get(key);
        }

        void addNextOffset(Object key) {
            int size = this.mapKeyToOffset.size();
            this.mapKeyToOffset.put(key, new Integer(size));
        }

        int getBytes() {
            return this.keys == null ? 0 : 16 + 8 * this.keys.length;
        }
    }
}

