/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.CalculatedMember;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimension;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.type.CubeType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.rel.RelCalculatedMemberImpl;
import com.kingdee.bos.olap.rel.RelDimensionImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMeasureImpl;
import com.kingdee.bos.olap.rel.RelMeasureProperty;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.Star;
import java.util.Map;

public class RelCubeImpl
extends OLAPElementBase
implements Cube {
    RelSchemaImpl schema;
    CubeDef cubeDef;
    RelDimensionImpl[] dims;
    RelDimensionImpl measureDimension;
    RelHierarchyImpl measureHierarchy;
    RelLevelImpl measureLevel;
    RelMeasureImpl[] measures;
    RelMeasureProperty[] measurePropertyMembers;
    RelCalculatedMemberImpl[] calculatedMembers;
    private Star star;

    public RelCubeImpl(RelSchemaImpl schema, CubeDef cubeDef) {
        this.schema = schema;
        this.cubeDef = cubeDef;
        this.name = cubeDef.name;
        this.caption = cubeDef.caption;
    }

    void initMeasures(CubeDef x) throws OLAPException {
        this.measureDimension = new RelDimensionImpl();
        this.measureDimension.schema = this.schema;
        this.measureDimension.dimensionType = (byte)-1;
        this.measureDimension.setProperty("name", "Measures");
        this.measureHierarchy = new RelHierarchyImpl(this.measureDimension, null, null);
        this.measureHierarchy.setProperty("name", "Measures");
        this.measureDimension.hies = new RelHierarchyImpl[1];
        this.measureDimension.hies[0] = this.measureHierarchy;
        this.measureHierarchy.levels = new RelLevelImpl[1];
        this.measureLevel = new RelLevelImpl(null);
        this.measureLevel.hie = this.measureHierarchy;
        this.measureLevel.levelType = (byte)-2;
        this.measureHierarchy.levels[0] = this.measureLevel;
        this.measureLevel.setProperty("name", "MeasuresLevel");
        if (x.measureDimensionCaption != null) {
            this.measureDimension.setProperty("caption", x.measureDimensionCaption);
        }
    }

    public Star getStar() {
        return this.star;
    }

    public void initStar(RelSchemaImpl schema, CubeDef x) throws OLAPException {
        int i;
        TableDef tableDef = RelUtil.lookupOrCreateTableDef(schema, x.table);
        this.star = new Star(schema, this, tableDef);
        for (i = 0; i < this.measures.length; ++i) {
            Star.Measure starMeasure = new Star.Measure(this.measures[i].getAggregator(), this.star.getFactTable(), this.measures[i].getColumn());
            this.measures[i].setStarMeasure(starMeasure);
            this.star.getFactTable().addColumn(starMeasure);
            this.star.addColumnToName(starMeasure, this.measures[i].getName());
        }
        for (i = 0; i < this.measurePropertyMembers.length; ++i) {
            RelMeasureProperty mp = this.measurePropertyMembers[i];
            Star.MeasureProperty starMeasureProperty = new Star.MeasureProperty(this.star.getFactTable(), mp.getColumn());
            mp.setStarMeasureProperty(starMeasureProperty);
            this.star.getFactTable().addColumn(starMeasureProperty);
            this.star.addColumnToName(starMeasureProperty, mp.getName());
        }
        CubeDimension[] cds = x.dimensions;
        for (int i2 = 0; i2 < cds.length; ++i2) {
            if (!(cds[i2] instanceof DimensionUsageDef)) continue;
            DimensionUsageDef usage = (DimensionUsageDef)cds[i2];
            Dimension dim = this.getDimension(usage.name);
            this.initDimension(dim, schema, usage);
        }
    }

    void initDimension(Dimension dimension, RelSchemaImpl schema, DimensionUsageDef usage) {
        Map mapLevelToColumn = this.star.getMapLevelToColumn();
        Map mapLevelToNameColumn = this.star.getMapLevelToNameColumn();
        String primaryKey = (String)dimension.getProperty("primaryKey");
        String foreignKey = (String)dimension.getProperty("foreignKey");
        String tableName = (String)dimension.getProperty("table");
        TableDef tableDef = RelUtil.lookupOrCreateTableDef(schema, tableName);
        Star.Table table = new Star.Table(this.star, tableDef, this.star.getFactTable(), primaryKey, foreignKey);
        this.star.addDimensionTable(dimension, table);
        Hierarchy[] hierarchies = dimension.getHierarchies();
        for (int k = 0; k < hierarchies.length; ++k) {
            RelHierarchyImpl hierarchy = (RelHierarchyImpl)hierarchies[k];
            RelLevelImpl[] levels = (RelLevelImpl[])hierarchy.getLevels();
            for (int l = 0; l < levels.length; ++l) {
                RelLevelImpl level = levels[l];
                Star.Column column = this.makeColumnForLevelExpr(level, table, level.def.column);
                table.addColumn(column);
                mapLevelToColumn.put(level, column);
                mapLevelToColumn.put(column, level);
                String nameColumnName = this.findNameColumn(level);
                if (nameColumnName != null) {
                    Star.Column nameColumn = this.makeColumnForLevelExpr(level, table, nameColumnName);
                    table.addColumn(nameColumn);
                    mapLevelToNameColumn.put(level, nameColumn);
                    this.star.addColumnToName(nameColumn, level.getName());
                    this.star.addColumnToName(column, level.getName() + " (Key)");
                    continue;
                }
                this.star.addColumnToName(column, level.getName());
            }
        }
    }

    private String findNameColumn(RelLevelImpl level) {
        LevelDef def = level.def;
        PropertyDef[] properties = def.properties;
        if (properties == null) {
            return null;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].name.equals("name")) continue;
            return properties[i].column;
        }
        return null;
    }

    private Star.Column makeColumnForLevelExpr(RelLevelImpl level, Star.Table table, String column) {
        Star.Column starColumn = new Star.Column(table, column, level);
        return starColumn;
    }

    @Override
    public Dimension[] getDimensions() {
        return this.dims;
    }

    @Override
    public Dimension[] getDimensions(boolean includeMeasures) {
        if (includeMeasures) {
            Dimension[] ds = new Dimension[this.dims.length + 1];
            System.arraycopy(this.dims, 0, ds, 0, this.dims.length);
            ds[ds.length - 1] = this.measureDimension;
            return ds;
        }
        return this.dims;
    }

    @Override
    public Dimension getDimension(String name) throws OLAPException {
        if (name.equalsIgnoreCase("Measures")) {
            return this.measureDimension;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (!this.dims[i].getName().equalsIgnoreCase(name)) continue;
            return this.dims[i];
        }
        return null;
    }

    @Override
    public Dimension getMeasureDimension() {
        return this.measureDimension;
    }

    @Override
    public Dimension getTimeDimension() {
        for (int i = 0; i < this.dims.length; ++i) {
            if (this.dims[i].dimensionType != 1) continue;
            return this.dims[i];
        }
        return null;
    }

    @Override
    public Member[] getMeasures() {
        return this.measures;
    }

    public Member[] getMeasurePropertyMembers() {
        return this.measurePropertyMembers;
    }

    @Override
    public int getDimensionOrdinal(String name) throws OLAPException {
        if (name.equals("Measures")) {
            return -1;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (!this.dims[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new OLAPException("Dimension '" + name + "' not found.");
    }

    @Override
    public String getUniqueName() {
        return this.getName();
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        int i;
        Dimension dimension = this.getDimension(name);
        if (dimension != null) {
            return dimension;
        }
        for (i = 0; i < this.measures.length; ++i) {
            if (!this.measures[i].getName().equalsIgnoreCase(name)) continue;
            return this.measures[i];
        }
        for (i = 0; i < this.measurePropertyMembers.length; ++i) {
            if (!this.measurePropertyMembers[i].getName().equalsIgnoreCase(name)) continue;
            return this.measurePropertyMembers[i];
        }
        for (i = 0; i < this.dims.length; ++i) {
            OLAPElement mdxElement = this.dims[i].lookupChild(schemaReader, name);
            if (mdxElement == null) continue;
            return mdxElement;
        }
        return null;
    }

    @Override
    public Hierarchy getHierarchy() {
        return null;
    }

    @Override
    public Dimension getDimension() {
        return null;
    }

    public Type getExpType() {
        return new CubeType(this);
    }

    public int getCategory() {
        return 12;
    }

    @Override
    public CalculatedMember[] getCalculatedMembers() throws OLAPException {
        return this.calculatedMembers;
    }
}

