/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.MemberComparator;
import com.kingdee.bos.olap.base.MemberTreeNode;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.rel.PCMemberReaderImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelFetch;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

class RelHierarchyFetch {
    private PCMemberReaderImpl impl;
    RelLevelImpl[] levels;
    LevelDef[] levelDefs;
    RelLevelFetch[] levelFetchs;
    int levelCount;
    MemberTreeNode root = new MemberTreeNode();

    RelHierarchyFetch(PCMemberReaderImpl impl) {
        int levelStart;
        this.impl = impl;
        RelHierarchyImpl hie = impl.hie;
        this.levels = hie.levels;
        HierarchyDef def = hie.def;
        this.levelDefs = hie.def.levels;
        this.levelCount = this.levels.length;
        this.levelFetchs = new RelLevelFetch[this.levelCount];
        for (int i = levelStart = this.impl.hie.hasAll() ? 1 : 0; i < this.levelCount; ++i) {
            this.levelFetchs[i] = new RelLevelFetch(this.levels[i], this.levelDefs[0]);
        }
        this.root.children = new HashMap();
        if (def.hasAll) {
            RelMemberImpl allMember = new RelMemberImpl(null);
            if (def.allMemberName != null) {
                allMember.setName(def.allMemberName);
            }
            allMember.memberType = (byte)8;
            allMember.level = hie.levels[0];
            allMember.ordinal = 0;
            this.root.member = allMember;
        }
    }

    void fetch(ResultSet rs) throws SQLException {
        int i;
        MemberTreeNode current = this.root;
        int n = i = this.impl.hie.hasAll() ? 1 : 0;
        while (i < this.levelCount) {
            current = this.levelFetchs[i].fetch(current, rs);
            ++i;
        }
    }

    private void renderMember(Member member) {
        ++this.impl.memberCount;
    }

    void finish() throws OLAPException {
        if (this.root.member != null) {
            this.renderMember(this.root.member);
        }
        RelMemberImpl[] ms = this.buildMembers(this.root, true);
        if (this.root.member == null) {
            this.impl.rootMembers = ms;
        } else {
            this.impl.putChildrenCache((RelMemberImpl)this.root.member, ms);
            this.impl.rootMembers = new RelMemberImpl[]{(RelMemberImpl)this.root.member};
        }
        for (int i = 0; i < this.levelFetchs.length; ++i) {
            if (this.levelFetchs[i] == null) continue;
            this.levelFetchs[i].finish();
        }
    }

    RelMemberImpl[] buildMembers(MemberTreeNode tree, boolean buildParentChild) throws OLAPException {
        int i;
        if (tree.children == null) {
            return null;
        }
        MemberTreeNode[] items = new MemberTreeNode[tree.children.size()];
        tree.children.values().toArray(items);
        if (items.length == 0) {
            return new RelMemberImpl[0];
        }
        LevelDef levelDef = items[0].levelDef;
        if (buildParentChild && levelDef.parentColumn != null) {
            items = this.buildParentChildMembers(items, tree.children);
        }
        RelMemberImpl[] members = new RelMemberImpl[items.length];
        for (i = 0; i < items.length; ++i) {
            this.renderMember(items[i].member);
        }
        for (i = 0; i < items.length; ++i) {
            members[i] = (RelMemberImpl)items[i].member;
            RelMemberImpl[] children = this.buildMembers(items[i], false);
            if (children == null) continue;
            this.impl.putChildrenCache(members[i], children);
        }
        Arrays.sort(members, new MemberComparator(levelDef.orderBy, levelDef.orderMethod));
        for (i = 0; i < members.length; ++i) {
            members[i].ordinal = i;
        }
        if (buildParentChild && levelDef.parentColumn != null) {
            this.buildParentChildLevels(members);
        }
        return members;
    }

    void buildParentChildLevels(RelMemberImpl[] members) {
        for (int i = 0; i < members.length; ++i) {
            this.buildParentChildLevels(members[i]);
        }
    }

    void buildParentChildLevels(RelMemberImpl member) {
        RelMemberImpl[] children = this.impl.getChildrenCache(member);
        if (children == null || children.length == 0) {
            return;
        }
        RelLevelImpl level = member.level;
        RelLevelImpl childLevel = level.createChildLevel();
        for (int i = 0; i < children.length; ++i) {
            RelMemberImpl child = children[i];
            child.level = childLevel;
            this.buildParentChildLevels(child);
        }
    }

    MemberTreeNode[] buildParentChildMembers(MemberTreeNode[] items, HashMap all) throws OLAPException {
        Vector<MemberTreeNode> v = new Vector<MemberTreeNode>();
        for (int i = 0; i < items.length; ++i) {
            MemberTreeNode item = items[i];
            Object parentItem = null;
            if (item.parentValue != null) {
                Object parentKey = item.parentValue;
                parentItem = (MemberTreeNode)all.get(parentKey);
            }
            if (parentItem == null) {
                v.addElement(item);
                continue;
            }
            if (parentItem.equals(item)) {
                v.addElement(item);
                continue;
            }
            if (((MemberTreeNode)parentItem).children == null) {
                ((MemberTreeNode)parentItem).children = new HashMap();
            }
            ((MemberTreeNode)parentItem).children.put(item.childValue, item);
            ((RelMemberImpl)item.member).parent = ((MemberTreeNode)parentItem).member;
            ((RelMemberImpl)item.member).parentUniqueName = null;
        }
        items = new MemberTreeNode[v.size()];
        v.copyInto(items);
        return items;
    }
}

