/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel.dialect;

import com.kingdee.bos.olap.rel.DBType;
import java.util.Date;

public class DatabaseMetaUtil {
    public static String getColumnDefine(DBType dbType, int columnType, int precision, int scale) {
        if (dbType.isKsql()) {
            return DatabaseMetaUtil.getKSqlColumnDefine(columnType, precision, scale);
        }
        if (dbType.isMSSql()) {
            return DatabaseMetaUtil.getMSSqlColumnDefine(columnType, precision, scale);
        }
        if (dbType.isOracle()) {
            return DatabaseMetaUtil.getOracleColumnDefine(columnType, precision, scale);
        }
        if (dbType.isDB2()) {
            return DatabaseMetaUtil.getDB2ColumnDefine(columnType, precision, scale);
        }
        throw new RuntimeException("todo.");
    }

    public static String getKSqlColumnDefine(int columnType, int precision, int scale) {
        String str;
        switch (columnType) {
            case 16: {
                str = "CHAR(1)";
                break;
            }
            case -7: 
            case -5: 
            case 4: {
                str = "INT";
                break;
            }
            case -6: 
            case 5: {
                str = "INT";
                break;
            }
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (precision > 0) {
                    if ((precision *= 3) > 2000) {
                        precision = 2000;
                    }
                    str = "VARCHAR(" + precision + ")";
                    break;
                }
                str = "VARCHAR(2000)";
                break;
            }
            case 2: 
            case 3: {
                if (precision > 0) {
                    str = "DECIMAL(" + precision;
                    if (scale > 0) {
                        str = str + ", " + scale;
                    }
                    str = str + ")";
                    break;
                }
                str = "DECIMAL(20,8)";
                break;
            }
            case 6: 
            case 8: {
                str = "DECIMAL";
                if (precision <= 0) break;
                str = str + "(" + precision + ")";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                str = "DATETIME";
                break;
            }
            default: {
                throw new RuntimeException("Unsupport data type:" + columnType);
            }
        }
        return str;
    }

    public static String getMSSqlColumnDefine(int columnType, int precision, int scale) {
        String str;
        switch (columnType) {
            case 16: {
                str = "CHAR(1)";
                break;
            }
            case -7: 
            case -5: 
            case 4: {
                str = "INT";
                break;
            }
            case -6: 
            case 5: {
                str = "SMALLINT";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (precision > 0) {
                    str = "VARCHAR(" + precision * 3 + ")";
                    break;
                }
                str = "VARCHAR(2000)";
                break;
            }
            case 2: 
            case 3: {
                if (precision > 0) {
                    str = "NUMERIC(" + precision;
                    if (scale > 0) {
                        str = str + ", " + scale;
                    }
                    str = str + ")";
                    break;
                }
                str = "FLOAT(53)";
                break;
            }
            case 6: 
            case 8: {
                str = "FLOAT";
                if (precision <= 0) break;
                str = str + "(" + precision + ")";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                str = "DATETIME";
                break;
            }
            default: {
                throw new RuntimeException("Unsupport data type:" + columnType);
            }
        }
        return str;
    }

    public static String getOracleColumnDefine(int columnType, int precision, int scale) {
        String str;
        switch (columnType) {
            case 16: {
                str = "CHAR(1)";
                break;
            }
            case -7: 
            case -5: 
            case 4: {
                str = "INT";
                break;
            }
            case -6: 
            case 5: {
                str = "INT";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (precision > 0) {
                    str = "VARCHAR2(" + precision * 3 + ")";
                    break;
                }
                str = "VARCHAR2(2000)";
                break;
            }
            case 2: 
            case 3: {
                str = "NUMBER";
                if (precision <= 0) break;
                str = str + "(" + precision;
                if (scale > 0) {
                    str = str + ", " + scale;
                }
                str = str + ")";
                break;
            }
            case 6: 
            case 8: {
                str = "FLOAT";
                if (precision <= 0) break;
                str = str + "(" + precision + ")";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                str = "DATE";
                break;
            }
            default: {
                throw new RuntimeException("Unsupport data type:" + columnType);
            }
        }
        return str;
    }

    public static String getDB2ColumnDefine(int columnType, int precision, int scale) {
        String str;
        switch (columnType) {
            case 16: {
                str = "CHARACTER(1)";
                break;
            }
            case -7: 
            case -5: 
            case 4: {
                str = "INT";
                break;
            }
            case -6: 
            case 5: {
                str = "SMALLINT";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (precision > 0) {
                    str = "VARCHAR(" + precision * 3 + ")";
                    break;
                }
                str = "VARCHAR(2000)";
                break;
            }
            case 2: 
            case 3: {
                if (precision > 0) {
                    str = "DECIMAL(" + precision;
                    if (scale > 0) {
                        str = str + ", " + scale;
                    }
                    str = str + ")";
                    break;
                }
                str = "FLOAT";
                break;
            }
            case 6: 
            case 8: {
                str = "FLOAT";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                str = "TIMESTAMP";
                break;
            }
            default: {
                throw new RuntimeException("Unsupport data type:" + columnType);
            }
        }
        return str;
    }

    public static String formatDateValue(DBType dbType, Date date) {
        StringBuffer sb = new StringBuffer();
        sb.append("TO_DATE('");
        sb.append(date.toString());
        sb.append("')");
        return sb.toString();
    }
}

