/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.swing.KDResourcePath;
import com.kingdee.bos.ctrl.swing.plaf.lfm.KDFontUIResource;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Properties;

public class KDFont
extends Font {
    private static final long serialVersionUID = -5008956562051634709L;
    private static Properties fontProperties = null;
    private static String[] sysFamilyName;
    private static float fontScale;
    private int realSize;
    private static boolean isTableMode;
    private static boolean isFormDrawing;
    private Font formFont = null;

    public KDFont(String name, int style, int size) {
        super(name, style, Math.round((float)size * fontScale));
        this.realSize = size;
    }

    public KDFont(Map attributes) {
        super(attributes);
        Object obj = attributes.get(TextAttribute.SIZE);
        if (obj instanceof Integer) {
            this.realSize = (Integer)obj;
            this.realSize = Math.round((float)this.realSize / fontScale);
        }
    }

    @Override
    public int getSize() {
        return this.realSize;
    }

    public int getDrawingSize() {
        return super.getSize();
    }

    public Font deriveFont(Map attributes) {
        Map<TextAttribute, ?> newAttrs = this.getAttributes();
        AttributedCharacterIterator.Attribute[] validAttribs = this.getAvailableAttributes();
        for (int i = 0; i < validAttribs.length; ++i) {
            Object obj = attributes.get(validAttribs[i]);
            if (obj == null) continue;
            newAttrs.put((TextAttribute)validAttribs[i], obj);
        }
        return new KDFont(newAttrs);
    }

    public static void setTableMode(boolean is) {
        isTableMode = is;
    }

    public static void setFormDrawing(boolean is) {
        isFormDrawing = is;
    }

    public Font getFont() {
        if (isTableMode || !isFormDrawing) {
            return this;
        }
        if (this.formFont == null) {
            this.formFont = this.deriveFont((float)this.realSize);
        }
        return this.formFont;
    }

    public static Font createFont(String name, int style, int size) {
        Font font = null;
        try {
            font = KDFont.isSystemDefineFont(name) ? new Font(name, style, Math.round((float)size * fontScale)) : KDFont.loadFont(name, style, size);
        }
        catch (Exception e) {
            font = KDFont.loadFont(name, style, size);
        }
        return font;
    }

    public static Font createFont(Map attributes) {
        String name = (String)attributes.get(TextAttribute.FAMILY);
        int style = 0;
        Font font = null;
        try {
            if (KDFont.isSystemDefineFont(name)) {
                font = new Font(attributes);
            } else {
                float pointSize = ((Float)attributes.get(TextAttribute.SIZE)).floatValue();
                int size = (int)((double)pointSize + 0.5);
                Object obj = attributes.get(TextAttribute.WEIGHT);
                if (obj != null && obj.equals(TextAttribute.WEIGHT_BOLD)) {
                    style |= 1;
                }
                if ((obj = attributes.get(TextAttribute.POSTURE)) != null && obj.equals(TextAttribute.POSTURE_OBLIQUE)) {
                    style |= 2;
                }
                font = KDFont.loadFont(name, style, size);
            }
        }
        catch (Exception e) {
            float pointSize = ((Float)attributes.get(TextAttribute.SIZE)).floatValue();
            int size = (int)((double)pointSize + 0.5);
            Object obj = attributes.get(TextAttribute.WEIGHT);
            if (obj != null && obj.equals(TextAttribute.WEIGHT_BOLD)) {
                style |= 1;
            }
            if ((obj = attributes.get(TextAttribute.POSTURE)) != null && obj.equals(TextAttribute.POSTURE_OBLIQUE)) {
                style |= 2;
            }
            font = KDFont.loadFont(name, style, size);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font loadFont(String name, int style, int size) {
        try {
            String filePath = System.getProperty("user.dir");
            String fileSeparator = System.getProperty("file.separator");
            String fileName = "";
            if (fontProperties == null) {
                fileName = filePath + fileSeparator + "font" + fileSeparator + "fonts.properties";
                File file = new File(fileName);
                if (!file.exists()) {
                    KDResourcePath rp = new KDResourcePath();
                    fileName = rp.getFontPropertyPath() + "fonts.properties";
                }
                fontProperties = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fileName);
                    fontProperties.load(fis);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable(fis);
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable)fis);
            }
            fileName = filePath + fileSeparator + "font" + fileSeparator + fontProperties.getProperty(name);
            Font font = Font.createFont(0, new File(fileName));
            font = font.deriveFont(style, size);
            return font;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isSystemDefineFont(String name) {
        if (sysFamilyName == null || sysFamilyName.length != 0) {
            sysFamilyName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        for (int i = 0; i < sysFamilyName.length; ++i) {
            if (!sysFamilyName[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    static {
        fontScale = KDFontUIResource.fontScale;
        isTableMode = false;
        isFormDrawing = false;
    }
}

