/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.DefaultCtrlComponentSize;
import com.kingdee.bos.ctrl.swing.KDArrowButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboBoxItem;
import com.kingdee.bos.ctrl.swing.KDComboBoxMultiColumnItem;
import com.kingdee.bos.ctrl.swing.plaf.KDComboPopup;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ctrl.swing.util.ChineseInital;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class KingdeeComboBoxUI
extends BasicComboBoxUI {
    PropertyChangeListener propertyChangeHandler = null;
    private ChangeHandler changeHandler = null;
    private ClosePopupFocusListener closePopupHandler = new ClosePopupFocusListener();
    private boolean canSearch = false;
    private boolean limitedSize = true;
    private boolean required = false;
    private boolean readOnly = false;
    private boolean editable = false;
    private static Action homeAction = new NavigationalAction(36);
    private static Action endAction = new NavigationalAction(35);
    private static Action pgUpAction = new NavigationalAction(33);
    private static Action pgDownAction = new NavigationalAction(34);
    private int defaultRowCount = 10;
    private Object lastSelected;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void setDefaultRowCount(int rowCount) {
        this.defaultRowCount = rowCount;
    }

    public void setAppendButtonVisible(boolean visible) {
        if (this.popup instanceof KDComboPopup) {
            ((KDComboPopup)this.popup).setAppendButtonVisible(true);
        }
    }

    public void setComboPopupWidth(int pixel) {
        if (this.popup instanceof KDComboPopup) {
            ((KDComboPopup)this.popup).setComboPopupWidth(pixel);
        }
    }

    public int getComboPopupWidth() {
        if (this.popup instanceof KDComboPopup) {
            return ((KDComboPopup)this.popup).getComboPopupWidth();
        }
        return -1;
    }

    @Override
    protected ComboPopup createPopup() {
        KDComboPopup popup = new KDComboPopup(this.comboBox);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        popup.setBorder(BorderFactory.createLineBorder(UIManager.getColor("ComboBox.popupBorderLineColor")));
        return popup;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.propertyChangeHandler != null) {
            this.comboBox.removePropertyChangeListener("limitedSize", this.propertyChangeHandler);
            this.propertyChangeHandler = null;
        }
        ComboBoxEditor edt = this.comboBox.getEditor();
        JComponent comp = (JComponent)edt.getEditorComponent();
        if (this.changeHandler != null) {
            ((JTextField)comp).getDocument().removeDocumentListener(this.changeHandler);
        }
        comp.removeFocusListener(this.closePopupHandler);
        this.comboBox.getInputMap().remove(KeyStroke.getKeyStroke(127, 128));
        this.comboBox.getActionMap().remove("ClearItem");
        comp.getInputMap().remove(KeyStroke.getKeyStroke(127, 128));
        comp.getActionMap().remove("ClearItem");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new PropertyChangeHandler();
            this.comboBox.addPropertyChangeListener(this.propertyChangeHandler);
        }
        ComboBoxEditor edt = this.comboBox.getEditor();
        JComponent comp = (JComponent)edt.getEditorComponent();
        if (this.comboBox instanceof KDComboBox && ((KDComboBox)this.comboBox).isCanSearch()) {
            this.changeHandler = new ChangeHandler();
            ((JTextField)comp).getDocument().addDocumentListener(this.changeHandler);
        }
        comp.addFocusListener(this.closePopupHandler);
        this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(127, 128), "ClearItem");
        this.comboBox.getActionMap().put("ClearItem", new ClearAction());
        comp.getInputMap().put(KeyStroke.getKeyStroke(127, 128), "ClearItem");
        comp.getActionMap().put("ClearItem", new ClearAction());
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.arrowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KingdeeComboBoxUI.this.buildListData(true);
            }
        });
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        Rectangle r = this.nrectangleForCurrentValue();
        Rectangle r2 = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g, r, this.hasFocus);
        this.paintCurrentValue(g, r2, this.hasFocus);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean isSelected;
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Object selectedItem = this.comboBox.getSelectedItem();
        if (this.comboBox instanceof KDComboBox) {
            selectedItem = ((KDComboBox)this.comboBox).getSelectedItemDesensitization();
            if (((KDComboBox)this.comboBox).getAccessAuthority() == 2) {
                selectedItem = KDResourceManager.getMLS("noPerm", "\u65e0\u6743\u9650");
            }
        }
        if ((c = renderer.getListCellRendererComponent(this.listBox, selectedItem, -1, isSelected = false, false)) == null) {
            return;
        }
        if (!isSelected) {
            c.setBackground(UIManager.getColor("TextField.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getSelectionForeground());
            c.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox instanceof KDComboBox && ((KDComboBox)this.comboBox).getAccessAuthority() == 1) {
            c.setForeground(UIManager.getColor("TextField.readonlyForeground"));
            c.setBackground(UIManager.getColor("TextField.readonlyBackground"));
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(UIManager.getColor("TextField.foreground"));
            c.setBackground(UIManager.getColor("TextField.background"));
            if (this.required) {
                if (this.comboBox.isEditable()) {
                    c.setForeground(UIManager.getColor("TextField.background"));
                    this.editor.setBackground(UIManager.getColor("TextField.requiredBackground"));
                } else {
                    c.setForeground(UIManager.getColor("TextField.unEditabledFg"));
                    c.setBackground(UIManager.getColor("TextField.requiredBackground"));
                }
            } else if (this.comboBox.isEditable()) {
                c.setForeground(UIManager.getColor("TextField.foreground"));
                this.editor.setBackground(UIManager.getColor("TextField.background"));
            } else {
                c.setForeground(UIManager.getColor("TextField.unEditabledFg"));
                c.setBackground(UIManager.getColor("TextField.background"));
            }
        } else {
            c.setForeground(UIManager.getColor("TextField.disableForeground"));
            c.setBackground(UIManager.getColor("TextField.disableBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    @Override
    protected JButton createArrowButton() {
        return new KDArrowButton(5);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return DefaultCtrlComponentSize.getComboBoxDefaultPreSize();
    }

    public void setLimitedSize(boolean newValue) {
        this.limitedSize = newValue;
    }

    public boolean isLimitedSize() {
        return this.limitedSize;
    }

    public boolean isCanSearch() {
        return this.canSearch;
    }

    public void setCanSearch(boolean canSearch) {
        if (this.canSearch == canSearch) {
            return;
        }
        this.canSearch = canSearch;
        ComboBoxEditor edt = this.comboBox.getEditor();
        if (this.comboBox instanceof KDComboBox) {
            if (canSearch) {
                this.changeHandler = new ChangeHandler();
                ComboBoxEditor cedt = edt;
                ((JTextField)cedt.getEditorComponent()).getDocument().addDocumentListener(this.changeHandler);
                ((JTextField)cedt.getEditorComponent()).setToolTipText(KDResourceManager.getMLS("pinYinFirstSearch", "\u6309\u9996\u5b57\u6bcd\u641c\u7d22"));
            } else {
                ComboBoxEditor cedt = edt;
                ((JTextField)cedt.getEditorComponent()).setToolTipText("");
                if (this.changeHandler != null) {
                    ((JTextField)cedt.getEditorComponent()).getDocument().removeDocumentListener(this.changeHandler);
                }
            }
        }
    }

    protected Rectangle nrectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = this.arrowButton.getWidth();
        }
        if (this.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left - 1, insets.top, width - (insets.left + insets.right + buttonSize) + 1, height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize - 1, insets.top, width - (insets.left + insets.right + buttonSize) + 1, height - (insets.top + insets.bottom));
    }

    private boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    @Override
    protected void selectNextPossibleValue() {
        int selectedIndex = -1;
        int itemCount = this.listBox.getModel().getSize();
        selectedIndex = this.listBox.getSelectedIndex();
        if (selectedIndex < itemCount - 1) {
            ++selectedIndex;
        }
        this.listBox.setSelectedIndex(selectedIndex);
        this.listBox.ensureIndexIsVisible(selectedIndex);
        this.comboBox.repaint();
    }

    @Override
    protected void selectPreviousPossibleValue() {
        int selectedIndex = -1;
        selectedIndex = this.listBox.getSelectedIndex();
        if (selectedIndex > 0) {
            --selectedIndex;
        }
        this.listBox.setSelectedIndex(selectedIndex);
        this.listBox.ensureIndexIsVisible(selectedIndex);
        this.comboBox.repaint();
    }

    @Override
    protected void installKeyboardActions() {
        InputMap km = this.getInputMap2(1);
        km.put(KeyStroke.getKeyStroke(37, 0), "selectPrevious");
        km.put(KeyStroke.getKeyStroke(39, 0), "selectNext");
        km.put(KeyStroke.getKeyStroke(109, 0), "selectPrevious");
        km.put(KeyStroke.getKeyStroke(107, 0), "selectNext");
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, km);
        ActionMap am = this.getActionMap2();
        if (am != null) {
            SwingUtilities.replaceUIActionMap(this.comboBox, am);
        }
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
        SwingUtilities.replaceUIActionMap(this.comboBox, null);
    }

    InputMap getInputMap2(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("ComboBox.ancestorInputMap");
        }
        return null;
    }

    private ActionMap getActionMap2() {
        return this.createActionMap2();
    }

    private ActionMap createActionMap2() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("hidePopup", new HidePopupAction());
        map.put("pageDownPassThrough", pgDownAction);
        map.put("pageUpPassThrough", pgUpAction);
        map.put("homePassThrough", homeAction);
        map.put("endPassThrough", endAction);
        map.put("selectNext", new DownAction());
        map.put("togglePopup", new AltAction());
        map.put("spacePopup", new SpaceAction());
        map.put("selectPrevious", new UpAction());
        map.put("enterPressed", new EnterAction());
        return map;
    }

    public int getItemIndex(Object item) {
        if (item == null) {
            return -1;
        }
        ComboBoxModel model = this.comboBox.getModel();
        int count = model.getSize();
        Object itemData = null;
        for (int i = 0; i < count; ++i) {
            String value;
            String text;
            itemData = model.getElementAt(i);
            if (item.equals(itemData)) {
                return i;
            }
            if (itemData == null || !(item instanceof String) || !(text = (String)item).equals(value = itemData.toString())) continue;
            return i;
        }
        return -1;
    }

    public void validateInputValue() {
        if (this.canSearch) {
            String editorText = ((JTextField)this.comboBox.getEditor().getEditorComponent()).getText();
            int itemIndex = this.getItemIndex(editorText);
            int selectedIndex = this.comboBox.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.lastSelected = this.comboBox.getSelectedItem();
            }
            if (itemIndex >= 0) {
                this.comboBox.setSelectedItem(this.comboBox.getModel().getElementAt(itemIndex));
            } else {
                ((JTextField)this.comboBox.getEditor().getEditorComponent()).setText("");
            }
        }
    }

    public void setPopupVisible(JComboBox c, boolean v) {
        if (v) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    private boolean buildListData() {
        ComboBoxModel cmbModel = this.comboBox.getModel();
        if (!this.canSearch) {
            this.listBox.setModel(cmbModel);
            return true;
        }
        int itemCount = cmbModel.getSize();
        Object itemData = null;
        String editorText = ((JTextField)this.comboBox.getEditor().getEditorComponent()).getText().trim();
        String lowerCaseEditorText = editorText.toLowerCase();
        Vector<Object> vListData = new Vector<Object>();
        if ("".equals(editorText) || editorText == null) {
            if (this.canSearch) {
                this.comboBox.setMaximumRowCount(this.defaultRowCount);
                this.listBox.setModel(cmbModel);
            }
            return true;
        }
        for (int i = 0; i < itemCount; ++i) {
            String trim;
            itemData = cmbModel.getElementAt(i);
            if (itemData == null) continue;
            if (itemData instanceof KDComboBoxItem) {
                KDComboBoxItem cmbItem = (KDComboBoxItem)itemData;
                trim = cmbItem.toString().toLowerCase().trim();
                String letters = ChineseInital.getAllFirstLetter(trim);
                if (cmbItem.toString() == null || trim.indexOf(lowerCaseEditorText) == -1 && letters.indexOf(lowerCaseEditorText) == -1) continue;
                vListData.addElement(itemData);
                continue;
            }
            if (itemData instanceof KDComboBoxMultiColumnItem) {
                String[] columns = lowerCaseEditorText.split("  ");
                if (columns.length > 1) {
                    trim = itemData.toString().trim().toLowerCase();
                    String letters = ChineseInital.getAllFirstLetter(trim);
                    if (trim.indexOf(lowerCaseEditorText) == -1 && letters.indexOf(lowerCaseEditorText) == -1) continue;
                    vListData.addElement(itemData);
                    continue;
                }
                KDComboBoxMultiColumnItem cmbItem = (KDComboBoxMultiColumnItem)itemData;
                boolean isSizeUp = false;
                String[] values = cmbItem.getVlaues();
                for (int m = 0; m < values.length; ++m) {
                    String trim2 = values[m].toLowerCase().trim();
                    String letters = ChineseInital.getAllFirstLetter(trim2);
                    isSizeUp = isSizeUp || trim2.indexOf(lowerCaseEditorText) != -1 || letters.indexOf(lowerCaseEditorText) != -1;
                }
                if (!isSizeUp) continue;
                vListData.addElement(itemData);
                continue;
            }
            String itemStr = itemData.toString();
            trim = itemStr == null ? "" : itemStr.trim().toLowerCase();
            String letters = ChineseInital.getAllFirstLetter(trim);
            if (trim.indexOf(lowerCaseEditorText) == -1 && letters.indexOf(lowerCaseEditorText) == -1) continue;
            vListData.addElement(itemData);
        }
        int dataSize = vListData.size();
        if (dataSize < this.defaultRowCount) {
            this.comboBox.setMaximumRowCount(dataSize);
        } else {
            this.comboBox.setMaximumRowCount(this.defaultRowCount);
        }
        this.listBox.setListData(vListData);
        return dataSize > 0;
    }

    private boolean buildListData(boolean supportfiter) {
        if (!supportfiter) {
            return this.buildListData();
        }
        ComboBoxModel cmbModel = this.comboBox.getModel();
        if (!this.canSearch) {
            this.listBox.setModel(cmbModel);
            return true;
        }
        int itemCount = cmbModel.getSize();
        Object itemData = null;
        String editorText = "";
        String lowerCaseEditorText = editorText.toLowerCase();
        Vector<Object> vListData = new Vector<Object>();
        if ("".equals(editorText) || editorText == null) {
            if (this.canSearch) {
                this.comboBox.setMaximumRowCount(this.defaultRowCount);
                this.listBox.setModel(cmbModel);
            }
            return true;
        }
        for (int i = 0; i < itemCount; ++i) {
            String trim;
            itemData = cmbModel.getElementAt(i);
            if (itemData == null) continue;
            if (itemData instanceof KDComboBoxItem) {
                KDComboBoxItem cmbItem = (KDComboBoxItem)itemData;
                trim = cmbItem.toString().toLowerCase().trim();
                String letters = ChineseInital.getAllFirstLetter(trim);
                if (cmbItem.toString() == null || trim.indexOf(lowerCaseEditorText) == -1 && letters.indexOf(lowerCaseEditorText) == -1) continue;
                vListData.addElement(itemData);
                continue;
            }
            if (itemData instanceof KDComboBoxMultiColumnItem) {
                String[] columns = lowerCaseEditorText.split("  ");
                if (columns.length > 1) {
                    trim = itemData.toString().trim().toLowerCase();
                    String letters = ChineseInital.getAllFirstLetter(trim);
                    if (trim.indexOf(lowerCaseEditorText) == -1 && letters.indexOf(lowerCaseEditorText) == -1) continue;
                    vListData.addElement(itemData);
                    continue;
                }
                KDComboBoxMultiColumnItem cmbItem = (KDComboBoxMultiColumnItem)itemData;
                boolean isSizeUp = false;
                String[] values = cmbItem.getVlaues();
                for (int m = 0; m < values.length; ++m) {
                    String trim2 = values[m].toLowerCase().trim();
                    String letters = ChineseInital.getAllFirstLetter(trim2);
                    isSizeUp = isSizeUp || trim2.indexOf(lowerCaseEditorText) != -1 || letters.indexOf(lowerCaseEditorText) != -1;
                }
                if (!isSizeUp) continue;
                vListData.addElement(itemData);
                continue;
            }
            String trim3 = itemData.toString().trim().toLowerCase();
            String letters = ChineseInital.getAllFirstLetter(trim3);
            if (trim3.indexOf(lowerCaseEditorText) == -1 && letters.indexOf(lowerCaseEditorText) == -1) continue;
            vListData.addElement(itemData);
        }
        int dataSize = vListData.size();
        if (dataSize < this.defaultRowCount) {
            this.comboBox.setMaximumRowCount(dataSize);
        } else {
            this.comboBox.setMaximumRowCount(this.defaultRowCount);
        }
        this.listBox.setListData(vListData);
        return dataSize > 0;
    }

    class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = -6501065160241745365L;

        ClearAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((KDComboBox)KingdeeComboBoxUI.this.comboBox).getAccessAuthority() != 1) {
                KingdeeComboBoxUI.this.comboBox.setSelectedIndex(-1);
            }
        }
    }

    protected class ChangeHandler
    implements DocumentListener {
        protected ChangeHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (KingdeeComboBoxUI.this.comboBox.getPeer() != null) {
                this.doDataChange(e);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (KingdeeComboBoxUI.this.comboBox.getPeer() != null) {
                this.doDataChange(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (KingdeeComboBoxUI.this.comboBox.getPeer() != null) {
                this.doDataChange(e);
            }
        }

        public void doDataChange(DocumentEvent e) {
            boolean isControlKey = ((KDComboBox)KingdeeComboBoxUI.this.comboBox).isControlKey();
            if (isControlKey) {
                return;
            }
            if (KingdeeComboBoxUI.this.listBox != null) {
                if (KingdeeComboBoxUI.this.buildListData()) {
                    KingdeeComboBoxUI.this.comboBox.setPopupVisible(true);
                    KingdeeComboBoxUI.this.listBox.setSelectedIndex(0);
                    KingdeeComboBoxUI.this.listBox.ensureIndexIsVisible(0);
                } else {
                    KingdeeComboBoxUI.this.comboBox.setPopupVisible(false);
                }
            }
        }
    }

    public class ComboBoxItemHandler
    extends BasicComboBoxUI.ItemHandler {
        public ComboBoxItemHandler() {
            super(KingdeeComboBoxUI.this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            throw new RuntimeException("\u4ee3\u7801\u91cd\u6784\u4e2d\u53d1\u73b0\u8be5ItemHandler\u5185\u90e8\u7c7b\u6ca1\u6709\u5728\u4efb\u4f55\u63a7\u4ef6\u90e8\u5de5\u7a0b\u4e2d\u88ab\u5f15\u7528,\u56e0\u6b64\u5e9f\u5f03\u6389\u5e76\u629b\u51fa\u672c\u8fd0\u884c\u65f6\u5f02\u5e38\u3002\u5982\u679c\u60a8\u770b\u5230\u8be5\u4fe1\u606f\uff0c\u4e14\u65e0\u6cd5\u5c4f\u853d\u6389\u8be5\u7c7b\u7684\u4f7f\u7528\uff0c\u8bf7\u4e0e\u63a7\u4ef6\u90e8\u5b8b\u5927\u4f1f\u8054\u7cfb\uff0c\u5206\u673a8059\u3002");
        }
    }

    private class ClosePopupFocusListener
    implements FocusListener {
        private ClosePopupFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (KingdeeComboBoxUI.this.canSearch) {
                ((JTextField)KingdeeComboBoxUI.this.comboBox.getEditor().getEditorComponent()).selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            KingdeeComboBoxUI.this.validateInputValue();
            KingdeeComboBoxUI.this.comboBox.setPopupVisible(false);
        }
    }

    private class HidePopupAction
    extends AbstractAction {
        private static final long serialVersionUID = -6274336326559185186L;

        private HidePopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                comboBox.firePopupMenuCanceled();
                comboBox.setPopupVisible(false);
            }
        }

        @Override
        public boolean isEnabled() {
            return KingdeeComboBoxUI.this.comboBox.isPopupVisible();
        }
    }

    private static class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = 7923900369068529274L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                KingdeeComboBoxUI ui = (KingdeeComboBoxUI)comboBox.getUI();
                if (ui.isPopupVisible(comboBox)) {
                    ui.selectPreviousPossibleValue();
                } else {
                    ui.setPopupVisible(comboBox, true);
                    comboBox.setMaximumRowCount(comboBox.getMaximumRowCount());
                }
            }
        }
    }

    private static class SpaceAction
    extends AltAction {
        private static final long serialVersionUID = 7483831635089871755L;

        private SpaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (!comboBox.isEditable()) {
                super.actionPerformed(e);
            }
        }
    }

    private static class AltAction
    extends AbstractAction {
        private static final long serialVersionUID = -3369591698463447847L;

        private AltAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                comboBox.setPopupVisible(!comboBox.isPopupVisible());
            }
        }
    }

    private static class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = -6880689168079677403L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = -1;
            int itemCount = 0;
            KDComboBox comboBox = (KDComboBox)e.getSource();
            boolean notReadOnly = false;
            boolean bl = notReadOnly = comboBox.getAccessAuthority() != 1;
            if (!comboBox.isEnabled()) {
                return;
            }
            KingdeeComboBoxUI ui = (KingdeeComboBoxUI)comboBox.getUI();
            selectedIndex = ui.popup.getList().getSelectedIndex();
            if (comboBox.isPopupVisible()) {
                if (selectedIndex == -1) {
                    comboBox.setPopupVisible(false);
                } else {
                    boolean canSearch = comboBox.isCanSearch();
                    if (canSearch) {
                        comboBox.setControlKey(true);
                        itemCount = comboBox.getItemCount();
                        Object selectedItem = ui.popup.getList().getSelectedValue();
                        for (int i = 0; i < itemCount; ++i) {
                            if (selectedItem == null || !selectedItem.equals(comboBox.getItemAt(i))) continue;
                            if (!notReadOnly) break;
                            comboBox.setSelectedIndex(i);
                            break;
                        }
                        comboBox.setControlKey(false);
                    } else if (notReadOnly) {
                        comboBox.setSelectedIndex(selectedIndex);
                    }
                    comboBox.setPopupVisible(false);
                }
            } else {
                JRootPane root = SwingUtilities.getRootPane(comboBox);
                if (root != null) {
                    Action action;
                    Object obj;
                    InputMap im = root.getInputMap(2);
                    ActionMap am = root.getActionMap();
                    if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = am.get(obj)) != null) {
                        e.setSource(root);
                        action.actionPerformed(e);
                    }
                }
            }
            boolean isAutoFocusNextComponent = comboBox.isAutoFocusNextComponent();
            if (isAutoFocusNextComponent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        }
    }

    private static class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = 4448312371472628623L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                KingdeeComboBoxUI ui = (KingdeeComboBoxUI)comboBox.getUI();
                if (ui.isPopupVisible(comboBox)) {
                    ui.selectNextPossibleValue();
                } else {
                    ui.setPopupVisible(comboBox, true);
                    comboBox.setMaximumRowCount(comboBox.getMaximumRowCount());
                }
            }
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        private static final long serialVersionUID = -5653209220560921940L;
        int keyCode;

        NavigationalAction(int keyCode) {
            this.keyCode = keyCode;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JComboBox comboBox = (JComboBox)ev.getSource();
            int index = this.getNextIndex(comboBox);
            if (index >= 0 && index < comboBox.getItemCount()) {
                comboBox.setSelectedIndex(index);
            }
        }

        int getNextIndex(JComboBox comboBox) {
            switch (this.keyCode) {
                case 33: {
                    int listHeight = comboBox.getMaximumRowCount();
                    int index = comboBox.getSelectedIndex() - listHeight;
                    return index < 0 ? 0 : index;
                }
                case 34: {
                    int listHeight = comboBox.getMaximumRowCount();
                    int index = comboBox.getSelectedIndex() + listHeight;
                    int max = comboBox.getItemCount();
                    return index < max ? index : max - 1;
                }
                case 36: {
                    return 0;
                }
                case 35: {
                    return comboBox.getItemCount() - 1;
                }
            }
            return comboBox.getSelectedIndex();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String proName = evt.getPropertyName();
            Component c = (Component)evt.getSource();
            if ("limitedSize".equals(proName)) {
                KingdeeComboBoxUI.this.setLimitedSize((Boolean)evt.getNewValue());
                if (KingdeeComboBoxUI.this.comboBox instanceof KDComboBox) {
                    ((KDComboBox)KingdeeComboBoxUI.this.comboBox).adjustDimension();
                }
            } else if (evt.getPropertyName().equals("required")) {
                if (evt.getNewValue() != evt.getOldValue()) {
                    KingdeeComboBoxUI.this.required = (Boolean)evt.getNewValue();
                    c.repaint();
                }
            } else if (evt.getPropertyName().equals("readOnly")) {
                if (evt.getNewValue() != evt.getOldValue()) {
                    KingdeeComboBoxUI.this.readOnly = (Boolean)evt.getNewValue();
                    c.repaint();
                }
            } else if (evt.getPropertyName().equals("editable")) {
                if (evt.getNewValue() != evt.getOldValue()) {
                    KingdeeComboBoxUI.this.editable = (Boolean)evt.getNewValue();
                    c.repaint();
                }
            } else if (evt.getPropertyName().equals("appendButtonHandler") && evt.getNewValue() != evt.getOldValue() && KingdeeComboBoxUI.this.popup instanceof KDComboPopup) {
                ((KDComboPopup)KingdeeComboBoxUI.this.popup).setAppendButtonHandler((ActionListener)evt.getNewValue(), (ActionListener)evt.getOldValue());
            }
        }
    }
}

