/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.plaf.MultiLangListCellRendererUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class MultiLangListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = -5105458330241073404L;
    protected static final Color SELECTEDBACK = new Color(2449058);
    protected static final Color UNSELECTEDBACK = new Color(0xF9F9F9);
    protected static final Border NOFOCUSBORDER = new EmptyBorder(1, 1, 1, 1);
    private JComponent compWidthDetermination;

    @Override
    public int getWidth() {
        return this.compWidthDetermination.getWidth();
    }

    private void setCompWidthDetermination(JComponent c) {
        this.compWidthDetermination = c;
    }

    @Override
    public void updateUI() {
        this.setUI(MultiLangListCellRendererUI.createUI(this));
        this.setBackground(UNSELECTEDBACK);
    }

    public MultiLangListCellRenderer(JComponent comp, JComponent iconRoom) {
        this.setCompWidthDetermination(comp);
        this.setOpaque(true);
        this.setBorder(NOFOCUSBORDER);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(SELECTEDBACK);
            this.setForeground(Color.WHITE);
        } else {
            this.setBackground(UNSELECTEDBACK);
            this.setForeground(Color.BLACK);
        }
        if (value instanceof MultiLangItem) {
            MultiLangItem val = (MultiLangItem)value;
            this.setIcon(val.getIcon());
            String str = "";
            if (val.getData() != null) {
                str = val.getData().toString();
            }
            if (str.length() < 1) {
                str = val.getLang().getDisplayName(MultiLangListCellRenderer.getDefaultLocale());
                this.setForeground(Color.GRAY);
            }
            this.setText(str);
        } else if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else {
            this.setText(value == null ? "" : value.toString());
        }
        return this;
    }
}

