/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.logic;

import com.kingdee.bos.ctrl.workbench.logic.TrimWidgetManager;
import com.kingdee.bos.ctrl.workbench.ui.IDockable;
import com.kingdee.bos.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.bos.ctrl.workbench.ui.ITrimWidgetDndDelegate;
import com.kingdee.bos.ctrl.workbench.ui.Perspective;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class TrimWidgetDnD
implements MouseInputListener {
    private static TrimWidgetDnD dndCapabilities = new TrimWidgetDnD();
    private int tobePositioned = -1;
    private ITrimWidget source;
    private IDockable target;
    private Perspective perspective;

    private TrimWidgetDnD() {
    }

    public static void installDndCapablilities(ITrimWidget trimWidget) {
        ITrimWidgetDndDelegate dndDelegate = trimWidget.getDndDelegate();
        if (!(dndDelegate instanceof Component)) {
            throw new IllegalArgumentException("DndDelegate must be a subclass of java.awt.Component.");
        }
        Component ref = (Component)((Object)dndDelegate);
        ref.addMouseListener(dndCapabilities);
        ref.addMouseMotionListener(dndCapabilities);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            Object delegate = e.getSource();
            if (!(delegate instanceof ITrimWidgetDndDelegate)) {
                return;
            }
            if (this.perspective.isExclusiveView()) {
                this.perspective.showAllInclusions();
            } else {
                this.perspective.setExclusiveTrim(((ITrimWidgetDndDelegate)delegate).getTrimWidget());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Object delegate = e.getSource();
        if (!(delegate instanceof ITrimWidgetDndDelegate)) {
            return;
        }
        this.source = ((ITrimWidgetDndDelegate)delegate).getTrimWidget();
        this.perspective = this.getDirectlyUnderPerspective(this.source);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Object delegate = e.getSource();
        if (!(delegate instanceof ITrimWidgetDndDelegate)) {
            return;
        }
        if (this.tobePositioned == -1) {
            return;
        }
        TrimWidgetManager twm = this.perspective.getTrimWidgetManager();
        twm.removeTrim(this.source);
        if (this.target instanceof Perspective) {
            twm.addTrim(this.tobePositioned, this.source, null);
        } else {
            twm.addTrim(this.tobePositioned, this.source, (ITrimWidget)this.target);
        }
        this.resetDndContext();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.perspective.showAllInclusions();
        Object delegate = e.getSource();
        if (!(delegate instanceof ITrimWidgetDndDelegate)) {
            return;
        }
        Point wpp = SwingUtilities.convertPoint((Component)((Object)this.source), e.getPoint(), this.perspective);
        IDockable node = null;
        boolean preemptive = this.checkRelativeToWorkbench(wpp);
        node = preemptive ? this.perspective : this.getToppestTrimWidgetAt(this.perspective, (int)wpp.getX(), (int)wpp.getY());
        if (node == null || node == this.source) {
            if (this.target != null) {
                this.target.dockingTo(-1);
            }
            this.tobePositioned = -1;
            return;
        }
        if (this.target != null && this.target != node) {
            this.target.dockingTo(-1);
        }
        this.target = node;
        this.prepositionTrimWidget(SwingUtilities.convertPoint((Component)((Object)this.source), e.getPoint(), (Component)((Object)this.target)));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void resetDndContext() {
        this.source = null;
        if (this.target != null) {
            this.target.dockingTo(-1);
        }
        this.target = null;
        this.tobePositioned = -1;
        this.perspective = null;
    }

    private boolean checkRelativeToWorkbench(Point point) {
        boolean result = false;
        int width = this.perspective.getWidth();
        int height = this.perspective.getHeight();
        int px = (int)point.getX();
        int py = (int)point.getY();
        if (px < 2 && py > 0 && py < height || px > width - 3 && py > 0 && py < height || py < 2 && px > 0 && px < width || py > height - 3 && px > 0 && px < width) {
            result = true;
        }
        return result;
    }

    private void prepositionTrimWidget(Point point) {
        int width = ((Component)((Object)this.target)).getWidth();
        int height = ((Component)((Object)this.target)).getHeight();
        int px = (int)point.getX();
        int py = (int)point.getY();
        if (this.target instanceof ITrimWidget) {
            int dockx = (int)((double)width * 0.2);
            int docky = (int)((double)height * 0.2);
            this.tobePositioned = px > 0 && px < dockx ? 3 : (px > width - dockx && px < width ? 4 : (py > 0 && py < docky ? 1 : (py > height - docky && py < height ? 2 : -1)));
        } else if (this.target instanceof Perspective) {
            this.tobePositioned = px < 2 && py > 0 && py < height ? 3 : (px > width - 3 && py > 0 && py < height ? 4 : (py < 2 && px > 0 && px < width ? 1 : (py > height - 3 && px > 0 && px < width ? 2 : -1)));
        }
        this.target.dockingTo(this.tobePositioned);
    }

    private ITrimWidget getToppestTrimWidgetAt(Container parent, int x, int y) {
        Component[] components = parent.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            Point loc = comp.getLocation();
            int tx = x - loc.x;
            int ty = y - loc.y;
            if (comp == null || !comp.isVisible() || !comp.contains(tx, ty)) continue;
            if (comp instanceof ITrimWidget) {
                return (ITrimWidget)((Object)comp);
            }
            if (!(comp instanceof Container)) continue;
            return this.getToppestTrimWidgetAt((Container)comp, tx, ty);
        }
        return null;
    }

    private Perspective getDirectlyUnderPerspective(ITrimWidget trimWidget) {
        for (Container parent = ((Component)((Object)trimWidget)).getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Perspective)) continue;
            return (Perspective)parent;
        }
        throw new IllegalArgumentException("How could you drag a widget when it isn't on the screen! Are you really the God? Or else you must be putting TrimWidgets to some ridiculous places!");
    }
}

