/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.service;

import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ITableSelectionHelper;
import com.kingdee.eas.framework.batchaction.OperationDataTypeEnum;
import com.kingdee.eas.framework.batchaction.service.ActionProxy;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;

public class BatchActionManager
extends ActionManager {
    private Map actionMap;
    private Class clzIBizFactory;
    private Class clzIBizEntryFactory;
    private ITableSelectionHelper tableSelectionHelper = null;
    private Map serviceContext;
    private ContextTypeEnum contextType = ContextTypeEnum.INQUERYING;
    private OperationDataTypeEnum operationDataType = OperationDataTypeEnum.BILL;
    public static final String METHOD_INTERFACE_CTX = "getRemoteInstanceWithObjectContext";
    public static final String METHOD_INTERFACE = "getRemoteInstance";

    public OperationDataTypeEnum getOperationDataType() {
        return this.operationDataType;
    }

    public BatchActionManager(CoreUIObject uiObj, OperationDataTypeEnum operationDataType) {
        this(uiObj);
        this.operationDataType = operationDataType;
    }

    public BatchActionManager(CoreUIObject uiObj, ContextTypeEnum contextType) {
        this(uiObj);
        this.contextType = contextType;
    }

    public ContextTypeEnum getContextType() {
        return this.contextType;
    }

    public void registerBatchAction(ActionProxy actionProxy, String actionName) throws IllegalArgumentException {
        ItemAction action = this.getAction(actionName);
        if (action != null) {
            if (action instanceof ActionProxy) {
                return;
            }
        } else {
            throw new IllegalArgumentException("BatchActionManager: The action name is not found in registered actions.");
        }
        actionProxy.setActionManager(this);
        this.registerAction(actionName, actionProxy);
        actionProxy.setMatchName("actionPerformed");
        actionProxy.setServiceContext(this.serviceContext);
        IItemAction proxy = (IItemAction)Proxy.newProxyInstance(action.getClass().getClassLoader(), this.getProxyInterfaces(action), (InvocationHandler)actionProxy);
        this.actionMap.put(actionProxy, proxy);
    }

    private Class[] getProxyInterfaces(ItemAction action) throws UnsupportedOperationException {
        Class[] interfaces = action.getClass().getInterfaces();
        if (interfaces.length == 0 && action.getClass().getSuperclass() != null) {
            interfaces = action.getClass().getSuperclass().getInterfaces();
        }
        if (interfaces.length == 0) {
            throw new UnsupportedOperationException("BatchActionManager: The action class is not implements IItemAction interface. ");
        }
        return interfaces;
    }

    public void registerBatchAction(ActionProxy actionProxy, String actionName, AbstractButton[] buttons) throws IllegalArgumentException {
        ItemAction action = this.getAction(actionName);
        if (action != null) {
            if (action instanceof ActionProxy) {
                return;
            }
            actionProxy.setActionManager(this);
            this.registerAction(actionName, actionProxy);
            actionProxy.setMatchName("actionPerformed");
            actionProxy.setServiceContext(this.serviceContext);
            IItemAction proxy = (IItemAction)Proxy.newProxyInstance(action.getClass().getClassLoader(), action.getClass().getInterfaces(), (InvocationHandler)actionProxy);
            this.actionMap.put(actionProxy, proxy);
            for (int idxOfBtn = 0; idxOfBtn < buttons.length; ++idxOfBtn) {
                ActionListener[] listeners = buttons[idxOfBtn].getActionListeners();
                if (listeners != null && listeners.length > 0) {
                    buttons[idxOfBtn].removeActionListener(listeners[0]);
                }
                buttons[idxOfBtn].setAction((Action)proxy);
            }
        } else {
            throw new IllegalArgumentException("BatchActionManager: The action name is not found in registered actions.");
        }
    }

    public Class getClzIBizFactory(ActionLevelEnum actionLevel) {
        return actionLevel.equals(ActionLevelEnum.HEAD) ? this.clzIBizFactory : this.clzIBizEntryFactory;
    }

    public void setClzIBizFactory(ActionLevelEnum actionLevel, Class clzIBizFactory) {
        if (actionLevel.equals(ActionLevelEnum.HEAD)) {
            this.clzIBizFactory = clzIBizFactory;
        } else {
            this.clzIBizEntryFactory = clzIBizFactory;
        }
    }

    public BatchActionManager(CoreUIObject uiObj) {
        super(uiObj);
        this.actionMap = new HashMap();
    }

    public void setTableSelectionHelper(ITableSelectionHelper tableSelectionHelper) {
        this.tableSelectionHelper = tableSelectionHelper;
    }

    public ITableSelectionHelper getTableSelectionHelper() {
        return this.tableSelectionHelper;
    }

    public void setServiceContext(Map serviceContext) {
        this.serviceContext = serviceContext;
    }

    public IItemAction getProxy(ActionProxy actionProxy) {
        return (IItemAction)this.actionMap.get(actionProxy);
    }
}

