/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.BiManagerException;
import com.kingdee.eas.framework.bireport.bimanager.BillStatusEnum;
import com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.GetCurProjectFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.AutoAuditStateCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.AutoAuditStateFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.AutoAuditStateInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryFactDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryFactDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelEntryMasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.IAutoAuditState;
import com.kingdee.eas.framework.bireport.bimanager.da.app.AbstractFactDataControllerBean;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingRelationCollection;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingRelationFactory;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingSchemeCollection;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.app.ConnectionHelper;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FactDataControllerBean
extends AbstractFactDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.da.app.FactDataControllerBean");

    @Override
    protected boolean isVerfyNumber() {
        return false;
    }

    @Override
    protected List _queryFactDatas(Context ctx, String querySql, SqlParams params, int type, String projectSchemeId) throws BOSException, EASBizException {
        ArrayList list = null;
        RptRowSet rs = null;
        Connection odsConnection = null;
        Connection dwConnection = null;
        try {
            if (type == Constant.OdsFactData) {
                odsConnection = ConnectionHelper.getConnection(ctx, Constant.OdsFactData, projectSchemeId);
                rs = DBUtil.executeQuery((String)querySql, (Connection)odsConnection);
            } else if (type == Constant.DwFactData) {
                dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
                rs = DBUtil.executeQuery((String)querySql, (Connection)dwConnection);
            } else {
                rs = DBUtil.executeQuery((String)querySql, (Connection)EJBFactory.getConnection((Context)ctx));
            }
            String[] columnNames = rs.getColumnNames();
            int columns = columnNames.length;
            while (rs.next()) {
                if (list == null) {
                    list = new ArrayList();
                }
                HashMap<String, Object> objMap = new HashMap<String, Object>();
                for (int i = 0; i < columns; ++i) {
                    objMap.put(columnNames[i].toUpperCase(), rs.getObject(columnNames[i]));
                }
                list.add(objMap);
            }
        }
        catch (SQLException e) {
            try {
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{querySql});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(dwConnection);
                SQLUtils.cleanup(odsConnection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)dwConnection);
        SQLUtils.cleanup((Connection)odsConnection);
        return list;
    }

    @Override
    protected void _autoAudit(Context ctx, String userID) throws BOSException, EASBizException {
        IAutoAuditState iAutoAuditState = AutoAuditStateFactory.getLocalInstance(ctx);
        AutoAuditStateCollection autoAuditStateCollection = iAutoAuditState.getAutoAuditStateCollection();
        AutoAuditStateInfo autoAuditStateInfo = null;
        autoAuditStateInfo = autoAuditStateCollection == null || autoAuditStateCollection.size() <= 0 ? new AutoAuditStateInfo() : autoAuditStateCollection.get(0);
        autoAuditStateInfo.setIsAuto(true);
        iAutoAuditState.submit(autoAuditStateInfo);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isInWarehouse", (Object)new Boolean(false)));
        BIProjectSchemeInfo bIProjectSchemeInfo = GetCurProjectFacadeFactory.getLocalInstance(ctx).getBIProjectSchemeByUserID(userID);
        if (bIProjectSchemeInfo == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("factDataTemplet.BIProjectScheme.id", (Object)bIProjectSchemeInfo.getId().toString()));
        view.setFilter(filter);
        FactDataCollection factDataColl = this.getFactDataCollection(ctx, view);
        int size = factDataColl.size();
        for (int i = 0; i < size; ++i) {
            String id = factDataColl.get(i).getId().toString();
            this._audit(ctx, id);
        }
    }

    @Override
    protected void _unAutoAudit(Context ctx) throws BOSException, EASBizException {
        IAutoAuditState iAutoAuditState = AutoAuditStateFactory.getLocalInstance(ctx);
        AutoAuditStateCollection autoAuditStateCollection = iAutoAuditState.getAutoAuditStateCollection();
        AutoAuditStateInfo autoAuditStateInfo = null;
        autoAuditStateInfo = autoAuditStateCollection == null || autoAuditStateCollection.size() <= 0 ? new AutoAuditStateInfo() : autoAuditStateCollection.get(0);
        autoAuditStateInfo.setIsAuto(false);
        iAutoAuditState.submit(autoAuditStateInfo);
    }

    protected void _audit1(Context ctx, String id) throws BOSException, EASBizException {
        int j;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("factDataTemplet.id");
        selector.add("BIProjectScheme.id");
        FactDataInfo info = this.getFactDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (info.getFactDataTemplet() == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATAMODELISNULL);
        }
        if (info.getBIProjectScheme() == null) {
            throw new BiManagerException(BiManagerException.E_CURPROJECTSCHEMEISNULL);
        }
        selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("factDataModel.id");
        selector.add("company.id");
        String factDataTempletId = info.getFactDataTemplet().getId().toString();
        FactDataTempletInfo factDataTempletInfo = FactDataTempletFactory.getLocalInstance(ctx).getFactDataTempletInfo((IObjectPK)new ObjectUuidPK(factDataTempletId), selector);
        if (factDataTempletInfo.getFactDataModel() == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATAMODELISNULL);
        }
        selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("EntryFactData.*");
        selector.add("EntryMasterData.*");
        selector.add("EntryMasterData.MasterData.*");
        FactDataModelInfo dataModel = FactDataModelFactory.getLocalInstance(ctx).getFactDataModelInfo((IObjectPK)new ObjectUuidPK(factDataTempletInfo.getFactDataModel().getId()), selector);
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String factDataId = dataModel.getId().toString();
        String factDataEasTable = iTableIndex.getTableNameById(factDataId, TableTypeEnum.FactDataEasTable);
        if (factDataEasTable == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATAEASTABLENOTEXIST);
        }
        String factDataDwTable = iTableIndex.getTableNameById(factDataId, TableTypeEnum.FactDataDwTable);
        if (factDataDwTable == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATADWTABLENOTEXIST);
        }
        FactDataModelEntryFactDataCollection col = dataModel.getEntryFactData();
        if (col == null || col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        String fieldName = null;
        ArrayList<String> tableAliasList = new ArrayList<String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        StringBuffer srcFieldSb = new StringBuffer();
        StringBuffer targetFieldSb = new StringBuffer();
        StringBuffer paramsSb = new StringBuffer();
        StringBuffer joinSb = new StringBuffer();
        StringBuffer filterSb = new StringBuffer();
        FactDataModelEntryMasterDataCollection MasterDataCol = dataModel.getEntryMasterData();
        if (MasterDataCol != null && MasterDataCol.size() > 0) {
            FactDataModelEntryMasterDataInfo MasterDataEntry = null;
            MasterDataInfo masterDataInfo = null;
            filterSb.append(" where 1=1 ");
            int size = MasterDataCol.size();
            for (int i = 0; i < size; ++i) {
                MasterDataEntry = MasterDataCol.get(i);
                masterDataInfo = MasterDataEntry.getMasterData();
                String mappingRelationTable = iTableIndex.getTableNameById(masterDataInfo.getId().toString(), TableTypeEnum.MappingRelationTable);
                fieldName = "F" + masterDataInfo.getNumber().toUpperCase();
                String tableAlias = "T" + i;
                tableAliasList.add(tableAlias);
                srcFieldSb.append(tableAlias).append(".").append(Constant.Mapping_targetName).append(" as ").append(fieldName).append(",");
                targetFieldSb.append(fieldName).append(",");
                paramsSb.append("?,");
                fieldList.add(fieldName);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)factDataTempletInfo.getCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("masterData.id", (Object)masterDataInfo.getId().toString()));
                view.setFilter(filter);
                MappingSchemeCollection mappingSchemeColl = MappingSchemeFactory.getLocalInstance(ctx).getMappingSchemeCollection(view);
                HashSet<String> idSet = new HashSet<String>();
                int length = mappingSchemeColl.size();
                for (int j2 = 0; j2 < length; ++j2) {
                    idSet.add(mappingSchemeColl.get(j2).getId().toString());
                }
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mappingScheme.id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                MappingRelationCollection MappingRelationColl = MappingRelationFactory.getLocalInstance(ctx).getMappingRelationCollection(view);
                StringBuffer mappingIds = new StringBuffer();
                int length2 = MappingRelationColl.size();
                for (j = 0; j < length2; ++j) {
                    mappingIds.append("'").append(MappingRelationColl.get(j).getId().toString()).append("',");
                }
                mappingIds.replace(mappingIds.length() - 1, mappingIds.length(), "");
                joinSb.append(" join ").append(mappingRelationTable).append(" ").append(tableAlias).append(" on A.").append(fieldName).append("=").append(tableAlias).append(".").append(Constant.Mapping_srcNumber);
                filterSb.append(" and ").append(tableAlias).append(".").append(Constant.Mapping_MappingRelationID).append(" in (").append(mappingIds).append(")");
            }
        }
        FactDataModelEntryFactDataInfo entry = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            fieldName = "F" + entry.getNumber().toUpperCase();
            targetFieldSb.append(fieldName).append(",");
            paramsSb.append("?,");
            fieldList.add(fieldName);
            FieldTypeEnum fieldType = entry.getFieldType();
            srcFieldSb.append("A.").append(fieldName);
            if ((FieldTypeEnum.Integer.equals((Object)fieldType) || FieldTypeEnum.Decimal.equals((Object)fieldType)) && tableAliasList.size() > 0) {
                int length = tableAliasList.size();
                for (int j3 = 0; j3 < length; ++j3) {
                    String tableAlias = (String)tableAliasList.get(j3);
                    if (tableAlias == null) {
                        throw new BiManagerException(BiManagerException.E_JOINTABLEISNULL);
                    }
                    srcFieldSb.append("*").append(tableAlias).append(".").append(Constant.Mapping_weight);
                }
                srcFieldSb.append(" as ").append(fieldName);
            }
            srcFieldSb.append(",");
        }
        srcFieldSb.append("A.").append("F").append(Constant.ReportDate);
        targetFieldSb.append("F").append(Constant.ReportDate);
        paramsSb.append("?");
        fieldList.add("F" + Constant.ReportDate);
        String projectSchemeId = info.getBIProjectScheme().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(srcFieldSb).append(" from ").append(factDataEasTable).append(" A ").append(joinSb).append(filterSb).append(" and A.F").append(Constant.FactDataID).append("='").append(id).append("'");
        List dataList = this._queryFactDatas(ctx, sql.toString(), null, Constant.TempFactData, projectSchemeId);
        if (dataList != null && dataList.size() > 0) {
            Connection dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
            sql.setLength(0);
            sql.append("insert into ").append(factDataDwTable).append(" (").append(targetFieldSb).append(",F").append(Constant.FactDataID).append(") ").append(" values (").append(paramsSb).append(",?").append(") ");
            int MAX_DATA_ROW = 1000;
            PreparedStatement ps = null;
            try {
                ps = dwConnection.prepareStatement(sql.toString());
                boolean flag = false;
                int counts = dataList.size();
                for (int i = 0; i < counts; ++i) {
                    HashMap objMap = (HashMap)dataList.get(i);
                    int paramSize = fieldList.size();
                    for (j = 0; j < paramSize; ++j) {
                        String field = (String)fieldList.get(j);
                        Object value = objMap.get(field);
                        if (value != null) {
                            ps.setObject(j + 1, value);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.setString(paramSize, id);
                    ps.addBatch();
                    if ((i + 1) % 1000 == 0) {
                        ps.executeBatch();
                        flag = true;
                        continue;
                    }
                    flag = false;
                }
                if (!flag) {
                    ps.executeBatch();
                }
            }
            catch (SQLException exc) {
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
            }
            finally {
                SQLUtils.cleanup((Statement)ps, (Connection)dwConnection);
            }
        }
        info.setBillStatus(BillStatusEnum.Audited);
        info.setIsInWarehouse(true);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void _unAudit(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("factDataTemplet.id");
        selector.add("BIProjectScheme.id");
        FactDataInfo info = this.getFactDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (info.getFactDataTemplet() == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATAMODELISNULL);
        }
        if (info.getBIProjectScheme() == null) {
            throw new BiManagerException(BiManagerException.E_CURPROJECTSCHEMEISNULL);
        }
        selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("factDataModel.id");
        selector.add("company.id");
        String factDataTempletId = info.getFactDataTemplet().getId().toString();
        FactDataTempletInfo factDataTempletInfo = FactDataTempletFactory.getLocalInstance(ctx).getFactDataTempletInfo((IObjectPK)new ObjectUuidPK(factDataTempletId), selector);
        selector = new SelectorItemCollection();
        selector.add("*");
        FactDataModelInfo dataModel = FactDataModelFactory.getLocalInstance(ctx).getFactDataModelInfo((IObjectPK)new ObjectUuidPK(factDataTempletInfo.getFactDataModel().getId()), selector);
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String factDataDwTable = iTableIndex.getTableNameById(dataModel.getId().toString(), TableTypeEnum.FactDataDwTable);
        if (factDataDwTable == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATADWTABLENOTEXIST);
        }
        String projectSchemeId = info.getBIProjectScheme().getId().toString();
        Connection dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(factDataDwTable).append(" where ").append("F").append(Constant.FactDataID).append("='").append(id).append("'");
        try {
            DBUtil.execute((String)sql.toString(), (Connection)dwConnection);
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
        }
        finally {
            SQLUtils.cleanup((Connection)dwConnection);
        }
        info.setIsInWarehouse(false);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void _auditAction(Context ctx, String id) throws BOSException, EASBizException {
        AutoAuditStateCollection autoAuditStateCollection = AutoAuditStateFactory.getLocalInstance(ctx).getAutoAuditStateCollection();
        if (autoAuditStateCollection == null || autoAuditStateCollection.size() <= 0) {
            return;
        }
        AutoAuditStateInfo autoAuditStateInfo = autoAuditStateCollection.get(0);
        if (!autoAuditStateInfo.isIsAuto()) {
            return;
        }
        this._audit(ctx, id);
    }

    @Override
    protected void _audit(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("factDataTemplet.id");
        selector.add("BIProjectScheme.id");
        FactDataInfo info = this.getFactDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (info.getFactDataTemplet() == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATATEMPLETISNULL);
        }
        if (info.getBIProjectScheme() == null) {
            throw new BiManagerException(BiManagerException.E_CURPROJECTSCHEMEISNULL);
        }
        selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("factDataModel.id");
        selector.add("company.id");
        String factDataTempletId = info.getFactDataTemplet().getId().toString();
        FactDataTempletInfo factDataTempletInfo = FactDataTempletFactory.getLocalInstance(ctx).getFactDataTempletInfo((IObjectPK)new ObjectUuidPK(factDataTempletId), selector);
        if (factDataTempletInfo.getFactDataModel() == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATAMODELISNULL);
        }
        selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("EntryFactData.*");
        selector.add("EntryMasterData.*");
        selector.add("EntryMasterData.MasterData.*");
        FactDataModelInfo dataModel = FactDataModelFactory.getLocalInstance(ctx).getFactDataModelInfo((IObjectPK)new ObjectUuidPK(factDataTempletInfo.getFactDataModel().getId()), selector);
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String factDataId = dataModel.getId().toString();
        String factDataOdsTable = iTableIndex.getTableNameById(factDataId, TableTypeEnum.FactDataOdsTable);
        if (factDataOdsTable == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATAODSTABLENOTEXIST);
        }
        String factDataDwTable = iTableIndex.getTableNameById(factDataId, TableTypeEnum.FactDataDwTable);
        if (factDataDwTable == null) {
            throw new BiManagerException(BiManagerException.E_FACTDATADWTABLENOTEXIST);
        }
        FactDataModelEntryFactDataCollection col = dataModel.getEntryFactData();
        if (col == null || col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        FactDataModelEntryFactDataInfo entry = null;
        String fieldName = null;
        HashMap mappingMap = new HashMap();
        HashMap<String, String> calcuMap = new HashMap<String, String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        StringBuffer fieldSb = new StringBuffer();
        StringBuffer paramsSb = new StringBuffer();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            fieldName = "F" + entry.getNumber().toUpperCase();
            fieldSb.append(fieldName).append(",");
            paramsSb.append("?,");
            fieldList.add(fieldName);
            FieldTypeEnum fieldType = entry.getFieldType();
            if (!FieldTypeEnum.Integer.equals((Object)fieldType) && !FieldTypeEnum.Decimal.equals((Object)fieldType)) continue;
            calcuMap.put(fieldName, "");
        }
        StringBuffer mappingedDataSql = new StringBuffer();
        mappingedDataSql.append("select F").append(Constant.ID).append(",").append(Constant.Mapping_srcID).append(",").append(Constant.Mapping_srcName).append(",").append(Constant.Mapping_srcNumber).append(",").append(Constant.Mapping_weight).append(",").append(Constant.Mapping_targetID).append(",").append(Constant.Mapping_targetName).append(",").append(Constant.Mapping_targetNumber).append(",").append(Constant.Mapping_MappingRelationID).append(" from ");
        FactDataModelEntryMasterDataCollection MasterDataCol = dataModel.getEntryMasterData();
        if (MasterDataCol != null && MasterDataCol.size() > 0) {
            FactDataModelEntryMasterDataInfo MasterDataEntry = null;
            MasterDataInfo masterDataInfo = null;
            int size2 = MasterDataCol.size();
            for (int i = 0; i < size2; ++i) {
                MasterDataEntry = MasterDataCol.get(i);
                masterDataInfo = MasterDataEntry.getMasterData();
                fieldName = "F" + masterDataInfo.getNumber().toUpperCase();
                fieldSb.append(fieldName).append(",");
                paramsSb.append("?,");
                fieldList.add(fieldName);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)factDataTempletInfo.getCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("masterData.id", (Object)masterDataInfo.getId().toString()));
                view.setFilter(filter);
                MappingSchemeCollection mappingSchemeColl = MappingSchemeFactory.getLocalInstance(ctx).getMappingSchemeCollection(view);
                HashSet<String> mappingSchemeIdsSet = new HashSet<String>();
                int length = mappingSchemeColl.size();
                for (int n = 0; n < length; ++n) {
                    mappingSchemeIdsSet.add(mappingSchemeColl.get(n).getId().toString());
                }
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mappingScheme.id", mappingSchemeIdsSet, CompareType.INCLUDE));
                view.setFilter(filter);
                MappingRelationCollection mappingRelationColl = MappingRelationFactory.getLocalInstance(ctx).getMappingRelationCollection(view);
                StringBuffer mappingRelationIds = new StringBuffer();
                int length2 = mappingRelationColl.size();
                for (int n = 0; n < length2; ++n) {
                    mappingRelationIds.append("'").append(mappingRelationColl.get(n).getId().toString()).append("'");
                    if (n >= length2 - 1) continue;
                    mappingRelationIds.append(",");
                }
                String mappingRelationTable = iTableIndex.getTableNameById(masterDataInfo.getId().toString(), TableTypeEnum.MappingRelationTable);
                StringBuffer mappingSql = new StringBuffer();
                mappingSql.append(mappingedDataSql).append(mappingRelationTable);
                if (mappingRelationIds.length() > 0) {
                    mappingSql.append(" where ").append(Constant.Mapping_MappingRelationID).append(" in (").append(mappingRelationIds).append(")");
                }
                RptRowSet rs = null;
                try {
                    rs = DBUtil.executeQuery((String)mappingSql.toString(), (Connection)EJBFactory.getConnection((Context)ctx));
                    HashMap mappingObjMap = new HashMap();
                    String[] columnNames = rs.getColumnNames();
                    int columns = columnNames.length;
                    while (rs.next()) {
                        HashMap<String, Object> objMap = new HashMap<String, Object>();
                        Object fnumber = null;
                        for (int m = 0; m < columns; ++m) {
                            if (Constant.Mapping_srcNumber.equalsIgnoreCase(columnNames[m])) {
                                fnumber = rs.getObject(columnNames[m]);
                            }
                            objMap.put(columnNames[m], rs.getObject(columnNames[m]));
                        }
                        mappingObjMap.put(fnumber, objMap);
                    }
                    mappingMap.put(fieldName, mappingObjMap);
                    continue;
                }
                catch (SQLException e) {
                    throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{mappingSql.toString()});
                }
            }
        }
        fieldSb.append("F").append(Constant.ReportDate.toUpperCase()).append(",F").append(Constant.FactDataID.toUpperCase()).append(",F").append(Constant.ID.toUpperCase()).append(",F").append(Constant.Company.toUpperCase()).append(",F").append(Constant.ReportSource.toUpperCase());
        paramsSb.append("?,?,?,?,?");
        fieldList.add("F" + Constant.ReportDate.toUpperCase());
        fieldList.add("F" + Constant.FactDataID.toUpperCase());
        fieldList.add("F" + Constant.ID.toUpperCase());
        fieldList.add("F" + Constant.Company.toUpperCase());
        fieldList.add("F" + Constant.ReportSource.toUpperCase());
        String projectSchemeId = info.getBIProjectScheme().getId().toString();
        Connection dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(factDataDwTable).append(" where F").append(Constant.FactDataID).append("='").append(id).append("'");
        try {
            DBUtil.execute((String)sql.toString(), (Connection)dwConnection);
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
        }
        sql.setLength(0);
        sql.append("select ").append(fieldSb).append(" from ").append(factDataOdsTable).append(" where F").append(Constant.FactDataID).append("='").append(id).append("'");
        List dataList = this._queryFactDatas(ctx, sql.toString(), null, Constant.OdsFactData, info.getBIProjectScheme().getId().toString());
        if (dataList != null && dataList.size() > 0) {
            sql.setLength(0);
            sql.append("insert into ").append(factDataDwTable).append(" (").append(fieldSb).append(") ").append(" values (").append(paramsSb).append(") ");
            int MAX_DATA_ROW = 1000;
            PreparedStatement ps = null;
            try {
                ps = dwConnection.prepareStatement(sql.toString());
                boolean flag = false;
                int counts = dataList.size();
                for (int i = 0; i < counts; ++i) {
                    HashMap objMap = (HashMap)dataList.get(i);
                    Object srcID = null;
                    int paramSize = fieldList.size();
                    Iterator iterator = mappingMap.keySet().iterator();
                    double weight = 1.0;
                    HashMap idMap = new HashMap();
                    while (iterator.hasNext()) {
                        String number;
                        String quoteNumber = (String)iterator.next();
                        HashMap mappingObjMap = (HashMap)mappingMap.get(quoteNumber);
                        HashMap mappingObj = (HashMap)mappingObjMap.get(number = (String)objMap.get(quoteNumber));
                        if (mappingObj == null) continue;
                        Object obj = mappingObj.get(Constant.Mapping_weight.toUpperCase());
                        if (obj != null) {
                            BigDecimal mappingWeigth = (BigDecimal)obj;
                            weight *= mappingWeigth.doubleValue();
                        }
                        idMap.put(quoteNumber, mappingObj.get(Constant.Mapping_targetID.toUpperCase()));
                    }
                    for (int j = 0; j < paramSize; ++j) {
                        String field = (String)fieldList.get(j);
                        Object value = objMap.get(field);
                        if (calcuMap.containsKey(field)) {
                            if (value instanceof Integer) {
                                value = new Double((double)((Integer)value).intValue() * weight);
                            } else if (value instanceof BigDecimal) {
                                value = new Double(((BigDecimal)value).doubleValue() * weight);
                            } else if (value instanceof String) {
                                value = new Double(new Double((String)value) * weight);
                            }
                        }
                        if (mappingMap.containsKey(field)) {
                            if (idMap.containsKey(field)) {
                                value = idMap.get(field);
                            } else {
                                throw new BiManagerException(BiManagerException.BASEDATANOTCOMPLETE, new Object[]{value});
                            }
                        }
                        if (value != null) {
                            ps.setObject(j + 1, value);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.addBatch();
                    if ((i + 1) % 1000 == 0) {
                        ps.executeBatch();
                        flag = true;
                        continue;
                    }
                    flag = false;
                }
                if (!flag) {
                    ps.executeBatch();
                }
            }
            catch (SQLException exc) {
                Object sb = null;
                Object params = null;
                exc.printStackTrace();
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{exc.getMessage()});
            }
            finally {
                SQLUtils.cleanup((Statement)ps, (Connection)dwConnection);
            }
        }
        info.setIsInWarehouse(true);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }
}

