/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.dbpool;

import com.kingdee.eas.framework.bireport.bimanager.dbpool.DBConnectionPoolManager;
import com.kingdee.eas.framework.bireport.bimanager.util.DBCentersMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnectionUtil {
    public static void closeAll(Connection con, Statement st, ResultSet rs) {
        DBConnectionUtil.closeResultSet(rs);
        DBConnectionUtil.closeStatement(st);
        DBConnectionUtil.closeConnection(con);
    }

    public static Connection getConnectionByDBCenterID(String id) throws Exception {
        return DBConnectionPoolManager.getConnection(DBCentersMap.getInstance().get(id));
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("\u5173\u95ed\u7ed3\u679c\u96c6\u51fa\u9519\uff1a" + e.getMessage());
        }
        finally {
            rs = null;
        }
    }

    public static void closeStatement(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            System.out.println("\u5173\u95ed\u8bed\u53e5\u5bf9\u8c61\u51fa\u9519\uff1a" + e.getMessage());
        }
        finally {
            st = null;
        }
    }

    public static void closeConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            System.out.println("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff1a" + e.getMessage());
        }
        finally {
            con = null;
        }
    }
}

