/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlMngException;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerCollection;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.app.AbstractEtlSchemeManagerControllerBean;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class EtlSchemeManagerControllerBean
extends AbstractEtlSchemeManagerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.etl.app.EtlSchemeManagerControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _updateStatus(Context ctx, String schemeID, String status) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" UPDATE T_BI_MNG_EtlSchemeManager SET FSTATUS = ? WHERE FID = ? ");
        SqlParams sp = new SqlParams();
        Connection conn = this.getConnection(ctx);
        PreparedStatement pstm = null;
        try {
            pstm = conn.prepareStatement(sbSql.toString());
            pstm.setString(1, status);
            pstm.setString(2, schemeID);
            int result = pstm.executeUpdate();
            if (result > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)"error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Statement)pstm, (Connection)conn);
        }
    }

    @Override
    protected boolean _isUsed(Context ctx, String schemeID) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block4: {
            boolean bl;
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT RESULT = CASE ");
            sql.append(" WHEN EXISTS (SELECT FID FROM  T_BI_MNG_EtlDispatchMngEntry WHERE FSchemeID = ?) THEN 1 ");
            sql.append(" ELSE 0 END ");
            con = null;
            stmt = null;
            rs = null;
            try {
                int result;
                con = this.getConnection(ctx);
                stmt = con.prepareStatement(sql.toString());
                stmt.setString(1, schemeID);
                rs = stmt.executeQuery();
                if (!rs.next() || (result = rs.getInt("RESULT")) != 1) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"error", (Throwable)e);
                    throw new EtlMngException(EtlMngException.SQLEXCEPTION, new Object[]{e.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return false;
    }

    @Override
    protected void _deleteDataCennection(Context ctx) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("fileWay");
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        EtlSchemeManagerCollection collection = this.getEtlSchemeManagerCollection(ctx, view);
        CoreBaseCollection cols = new CoreBaseCollection();
        for (int i = 0; i < collection.size(); ++i) {
            EtlSchemeManagerInfo etlSchemeManagerInfo = collection.get(i);
            if (etlSchemeManagerInfo.getFileWay() == null) continue;
            this.deleteDataCenter(etlSchemeManagerInfo);
            cols.add((CoreBaseInfo)etlSchemeManagerInfo);
        }
        try {
            this.update(ctx, cols);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void deleteDataCenter(EtlSchemeManagerInfo info) {
        try {
            StringBuffer sb = new StringBuffer();
            String string = new String(info.getFileWay(), "UTF-8");
            if (string.indexOf("<access>Custom</access>") < 0) {
                return;
            }
            int notepads = string.indexOf("</notepads>");
            int order = string.indexOf("<order>");
            if (notepads < 1) {
                return;
            }
            if (order < 1) {
                return;
            }
            if (order < notepads) {
                return;
            }
            sb.append(string.substring(0, notepads + 12));
            sb.append("\n");
            sb.append("<changeConnections>connectionhasDelete</changeConnections> ");
            sb.append("\n");
            sb.append(string.substring(order));
            info.setFileWay(sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

