/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SimpleResultSetMetaData
implements ResultSetMetaData,
Serializable {
    protected String[] labels;
    protected String[] names;
    protected int[] types;

    public SimpleResultSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        this.copy(rsmd);
    }

    public SimpleResultSetMetaData() {
        int count = 0;
        this.labels = new String[count];
        this.names = new String[count];
        this.types = new int[count];
    }

    public void copy(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        this.labels = new String[count];
        this.names = new String[count];
        this.types = new int[count];
        for (int i = 0; i < count; ++i) {
            this.labels[i] = rsmd.getColumnLabel(i + 1);
            this.names[i] = rsmd.getColumnName(i + 1);
            this.types[i] = rsmd.getColumnType(i + 1);
        }
    }

    public void setColumnLabel(int column, String label) {
        this.labels[column - 1] = label;
    }

    @Override
    public int getColumnCount() {
        return this.types.length;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.labels[column - 1];
    }

    public void setColumnName(int column, String name) {
        this.names[column - 1] = name;
    }

    @Override
    public String getColumnName(int column) {
        return this.names[column - 1];
    }

    @Override
    public int getColumnType(int column) {
        return this.types[column - 1];
    }

    public void deleteColumn(int colIdx) {
        this.labels = (String[])SimpleResultSetMetaData.removeElement(this.labels, --colIdx);
        this.names = (String[])SimpleResultSetMetaData.removeElement(this.names, colIdx);
        this.types = SimpleResultSetMetaData.removeElement(this.types, colIdx);
    }

    public void addColumn(int colIdx, String colName, int colType) {
        this.labels = (String[])SimpleResultSetMetaData.insertElement(this.labels, --colIdx, colName);
        this.names = (String[])SimpleResultSetMetaData.insertElement(this.names, colIdx, colName);
        this.types = SimpleResultSetMetaData.insertElement(this.types, colIdx, colType);
    }

    public static final int[] removeElement(int[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        int[] t_array = new int[array.length - 1];
        if (t_array.length != 0) {
            System.arraycopy(array, 0, t_array, 0, index);
            System.arraycopy(array, index + 1, t_array, index, t_array.length - index);
        }
        return t_array;
    }

    public static final int[] insertElement(int[] array, int index, int val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] t_array = new int[array.length + 1];
        System.arraycopy(array, 0, t_array, 0, index);
        t_array[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, t_array, index + 1, t_array.length - index - 1);
        }
        return t_array;
    }

    public static final Object[] insertElement(Object[] array, int index, Object val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object[] t_array = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, t_array, 0, index);
        t_array[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, t_array, index + 1, t_array.length - index - 1);
        }
        return t_array;
    }

    public static final Object[] removeElement(Object[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        Object[] t_array = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (t_array.length != 0) {
            System.arraycopy(array, 0, t_array, 0, index);
            System.arraycopy(array, index + 1, t_array, index, t_array.length - index);
        }
        return t_array;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return null;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }

    public Object unwrap(Class iface) throws SQLException {
        return null;
    }
}

