/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.ProxyResultSet;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.StatementInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class DBConnectionInfo {
    public String connectionID;
    private Connection conn;
    public Map statMents;
    public Map resultSets;
    public long lastAccseeTime;
    private Map elseObjs = new Hashtable();

    public DBConnectionInfo(String connectionID, Connection conn) {
        this.conn = conn;
        this.connectionID = connectionID;
        this.statMents = new HashMap();
        this.resultSets = new Hashtable();
    }

    public void reSetLastAccseeTime() {
        this.lastAccseeTime = System.currentTimeMillis();
    }

    public void close() {
        Iterator iter = this.statMents.keySet().iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            StatementInfo info = (StatementInfo)this.statMents.get(next);
            info.close();
            iter.remove();
        }
        Iterator iterator = this.resultSets.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            ResultSet rs = (ResultSet)this.resultSets.get(key);
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            iterator.remove();
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void closeStatement(String statmentID) throws SQLException {
        if (this.statMents.containsKey(statmentID)) {
            StatementInfo info = (StatementInfo)this.statMents.get(statmentID);
            info.close();
            this.statMents.remove(statmentID);
        }
    }

    public void closeResultSet(String statmentID, String rsID) throws SQLException {
        if (statmentID == null && this.resultSets.containsKey(rsID)) {
            ResultSet rs = (ResultSet)this.resultSets.get(rsID);
            rs.close();
            this.resultSets.remove(rsID);
            return;
        }
        if (this.statMents.containsKey(statmentID)) {
            StatementInfo info = (StatementInfo)this.statMents.get(statmentID);
            info.closeResultSet(rsID);
        }
    }

    public Object getObj(String targerID) {
        return this.elseObjs.get(targerID);
    }

    public void putObj(String targerID, Object obj) {
        this.elseObjs.put(targerID, obj);
    }

    public Connection getTagetObj() {
        return this.conn;
    }

    public StatementInfo getStatementInfo(String statmentID) {
        if (this.statMents.containsKey(statmentID)) {
            return (StatementInfo)this.statMents.get(statmentID);
        }
        return null;
    }

    public ProxyResultSet getResultSet(String statmentID, String rsID) {
        if (this.resultSets.containsKey(rsID)) {
            return (ProxyResultSet)this.resultSets.get(rsID);
        }
        if (this.statMents.containsKey(statmentID)) {
            StatementInfo info = (StatementInfo)this.statMents.get(statmentID);
            return info.getResultset(rsID);
        }
        return null;
    }

    public void putStatement(String statmentID, StatementInfo info) {
        this.statMents.put(statmentID, info);
    }

    public void putResultSet(String statmentID, String rsID, ResultSet rs) {
        if (statmentID == null) {
            this.resultSets.put(rsID, rs);
            return;
        }
        StatementInfo statementInfo = this.getStatementInfo(statmentID);
        if (statementInfo != null) {
            statementInfo.addResultSet(rsID, rs);
        } else {
            this.resultSets.put(rsID, rs);
        }
    }
}

