/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.listener;

import com.kingdee.bos.Context;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.KDParameterMetaData;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.ProxyResultSet;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.Reflects;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.SimpleResultSetMetaData;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.DBConnectionInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.IAppMsgReceivedListener;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.NIOSessionManage;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.StatementInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.domain.DatabaseMetaDataProxy;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.domain.KDProxySavepoint;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.domain.MethodMessageInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.domain.ResultValueInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.domain.TransException;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.domain.TransportObject;
import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class DefaultRMIListener
implements IAppMsgReceivedListener {
    public static final DefaultRMIListener defaultListener = new DefaultRMIListener();
    private String clientID;
    private String connectionID;
    private MethodMessageInfo command;

    @Override
    public ResultValueInfo handleMessage(Context ctx, TransportObject to) throws Exception {
        this.command = to.kettleCommand;
        this.clientID = to.clientID;
        this.connectionID = to.kettleCommand.connectionID;
        if ("close".equals(this.command.methodName)) {
            if ("connection".equals(this.command.objType)) {
                this.getSession().close(this.clientID, this.command.connectionID);
                ResultValueInfo info = new ResultValueInfo();
                info.className = "void";
                return info;
            }
            if ("resultSet".equals(this.command.objType)) {
                this.getSession().close(this.clientID, this.connectionID, this.command.statementID, this.command.rsID);
                ResultValueInfo info = new ResultValueInfo();
                info.className = "void";
                return info;
            }
            if ("statment".equals(this.command.objType)) {
                this.getSession().close(this.clientID, this.connectionID, this.command.statementID);
                ResultValueInfo info = new ResultValueInfo();
                info.className = "void";
                return info;
            }
        }
        return this.invokeAtServer();
    }

    public void handleResult(ResultValueInfo result) {
        if (result.value instanceof ResultSet) {
            ResultSet rowSet = (ResultSet)result.value;
            String rsID = UUID.randomUUID().toString();
            ProxyResultSet localRs = new ProxyResultSet(rowSet, rsID);
            result.className = "ResultSet";
            result.value = localRs;
            result.targetObjectID = rsID;
            this.getSession().registerResultID(this.clientID, this.connectionID, this.command.statementID, rsID, localRs);
            return;
        }
        if (result.value instanceof ParameterMetaData) {
            result.className = ParameterMetaData.class.getName();
            try {
                result.value = new KDParameterMetaData((ParameterMetaData)result.value);
            }
            catch (SQLException e) {
                result.className = "TransException";
                result.value = new TransException(e);
            }
        } else if (result.value instanceof CallableStatement || result.value instanceof Statement || result.value instanceof PreparedStatement) {
            String targetObjID = UUID.randomUUID().toString();
            StatementInfo info = new StatementInfo(targetObjID, (Statement)result.value);
            this.getSession().registerStatement(this.clientID, this.connectionID, targetObjID, info);
            result.targetObjectID = targetObjID;
            result.value = "Statement";
        } else if (result.value instanceof ResultSetMetaData) {
            result.className = ResultSetMetaData.class.getName();
            try {
                result.value = new SimpleResultSetMetaData((ResultSetMetaData)result.value);
            }
            catch (SQLException e) {
                result.className = "TransException";
                result.value = new TransException(e);
            }
        } else if (result.value instanceof Savepoint) {
            result.className = Savepoint.class.getName();
            try {
                KDProxySavepoint point = new KDProxySavepoint((Savepoint)result.value);
                result.value = point;
            }
            catch (Exception e) {
                result.className = "TransException";
                result.value = new TransException(e);
            }
        } else if (result.value instanceof DatabaseMetaData) {
            String targetObjID;
            result.targetObjectID = targetObjID = UUID.randomUUID().toString();
            this.getSession().registerObj(this.clientID, this.connectionID, targetObjID, result.value);
            result.className = "DatabaseMetaData";
            result.value = new DatabaseMetaDataProxy((DatabaseMetaData)result.value);
        }
    }

    public Object getLocalObj() {
        if ("connection".equals(this.command.objType)) {
            DBConnectionInfo info = this.getSession().getClientConn(this.clientID, this.connectionID);
            return info.getTagetObj();
        }
        if ("resultSet".equals(this.command.objType)) {
            DBConnectionInfo clientConn = this.getSession().getClientConn(this.clientID, this.connectionID);
            return clientConn.getResultSet(this.command.statementID, this.command.rsID);
        }
        if ("statment".equals(this.command.objType)) {
            StatementInfo info = this.getSession().getStatementInfo(this.clientID, this.connectionID, this.command.statementID);
            return info.getTarget();
        }
        return this.getSession().getObj(this.clientID, this.connectionID, this.command.remoteObjID);
    }

    private NIOSessionManage getSession() {
        return NIOSessionManage.getInstance();
    }

    public ResultValueInfo invokeAtServer() {
        ResultValueInfo result = new ResultValueInfo();
        try {
            Object obj;
            if ("rollback".equals(this.command.methodName) && this.command.paramsType != null && this.command.paramsType.length == 1 && this.command.paramsType[0].toString().equals("java.sql.Savepoint")) {
                Object savePoint;
                this.command.params[0] = savePoint = this.getSession().getObj(this.clientID, this.connectionID, this.command.remoteObjID);
            }
            if ((obj = this.getLocalObj()) == null) {
                // empty if block
            }
            Method method = Reflects.getMeshod(obj.getClass(), this.command.methodName, this.command.paramsType);
            Object invokeResult = method.invoke(obj, this.command.params);
            Class<?> returnType = method.getReturnType();
            if (Reflects.getSimpleName(returnType).equals("void")) {
                result.className = "void";
            } else {
                result.className = returnType.getName();
                result.value = invokeResult;
            }
        }
        catch (Exception e) {
            System.out.println("adfas");
            result.className = "TransException";
            result.value = e.getCause() != null ? new TransException(e.getCause().getMessage()) : new TransException(e.getMessage());
        }
        this.handleResult(result);
        return result;
    }

    @Override
    public String handleObjClass() {
        return "default";
    }
}

