/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket;

import com.kingdee.eas.framework.bireport.bimanager.etl.LogForDebug;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.AcceptListener;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.Bytes;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.CommandCache;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.MsgHandle;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.socket.TransportObj;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketServer
implements Runnable {
    private static Logger logger = Logger.getLogger("SocketServerHL");
    private boolean isRunning;
    private Selector selector;
    private ServerSocketChannel ssc;
    private ByteBuffer buffer;
    private ExecutorService msgHandleService;
    private static int defalutMsgHandleCount = 25;
    private MsgHandle msgHandle;
    private AcceptListener acceptHandle;
    private CommandCache rPCcache;
    private int port = 0;
    private List sockets = new LinkedList();

    public SocketServer(MsgHandle msgHandle, AcceptListener acceptHandle) {
        this.msgHandle = msgHandle;
        this.acceptHandle = acceptHandle;
        this.isRunning = false;
        this.rPCcache = new CommandCache();
    }

    public boolean isStart() {
        while (!this.isRunning) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void stopServer() {
        LogForDebug.info("\u670d\u52a1\u505c\u6b62!");
        if (this.buffer != null) {
            this.buffer.clear();
        }
        if (this.selector != null && this.selector.isOpen()) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.ssc != null && this.ssc.isOpen()) {
            try {
                this.ssc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Iterator iterator = this.sockets.iterator();
        while (iterator.hasNext()) {
            SocketChannel channel = (SocketChannel)iterator.next();
            iterator.remove();
            if (!channel.isOpen()) continue;
            try {
                channel.close();
                if (!channel.socket().isClosed()) {
                    channel.socket().close();
                }
                if (this.acceptHandle == null) continue;
                this.acceptHandle.close(channel);
            }
            catch (IOException iOException) {}
        }
        this.isRunning = false;
        this.msgHandleService.shutdown();
    }

    public void reStart() throws IOException {
        this.isRunning = false;
        this.stopServer();
        this.init();
    }

    public void init() throws IOException {
        this.selector = Selector.open();
        this.ssc = ServerSocketChannel.open();
        this.ssc.configureBlocking(false);
        this.buffer = ByteBuffer.allocate(8192);
        this.msgHandleService = Executors.newFixedThreadPool((int)defalutMsgHandleCount);
        int i = 1000;
        while (i < 65535) {
            this.port = i++;
            try {
                this.ssc.socket().bind(new InetSocketAddress(this.port));
                this.ssc.register(this.selector, 16);
                LogForDebug.info("\u542f\u52a8socket \u670d\u52a1" + new Date() + ";\u7aef\u53e3\u53f7:" + this.port);
                this.isRunning = true;
                break;
            }
            catch (IOException ex) {
                this.isRunning = false;
                this.port = 0;
            }
        }
        if (this.port == 0) {
            this.stop();
            throw new RuntimeException("\u7aef\u53e3\u4ece1000\u523065535\u90fd\u88ab\u5360\u7528\uff0c\u65e0\u6cd5\u521b\u5efa\u5957\u63a5\u5b57\u670d\u52a1!");
        }
    }

    public int getPort() {
        return this.port;
    }

    public static void main(String[] args) {
        SocketServer server = new SocketServer(new MsgHandle(){

            @Override
            public Object handle(Object obj) throws Exception {
                return obj;
            }
        }, null);
        new Thread(server).start();
    }

    public void execute() {
        try {
            while (this.isRunning) {
                int num = this.selector.select();
                if (num > 0) {
                    Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        SelectionKey key = it.next();
                        it.remove();
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            this.getConn(key);
                            continue;
                        }
                        if (!key.isReadable()) break;
                        try {
                            this.readMsg(key);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!this.isRunning) {
                    this.stopServer();
                }
                Thread.yield();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SocketServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void getConn(SelectionKey key) throws IOException {
        ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = ssc.accept();
        if (this.acceptHandle != null) {
            this.acceptHandle.accept(socketChannel);
        }
        socketChannel.configureBlocking(false);
        this.sockets.add(socketChannel);
        socketChannel.register(this.selector, 1);
        LogForDebug.info("\u5ba2\u6237\u7aefsocket\u8fde\u63a5\u5df2\u521b\u5efa\uff0c\u76d1\u542c\u4e8b\u4ef6:" + socketChannel.socket().getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readMsg(SelectionKey key) {
        SocketChannel socketChannal = (SocketChannel)key.channel();
        this.buffer.clear();
        int len = 0;
        int sum = 0;
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        try {
            while ((len = socketChannal.read(this.buffer)) > 0) {
                this.buffer.flip();
                sum += len;
                list.add(Bytes.toCopy(this.buffer.array(), len));
                this.buffer.clear();
            }
            if (sum == 0) {
                logger.info("\u63a5\u6536\u5230\u4e00\u4e2a\u7a7a\u6d88\u606f\uff01");
                LogForDebug.info("\u5173\u95ed\u8fde\u63a5socket\u8fde\u63a5" + socketChannal.socket().getRemoteSocketAddress());
                key.cancel();
                if (this.acceptHandle == null) return;
                this.acceptHandle.close((SocketChannel)key.channel());
                return;
            }
            Object obj = Bytes.getObject(list, sum);
            if (obj instanceof TransportObj) {
                TransportObj command = (TransportObj)obj;
                TransportObj result = this.rPCcache.containResult(command.id);
                if (result != null) {
                    socketChannal.write(Bytes.getByteBuffer(result));
                    return;
                }
                if (this.rPCcache.contain(command.id)) {
                    return;
                }
                this.msgHandleService.submit((Runnable)new HandleMsgListener(socketChannal, command));
                return;
            }
            if (obj != null) {
                LogForDebug.info(obj.getClass().toString());
            }
            LogForDebug.info("\u6536\u5230\u4e00\u4e2a\u975e\u6b63\u5f0f\u6d88\u606f!");
            return;
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("\u8fdc\u7a0b\u4e3b\u673a\u5f3a\u8feb\u5173\u95ed\u4e86\u4e00\u4e2a\u73b0\u6709\u7684\u8fde\u63a5") >= 0) {
                LogForDebug.info("\u5173\u95ed\u8fde\u63a5socket\u8fde\u63a5" + socketChannal.socket().getRemoteSocketAddress());
                key.cancel();
                if (this.acceptHandle == null) return;
                this.acceptHandle.close((SocketChannel)key.channel());
                return;
            }
            if (e.getMessage().indexOf("\u60a8\u7684\u4e3b\u673a\u4e2d\u7684\u8f6f\u4ef6\u653e\u5f03\u4e86\u4e00\u4e2a\u5df2\u5efa\u7acb\u7684\u8fde\u63a5") < 0) return;
            LogForDebug.info("\u5173\u95ed\u8fde\u63a5socket\u8fde\u63a5" + socketChannal.socket().getRemoteSocketAddress());
            key.cancel();
            if (this.acceptHandle == null) return;
            this.acceptHandle.close((SocketChannel)key.channel());
            return;
        }
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.execute();
    }

    class HandleMsgListener
    implements Runnable {
        private SocketChannel socketChannal;
        private TransportObj tobj;

        public HandleMsgListener(SocketChannel socketChannal, TransportObj obj) {
            this.socketChannal = socketChannal;
            this.tobj = obj;
        }

        @Override
        public void run() {
            if ("close".equals(this.tobj)) {
                try {
                    this.socketChannal.close();
                    this.socketChannal.socket().close();
                    if (SocketServer.this.acceptHandle != null) {
                        SocketServer.this.acceptHandle.close(this.socketChannal);
                    }
                }
                catch (Exception e) {
                    this.handle(e);
                }
            } else if ("stop".equals(this.tobj)) {
                SocketServer.this.stop();
            } else if (SocketServer.this.msgHandle != null) {
                try {
                    Object result = SocketServer.this.msgHandle.handle(this.tobj.command);
                    TransportObj transportObj = new TransportObj(this.tobj.id, result);
                    SocketServer.this.rPCcache.putResult(transportObj);
                    byte[] bytes = Bytes.getBytes(transportObj);
                    this.socketChannal.write(ByteBuffer.wrap(bytes));
                }
                catch (Exception e) {
                    this.handle(e);
                }
            }
        }

        private void handle(Exception e) {
        }
    }
}

