/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.handler.demux;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoHandlerAdapter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSession;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.handler.demux.MessageHandler;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.handler.demux.UnknownMessageTypeException;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.IdentityHashSet;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class DemuxingIoHandler
extends IoHandlerAdapter {
    private final Map findHandlerCache = new ConcurrentHashMap();
    private final Map type2handler = new ConcurrentHashMap();

    public MessageHandler addMessageHandler(Class type, MessageHandler handler) {
        this.findHandlerCache.clear();
        return this.type2handler.put(type, handler);
    }

    public MessageHandler removeMessageHandler(Class type) {
        this.findHandlerCache.clear();
        return (MessageHandler)this.type2handler.remove(type);
    }

    public MessageHandler getMessageHandler(Class type) {
        return (MessageHandler)this.type2handler.get(type);
    }

    public Map getMessageHandlerMap() {
        return Collections.unmodifiableMap(this.type2handler);
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        MessageHandler handler = this.findHandler(message.getClass());
        if (handler == null) {
            throw new UnknownMessageTypeException("No message handler found for message: " + message);
        }
        handler.messageReceived(session, message);
    }

    protected MessageHandler findHandler(Class type) {
        return this.findHandler(type, null);
    }

    private MessageHandler findHandler(Class type, Set triedClasses) {
        Class superclass;
        MessageHandler handler = null;
        if (triedClasses != null && triedClasses.contains(type)) {
            return null;
        }
        handler = (MessageHandler)this.findHandlerCache.get(type);
        if (handler != null) {
            return handler;
        }
        handler = (MessageHandler)this.type2handler.get(type);
        if (handler == null) {
            if (triedClasses == null) {
                triedClasses = new IdentityHashSet();
            }
            triedClasses.add(type);
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length && (handler = this.findHandler(interfaces[i], triedClasses)) == null; ++i) {
            }
        }
        if (handler == null && (superclass = type.getSuperclass()) != null) {
            handler = this.findHandler(superclass);
        }
        if (handler != null) {
            this.findHandlerCache.put(type, handler);
        }
        return handler;
    }
}

