/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ByteBuffer;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoFilter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSession;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.AbstractIoFilterChain;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramAcceptorDelegate;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramConnectorDelegate;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramService;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.Queue;

class DatagramFilterChain
extends AbstractIoFilterChain {
    DatagramFilterChain(IoSession parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        Queue writeRequestQueue = s.getWriteRequestQueue();
        ByteBuffer buffer = (ByteBuffer)writeRequest.getMessage();
        buffer.mark();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            s.increaseScheduledWriteRequests();
        } else {
            s.increaseScheduledWriteBytes(buffer.remaining());
        }
        Queue queue = writeRequestQueue;
        synchronized (queue) {
            writeRequestQueue.push(writeRequest);
        }
        if (session.getTrafficMask().isWritable()) {
            s.getManagerDelegate().flushSession(s);
        }
    }

    @Override
    protected void doClose(IoSession session) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        DatagramService manager = s.getManagerDelegate();
        if (manager instanceof DatagramConnectorDelegate) {
            ((DatagramConnectorDelegate)manager).closeSession(s);
        } else {
            ((DatagramAcceptorDelegate)manager).getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
        }
    }
}

