/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit;

import com.kingdee.eas.framework.bireport.bimanager.ws.engine.CallBackHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.PageDataFileStoreHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.Task;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.TaskManager;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.WebServiceLogger;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.Result;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientConfig;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientRequestHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientResponseHandler;

public class ClientInstance {
    private String name;
    private TaskManager taskManager;
    private long sessionId;
    private ClientConfig config;

    public ClientInstance(String name, long sessionId, String configFile) {
        this.name = name;
        this.sessionId = sessionId;
        this.config = new ClientConfig(configFile);
        WebServiceLogger.initHandler(this.config.getLogHandler());
        this.taskManager = new TaskManager();
        ClientRequestHandler requestHandler = new ClientRequestHandler(this);
        this.taskManager.setRequestHandler(requestHandler);
        ClientResponseHandler responseHandler = new ClientResponseHandler(this);
        this.taskManager.setResponseHandler(responseHandler);
        this.taskManager.setPageDataStoreHandler(new PageDataFileStoreHandler());
        this.taskManager.startServer();
    }

    public ClientInstance(String name, long sessionId, ClientConfig config) {
        this.name = name;
        this.sessionId = sessionId;
        this.config = config;
        WebServiceLogger.initHandler(config.getLogHandler());
        this.taskManager = new TaskManager();
        ClientRequestHandler requestHandler = new ClientRequestHandler(this);
        this.taskManager.setRequestHandler(requestHandler);
        ClientResponseHandler responseHandler = new ClientResponseHandler(this);
        this.taskManager.setResponseHandler(responseHandler);
        this.taskManager.setPageDataStoreHandler(new PageDataFileStoreHandler());
        this.taskManager.startServer();
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.name;
    }

    public Object execute(Task task) throws Exception {
        this.taskManager.addTask(task);
        Task t = this.taskManager.waitForResponseTask(task.getSessionId(), task.getTaskId(), task.getRequestId(), 0L);
        if (t != null) {
            Result ret = t.getResult();
            if (ret != null) {
                Object data = ret.getData();
                if (data instanceof Exception) {
                    throw (Exception)data;
                }
                return data;
            }
            return null;
        }
        throw new Exception("\u7cfb\u7edf\u5f02\u5e38\uff1a\u4efb\u52a1(" + task.getName() + ")\u4e22\u5931\u3002");
    }

    public void execute(Task task, CallBackHandler cb) {
        this.taskManager.addTask(task, cb);
    }

    public void terminal() {
        this.taskManager.terminal();
    }
}

