/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit;

import com.kingdee.eas.framework.bireport.bimanager.ws.engine.ResponseHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.Task;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.TaskManager;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.WebServiceLogger;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.InvokeMethodFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.WSPageData;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.DataResult;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.ExceptionResult;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.LoginResult;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.NeedLoginResult;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.Result;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.RetryResult;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.WSDLURLResult;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientAgent;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientInstance;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.PriorityBlockingQueue;
import java.net.SocketException;
import java.util.Iterator;
import java.util.List;

public class ClientResponseHandler
implements ResponseHandler {
    private ClientInstance instance;
    private TaskManager tm;
    private PriorityBlockingQueue suspendQueue = new PriorityBlockingQueue();
    private ConcurrentMap loginTaskMap;

    public ClientResponseHandler(ClientInstance instance) {
        this.instance = instance;
        this.tm = instance.getTaskManager();
        this.loginTaskMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(final Task task) {
        Result ret = task.getResult();
        if (ret instanceof RetryResult) {
            this.tm.addTask(task);
            return false;
        }
        if (ret instanceof NeedLoginResult) {
            this.suspendQueue.add((Object)task);
            task.setResult(null);
            WebServiceLogger.logTask(task, "\u6682\u505c\u4efb\u52a1\uff0c\u7b49\u5f85\u767b\u5f55\u3002");
            ConcurrentMap concurrentMap = this.loginTaskMap;
            synchronized (concurrentMap) {
                if (!this.loginTaskMap.containsKey((Object)task.getSessionId())) {
                    Task loginTask = ClientAgent.createBaseTask("Login", this.instance.getSessionId());
                    loginTask.setPriority(Task.priority_highest);
                    loginTask.setMethod(InvokeMethodFactory.login(this.instance.getConfig().getUser(), this.instance.getConfig().getPassword()));
                    this.loginTaskMap.put((Object)loginTask.getSessionId(), (Object)loginTask);
                    WebServiceLogger.logTask(loginTask, "\u767b\u5f55\u8bf7\u6c42\u3002");
                    this.tm.addTask(loginTask);
                }
            }
            return false;
        }
        if (ret instanceof LoginResult) {
            boolean success = (Boolean)((LoginResult)ret).getData();
            if (success) {
                this.loginTaskMap.remove((Object)task.getSessionId());
                WebServiceLogger.logTask(task, "\u767b\u5f55\u6210\u529f\u3002");
                while (this.suspendQueue.size() > 0) {
                    Task curTask = (Task)this.suspendQueue.poll();
                    WebServiceLogger.logTask(curTask, "\u6062\u590d\u4efb\u52a1\u3002");
                    this.tm.addTask(curTask);
                }
            } else {
                ExceptionResult er = new ExceptionResult(new Exception("Login failed."));
                WebServiceLogger.logTask(task, "\u767b\u5f55\u5931\u8d25\u3002");
                while (this.suspendQueue.size() > 0) {
                    Task curTask = (Task)this.suspendQueue.poll();
                    curTask.setResult(er);
                    WebServiceLogger.logTask(curTask, "\u53d6\u6d88\u4efb\u52a1(\u767b\u5f55\u5931\u8d25)\u3002");
                    this.tm.dealResponse(curTask);
                }
            }
            return true;
        }
        if (ret instanceof WSDLURLResult) {
            List data = (List)((WSDLURLResult)ret).getData();
            if (data != null && !data.isEmpty()) {
                this.loginTaskMap.remove((Object)task.getSessionId());
                while (this.suspendQueue.size() > 0) {
                    Task curTask = (Task)this.suspendQueue.poll();
                    WebServiceLogger.logTask(curTask, "\u6062\u590d\u4efb\u52a1\u3002");
                    this.tm.addTask(curTask);
                }
            } else {
                ExceptionResult er = new ExceptionResult(new Exception("\u83b7\u53d6WSDLURL\u5f02\u5e38,url\u4e3a\u914d\u7f6e!"));
                while (this.suspendQueue.size() > 0) {
                    Task curTask = (Task)this.suspendQueue.poll();
                    curTask.setResult(er);
                    this.tm.dealResponse(curTask);
                }
            }
            return true;
        }
        if (ret instanceof ExceptionResult) {
            Exception e = (Exception)((ExceptionResult)ret).getData();
            if (e.getCause() instanceof SocketException) {
                if (task.getRetryCount() < this.instance.getConfig().getRetryCount()) {
                    final int retryDelaySeconds = this.instance.getConfig().getRetryDelaySeconds();
                    WebServiceLogger.logTask(task, "\u7f51\u7edc\u9519\u8bef\uff0c\u5df2\u91cd\u8bd5\u6b21\u6570=" + task.getRetryCount() + "(<" + this.instance.getConfig().getRetryCount() + ")\uff0c" + retryDelaySeconds + "\u79d2\u540e\u91cd\u8bd5...");
                    task.incRetryCount();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(retryDelaySeconds * 1000);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ClientResponseHandler.this.tm.addTask(task);
                        }
                    }.start();
                    return false;
                }
                WebServiceLogger.logTask(task, "\u7f51\u7edc\u9519\u8bef\uff0c\u91cd\u8bd5\u6b21\u6570=" + task.getRetryCount() + "\uff0c\u91cd\u8bd5\u5931\u8d25\u3002");
            } else {
                WebServiceLogger.logTask(task, "\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
            }
            return true;
        }
        if (ret instanceof DataResult) {
            Object data = ret.getData();
            if (data instanceof WSPageData) {
                boolean requestNext;
                WSPageData pd = (WSPageData)data;
                task.setPageCount(pd.getPageCount());
                if (task.getPageCount() == 1) {
                    try {
                        task.setResult(new DataResult(this.tm.getPageDataStoreHandler().iterator(pd)));
                        return true;
                    }
                    catch (Exception e) {
                        task.setResult(new ExceptionResult(e));
                        return true;
                    }
                }
                try {
                    this.tm.getPageDataStoreHandler().storePage(task, pd);
                }
                catch (Exception e) {
                    task.setResult(new ExceptionResult(e));
                    return true;
                }
                boolean bl = requestNext = pd.getPageIndex() < task.getPageCount() - 1;
                if (requestNext) {
                    task.setMethod(InvokeMethodFactory.getPacketData(pd.getPageIndex() + 1));
                    this.tm.addTask(task);
                    return false;
                }
                try {
                    Iterator itr = this.tm.getPageDataStoreHandler().loadPages(task);
                    task.setResult(new DataResult(itr));
                    return true;
                }
                catch (Exception e) {
                    task.setResult(new ExceptionResult(e));
                    return true;
                }
            }
            return true;
        }
        return true;
    }
}

