/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.app.AbstractDownloadLogsFacadeControllerBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copydir;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

public class DownloadLogsFacadeControllerBean
extends AbstractDownloadLogsFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.common.app.DownloadLogsFacadeControllerBean");

    @Override
    protected byte[] _getLogFiles(Context ctx, String fileNames) throws BOSException {
        this.compressExe("copy_logs.zip", fileNames);
        byte[] logs = this.getLogs();
        return logs;
    }

    private void compressExe(String destFileName, String fileIncludes) {
        String[] fileNames;
        File zipFile = new File(destFileName);
        File copyFile = new File("copy_logs");
        String path = System.getProperty("user.dir");
        path = path.substring(0, path.lastIndexOf("bin")) + "logs";
        File srcdir = new File(path);
        Project prj = new Project();
        Delete del = new Delete();
        del.setDir(copyFile);
        del.setProject(prj);
        Copydir copy = new Copydir();
        copy.setDest(copyFile);
        copy.setSrc(srcdir);
        for (String fileInclude : fileNames = fileIncludes.split(",")) {
            copy.setIncludes("*" + fileInclude + "*");
        }
        copy.setExcludes("apusic.log.0.lck");
        copy.setProject(prj);
        while (!copyFile.exists()) {
            try {
                copy.execute();
            }
            catch (Exception e) {
                logger.error((Object)e);
                del.execute();
            }
        }
        Zip zip = new Zip();
        zip.setProject(prj);
        zip.setDestFile(zipFile);
        FileSet fileSet = new FileSet();
        fileSet.setProject(prj);
        fileSet.setDir(copyFile);
        zip.addFileset(fileSet);
        zip.execute();
        del.execute();
    }

    private byte[] getLogs() throws BOSException {
        File file = new File("copy_logs.zip");
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] fileArr = new byte[((InputStream)input).available()];
            ((InputStream)input).read(fileArr, 0, fileArr.length);
            ((InputStream)input).close();
            Project prj = new Project();
            Delete del = new Delete();
            del.setFile(file);
            del.setProject(prj);
            del.execute();
            byte[] byArray = fileArr;
            return byArray;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }
}

