/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.model;

import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DataRow
implements Serializable,
Comparable,
IMarshalObject {
    private static final long serialVersionUID = 7923850397766708694L;
    public String pkColumn;
    private Map values;
    private Map manyToOne;
    private Map oneToMany;

    public DataRow() {
    }

    public DataRow(StructuredDataModel.TableModel tableModel) {
        this.pkColumn = tableModel.pkColumn.name;
        this.values = new HashMap(tableModel.columns.length);
    }

    public void setValue(String name, Object value) {
        this.values.put(name, value);
    }

    public Map getValues() {
        return this.values;
    }

    public DataRow getParentDataRow(String tableName) {
        if (this.manyToOne != null) {
            return (DataRow)this.manyToOne.get(tableName);
        }
        return null;
    }

    public DataRow[] getChildrenDataRows(String tableName) {
        if (this.oneToMany != null) {
            return (DataRow[])this.oneToMany.get(tableName);
        }
        return null;
    }

    public DataRow[] getFirstChildrenDataRows() {
        if (this.oneToMany != null && this.oneToMany.values().size() > 0) {
            return (DataRow[])this.oneToMany.values().iterator().next();
        }
        return null;
    }

    public void addChildrenDataRow(String tableName, DataRow dataRow) {
        DataRow[] refDataRows;
        if (this.oneToMany == null) {
            this.oneToMany = new HashMap();
        }
        if ((refDataRows = (DataRow[])this.oneToMany.get(tableName)) == null) {
            refDataRows = new DataRow[1];
            this.oneToMany.put(tableName, refDataRows);
            refDataRows[0] = dataRow;
        } else {
            DataRow[] _refDataRows = new DataRow[refDataRows.length + 1];
            System.arraycopy(refDataRows, 0, _refDataRows, 0, refDataRows.length);
            _refDataRows[refDataRows.length] = dataRow;
            this.oneToMany.put(tableName, _refDataRows);
        }
    }

    public void setParentDataRow(String tableName, DataRow dataRow) {
        if (this.manyToOne == null) {
            this.manyToOne = new HashMap();
        }
        this.manyToOne.put(tableName, dataRow);
    }

    public int hashCode() {
        return this.values.get(this.pkColumn).hashCode();
    }

    public boolean equals(Object obj) {
        return ((DataRow)obj).values.get(this.pkColumn).equals(this.values.get(this.pkColumn));
    }

    public int compareTo(Object obj) {
        Comparable c1 = null;
        c1 = obj instanceof DataRow ? (Comparable)((DataRow)obj).values.get(this.pkColumn) : (Comparable)obj;
        Comparable c2 = (Comparable)this.values.get(this.pkColumn);
        if (c1 == null || c2 == null) {
            throw new NullPointerException("pk field is null!");
        }
        if (c1.getClass() != c2.getClass()) {
            throw new IllegalArgumentException("unsupported compare between '" + c1.getClass().getName() + "' and '" + c2.getClass().getName() + "'");
        }
        return -c1.compareTo(c2);
    }

    public String toString() {
        return this.values.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void marshal(Marshaller marshaller) throws IOException {
        this.writeMap(marshaller, this.manyToOne);
        this.writeMap(marshaller, this.oneToMany);
        marshaller.writeObject((Object)this.values);
        marshaller.writeObject((Object)this.pkColumn);
    }

    private void writeMap(Marshaller marshaller, Map map) throws IOException {
        if (map == null || map.size() == 0) {
            marshaller.writeInt(0);
        } else {
            marshaller.writeInt(map.size());
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                marshaller.writeObject(entry.getKey());
                if (entry.getValue().getClass().isArray()) {
                    marshaller.writeBoolean(true);
                    DataRow[] dataRows = (DataRow[])entry.getValue();
                    marshaller.writeInt(dataRows.length);
                    for (DataRow dataRow : dataRows) {
                        marshaller.writeObject((Object)dataRow);
                    }
                    continue;
                }
                marshaller.writeBoolean(false);
                marshaller.writeObject(entry.getValue());
            }
        }
    }

    private Map readMap(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int mapSize = unmarshaller.readInt();
        if (mapSize == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String key = (String)unmarshaller.readObject();
            boolean isArray = unmarshaller.readBoolean();
            if (isArray) {
                int arrayLength = unmarshaller.readInt();
                DataRow[] dataRows = new DataRow[arrayLength];
                for (int j = 0; j < arrayLength; ++j) {
                    dataRows[j] = (DataRow)unmarshaller.readObject();
                }
                map.put(key, dataRows);
                continue;
            }
            map.put(key, unmarshaller.readObject());
        }
        return map;
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.manyToOne = this.readMap(unmarshaller);
        this.oneToMany = this.readMap(unmarshaller);
        this.values = (Map)unmarshaller.readObject();
        this.pkColumn = (String)unmarshaller.readObject();
    }
}

