/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet;

import com.kingdee.eas.csinterface.agent.base.Encoding;
import com.kingdee.eas.csinterface.agent.util.PacketsUtil;
import com.kingdee.eas.csinterface.util.AES;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class PacketsEncoder {
    public static final String COOKIE_ENCODING = "encoding";
    private static Logger logger = Logger.getLogger(PacketsEncoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] receive(InputStream inputStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        try {
            int len;
            while ((len = inputStream.read(buf)) > 0) {
                output.write(buf, 0, len);
            }
        }
        finally {
            try {
                output.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return output.toByteArray();
    }

    public static final byte[] decodeByteArrays(byte[] byteArrays, Encoding encoding, String encryptKey) throws IOException {
        byte[] responseBytes = byteArrays;
        if (encoding != null) {
            try {
                switch (encoding) {
                    case ENCRYPT: {
                        if (encryptKey == null) {
                            throw new RuntimeException("encoding is " + (Object)((Object)encoding) + ", but encryptKey is null!");
                        }
                        responseBytes = AES.decrypt(responseBytes, encryptKey);
                        break;
                    }
                    case GZIP: {
                        responseBytes = PacketsUtil.ungzip(responseBytes);
                        break;
                    }
                    case GZIP_AND_ENCRYPT: {
                        if (encryptKey == null) {
                            throw new RuntimeException("encoding is " + (Object)((Object)encoding) + ", but encryptKey is null!");
                        }
                        responseBytes = PacketsUtil.decryptAndUngzip(responseBytes, encryptKey);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported encoding : " + (Object)((Object)encoding));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u5904\u7406\u8fd4\u56de\u62a5\u6587\u51fa\u9519,\u7f16\u7801\u4e3a:" + (Object)((Object)encoding), e);
            }
        }
        return responseBytes;
    }

    public static final byte[] parseInputStream(String encodeCookieVal, InputStream inputStream, String encryptKey) throws IOException {
        byte[] responseBytes = PacketsEncoder.receive(inputStream);
        if (encodeCookieVal != null) {
            Encoding encoding = Encoding.convert(encodeCookieVal);
            return PacketsEncoder.decodeByteArrays(responseBytes, encoding, encryptKey);
        }
        return responseBytes;
    }

    public static final byte[] encodeOuputStream(byte[] bytes, String encryptKey, Encoding encoding) {
        if (encoding != null) {
            try {
                switch (encoding) {
                    case ENCRYPT: {
                        if (encryptKey == null) {
                            throw new RuntimeException("encoding is " + (Object)((Object)encoding) + ", but encryptKey is null!");
                        }
                        bytes = AES.encrypt(bytes, encryptKey);
                        break;
                    }
                    case GZIP: {
                        bytes = PacketsUtil.gzip(bytes);
                        break;
                    }
                    case GZIP_AND_ENCRYPT: {
                        if (encryptKey == null) {
                            throw new RuntimeException("encoding is " + (Object)((Object)encoding) + ", but encryptKey is null!");
                        }
                        bytes = PacketsUtil.gzipAndEncrypt(bytes, encryptKey);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported encoding : " + (Object)((Object)encoding));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u5904\u7406\u53d1\u9001\u62a5\u6587\u51fa\u9519,\u7f16\u7801\u4e3a:" + (Object)((Object)encoding), e);
            }
        }
        return bytes;
    }

    public static final byte[] encodeOuputStream(byte[] bytes, String encryptKey, String encodeCookieVal) {
        Encoding encoding = Encoding.convert(encodeCookieVal);
        if (encoding != null) {
            try {
                switch (encoding) {
                    case ENCRYPT: {
                        if (encryptKey == null) {
                            throw new RuntimeException("encoding is " + (Object)((Object)encoding) + ", but encryptKey is null!");
                        }
                        bytes = AES.encrypt(bytes, encryptKey);
                        break;
                    }
                    case GZIP: {
                        bytes = PacketsUtil.gzip(bytes);
                        break;
                    }
                    case GZIP_AND_ENCRYPT: {
                        if (encryptKey == null) {
                            throw new RuntimeException("encoding is " + (Object)((Object)encoding) + ", but encryptKey is null!");
                        }
                        bytes = PacketsUtil.gzipAndEncrypt(bytes, encryptKey);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported encoding : " + (Object)((Object)encoding));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u5904\u7406\u53d1\u9001\u62a5\u6587\u51fa\u9519,\u7f16\u7801\u4e3a:" + (Object)((Object)encoding), e);
            }
        }
        return bytes;
    }
}

