/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.openapi.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.AbstractOpenAPIServlet;
import com.kingdee.eas.csinterface.agent.util.WebUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OpenAPIPackImpl
extends AbstractOpenAPIServlet {
    private static final Logger logger = Logger.getLogger(OpenAPIPackImpl.class);

    @Override
    public Object process(Context ctx, HttpServletRequest request, HttpServletResponse response, Map<String, String> params, String reqContent) {
        String uri = request.getRequestURI();
        logger.info((Object)("[EIP]request URI : " + uri));
        uri = WebUtil.relative("/easportal/eip", uri);
        uri = uri.startsWith("/") ? uri : "/" + uri;
        BOSObjectType bosType = null;
        String bosTypeStr = uri.substring(9, 17);
        String action = uri.substring(uri.lastIndexOf("/") + 1);
        try {
            bosType = BOSObjectType.create((String)bosTypeStr);
        }
        catch (Exception ex) {
            return "invalid request url";
        }
        String filterStr = request.getParameter("filter");
        String dataType = request.getParameter("dataType");
        Object invokeResult = OpenAPIPackImpl.invokeStateChange(ctx, bosType, action, filterStr, dataType);
        return invokeResult;
    }

    public static Object invokeStateChange(Context ctx, BOSObjectType bosType, String action, String filterStr, String dataType) {
        Object invokeResult = null;
        try {
            EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bosType);
            String factoryName = eoi.getBusinessImplName() + "Factory";
            Class<?> entityFactory = Class.forName(factoryName);
            Method method = entityFactory.getMethod("getLocalInstance", Context.class);
            Object entityMethodObj = method.invoke(entityFactory, ctx);
            Class<?> facade = entityMethodObj.getClass();
            Method method2 = facade.getMethod(action, FilterInfo.class);
            FilterInfo filter = null;
            HashSet<String> numSet = new HashSet<String>();
            if (StringUtils.equalsIgnoreCase((String)dataType, (String)"SQL")) {
                filter = new FilterInfo(filterStr);
            } else {
                filter = new FilterInfo();
                String[] filters = filterStr.split(",");
                for (int i = 0; i < filters.length; ++i) {
                    numSet.add(filters[i]);
                }
                if (StringUtils.equalsIgnoreCase((String)dataType, (String)"ID")) {
                    filter.getFilterItems().add(new FilterItemInfo("id", numSet, CompareType.INCLUDE));
                } else if (StringUtils.equalsIgnoreCase((String)dataType, (String)"number")) {
                    filter.getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
                }
            }
            invokeResult = method2.invoke(entityMethodObj, filter);
            IBOTRelation instance = BOTRelationFactory.getLocalInstance((Context)ctx);
            FilterInfo fl = new FilterInfo();
            fl.getFilterItems().add(new FilterItemInfo("destObjectID", numSet, CompareType.INCLUDE));
            IObjectPK[] pks = instance.getPKList(fl, null);
            if (pks != null && pks.length > 0) {
                for (IObjectPK pk : pks) {
                    instance.delete(pk);
                }
            }
        }
        catch (Exception e) {
            invokeResult = e.getMessage();
            logger.error((Object)"invoke state change error.", (Throwable)e);
        }
        return invokeResult;
    }
}

