/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.service.json.JSONObject;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BillDataStatus;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.BufferedBillDataProvider;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataSynSender;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.agent.servlet.processor.BaseDataServlet;
import com.kingdee.eas.csinterface.app.DynamicBillBatchInsertHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynTable;
import com.kingdee.eas.csinterface.basedatasyn.ITableStructure;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureCollection;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureFactory;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.monitor.app.SrcToMidBillMonitorLogInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class BaseDataSynServlet
extends RequestProcessor {
    ConcurrentHashMap<Integer, List<Object>> chunkedWaitAckIDs;
    private static Logger logger = Logger.getLogger(BaseDataSynServlet.class);

    @Override
    public String getTargetURI() {
        return "/basedatasyn/data";
    }

    @Override
    public String process(Map<String, String> params, String reqBody) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String initBuffer(Map<String, String> params, String reqBody) throws Exception {
        return null;
    }

    public int getDBType(Connection conn) throws Exception {
        int dbType = 0;
        if (DBUtil.isOracle((Connection)conn)) {
            dbType = 2;
        } else if (DBUtil.isDB2((Connection)conn)) {
            dbType = 1;
        } else if (DBUtil.isMSSQL((Connection)conn)) {
            dbType = 3;
        }
        return dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeStatusBack(Map<String, String> params, String reqBody) throws Exception {
        String checkLicenceMsg = BaseDataServlet.checkLicence(this.ctx);
        if (!StringUtils.isEmpty((String)checkLicenceMsg)) {
            return checkLicenceMsg;
        }
        JSONObject reqJSON = new JSONObject(reqBody);
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        JSONObject errorObj = new JSONObject();
        String cmd = reqJSON.getString("cmd");
        String tableId = reqJSON.getString("tableId");
        String haveAckTransmitSerialNumber = reqJSON.getString("transmitSerialNumber");
        String transmitTrunkNumber = reqJSON.getString("transmitTrunkNumber");
        IObjectPK pk = CommonUtil.convert2PK(tableId);
        BaseDataSynTableInfo baseDataSynTableInfo = BaseDataSynTableFactory.getLocalInstance(this.ctx).getBaseDataSynTableInfo(pk);
        try (BufferedBillDataProvider bufferDataProvider = new BufferedBillDataProvider(baseDataSynTableInfo);){
            bufferDataProvider.open(this.ctx);
            if (!StringUtils.isEmpty((String)cmd)) {
                if ("delete".equals(cmd)) {
                    bufferDataProvider.feedback(haveAckTransmitSerialNumber, 0, 2, BillDataStatus.ack, true);
                } else {
                    bufferDataProvider.feedback(haveAckTransmitSerialNumber, Integer.valueOf(transmitTrunkNumber), 2, BillDataStatus.ack, false);
                }
            }
            this.saveSubMonitorLog(reqJSON, baseDataSynTableInfo);
        }
        JSONObject obj = new JSONObject(resultInfo);
        obj.put("errorMap", errorObj.toString());
        return obj.toString();
    }

    public void saveSubMonitorLog(JSONObject reqJSON, BaseDataSynTableInfo baseDataSynTableInfo) throws Exception {
        String successNumber = reqJSON.getString("success");
        String failureNumber = reqJSON.getString("failure");
        String existNumber = reqJSON.getString("exist");
        String tableName = baseDataSynTableInfo.getTableName();
        String monitorLogId = reqJSON.getString("monitorLogId");
        int successCount = BaseDataSynServlet.getNumberCount(successNumber);
        int failureCount = BaseDataSynServlet.getNumberCount(failureNumber);
        int existCount = BaseDataSynServlet.getNumberCount(existNumber);
        boolean isMainTable = baseDataSynTableInfo.isMainTable();
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(baseDataSynTableInfo.getParent().getId().toString()));
        String planNumber = headInfo.getNumber();
        SubMonitorLogInfo logInfo = new SubMonitorLogInfo();
        logInfo.setCmd("add");
        logInfo.setSuccess(successNumber);
        logInfo.setFailure(failureNumber);
        logInfo.setTableName(tableName);
        logInfo.setMonitorLogId(monitorLogId);
        logInfo.setSuccessCount(successCount);
        logInfo.setFailureCount(failureCount);
        logInfo.setExistCount(existCount);
        logInfo.setMainTable(isMainTable);
        logInfo.setPlanNumber(planNumber);
        SubMonitorLogFactory.getLocalInstance(this.ctx).addnew(logInfo);
    }

    public static final int getNumberCount(String obj) {
        int count = 0;
        if (StringUtils.isEmpty((String)obj)) {
            return count;
        }
        try {
            count = obj.split(",").length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeStatusBack4Change(Map<String, String> params, String reqBody) throws Exception {
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        JSONObject reqJSON = new JSONObject(reqBody);
        String transactionTrunkNumber = reqJSON.getString("transactionTrunkNumber");
        String transactionNumber = reqJSON.getString("transactionNumber");
        String cmd = reqJSON.getString("cmd");
        String type = reqJSON.getString("type");
        String tableId = reqJSON.getString("tableId");
        IObjectPK pk = CommonUtil.convert2PK(tableId);
        BaseDataSynTableInfo baseDataSynTableInfo = BaseDataSynTableFactory.getLocalInstance(this.ctx).getBaseDataSynTableInfo(pk);
        try (BufferedBillDataProvider bufferDataProvider = new BufferedBillDataProvider(baseDataSynTableInfo);){
            bufferDataProvider.open(this.ctx);
            if (!StringUtils.isEmpty((String)cmd) && !StringUtils.isEmpty((String)type)) {
                if ("add".equals(cmd) && "fail".equals(type) || "del".equals(cmd) && "success".equals(type)) {
                    bufferDataProvider.feedback4Change(Integer.valueOf(transactionTrunkNumber), transactionNumber, BillDataStatus.ack, true, this.ctx);
                } else if ("add".equals(cmd) && "success".equals(type) || "update".equals(cmd) && "success".equals(type)) {
                    bufferDataProvider.feedback4Change(Integer.valueOf(transactionTrunkNumber), transactionNumber, BillDataStatus.ack, false, this.ctx);
                } else if ("update".equals(cmd) && "fail".equals(type) || "del".equals(cmd) && "fail".equals(type)) {
                    bufferDataProvider.feedback4Change(Integer.valueOf(transactionTrunkNumber), transactionNumber, BillDataStatus.invalid, false, this.ctx);
                }
            }
            this.saveSubMonitorLog4Change(reqJSON, baseDataSynTableInfo);
        }
        return new JSONObject(resultInfo).toString();
    }

    public void saveSubMonitorLog4Change(JSONObject reqJSON, BaseDataSynTableInfo baseDataSynTableInfo) throws Exception {
        String updateIds = reqJSON.getString("updateIds");
        String cmd = reqJSON.getString("cmd");
        String type = reqJSON.getString("type");
        String monitorLogId = reqJSON.getString("monitorLogId");
        boolean isDelete = "del".equals(cmd);
        boolean isSuccess = "success".equals(type);
        int updateCount = BaseDataSynServlet.getNumberCount(updateIds);
        String tableName = baseDataSynTableInfo.getTableName();
        boolean isMainTable = baseDataSynTableInfo.isMainTable();
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(this.ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(baseDataSynTableInfo.getParent().getId().toString()));
        String planNumber = headInfo.getNumber();
        SubMonitorLogInfo logInfo = new SubMonitorLogInfo();
        if (isSuccess) {
            logInfo.setSuccess(updateIds);
            logInfo.setSuccessCount(updateCount);
        } else {
            logInfo.setFailure(updateIds);
            logInfo.setFailureCount(updateCount);
        }
        logInfo.setCmd(cmd);
        logInfo.setTableName(tableName);
        logInfo.setMonitorLogId(monitorLogId);
        logInfo.setExistCount(0);
        logInfo.setMainTable(isMainTable);
        logInfo.setPlanNumber(planNumber);
        SubMonitorLogFactory.getLocalInstance(this.ctx).addnew(logInfo);
    }

    public String saveTableStructure(Map<String, String> params, String reqJSON) throws Exception {
        logger.error((Object)reqJSON.toString());
        ITableStructure tableStructure = TableStructureFactory.getLocalInstance(this.ctx);
        TableStructureCollection coll = tableStructure.getTableStructureCollection();
        HashMap<String, TableStructureInfo> map = new HashMap<String, TableStructureInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            TableStructureInfo info = coll.get(i);
            map.put(info.getIP() + info.getPort() + info.getInstance() + info.getTableName(), info);
        }
        JSONArray array = JSON.parseArray((String)reqJSON);
        TableStructureCollection colls = new TableStructureCollection();
        for (int i = 0; i < array.size(); ++i) {
            com.alibaba.fastjson.JSONObject jsonObject = array.getJSONObject(i);
            String ip = jsonObject.getString("IP");
            String port = jsonObject.getString("port");
            String instance = jsonObject.getString("instance");
            String tableName = jsonObject.getString("tableName");
            String colName = jsonObject.getString("colName");
            TableStructureInfo tableStructureInfo = (TableStructureInfo)map.get(ip + port + instance + tableName);
            if (tableStructureInfo == null) {
                tableStructureInfo = new TableStructureInfo();
                tableStructureInfo.setIP(ip);
                tableStructureInfo.setPort(Integer.parseInt(port));
                tableStructureInfo.setInstance(instance);
                tableStructureInfo.setTableName(tableName);
            }
            tableStructureInfo.setColumnModel(colName);
            colls.add(tableStructureInfo);
        }
        CoreBaseCollection objCol = new CoreBaseCollection();
        objCol.addObjectCollection((IObjectCollection)colls);
        tableStructure.save(objCol);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeStatusBackBatchTable(Map<String, String> params, String reqBody) throws Exception {
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        JSONObject reqJSON = new JSONObject(reqBody);
        String haveAckTransmitSerialNumber = params.get("haveAckTransmitSerialNumber");
        String cmd = reqJSON.getString("cmd");
        String tableId = reqJSON.getString("tableId");
        IObjectPK pk = CommonUtil.convert2PK(tableId);
        BaseDataSynTableInfo baseDataSynTableInfo = BaseDataSynTableFactory.getLocalInstance(this.ctx).getBaseDataSynTableInfo(pk);
        try (BufferedBillDataProvider bufferDataProvider = new BufferedBillDataProvider(baseDataSynTableInfo);){
            bufferDataProvider.open(this.ctx);
            if (!StringUtils.isEmpty((String)cmd) && "delete".equals(cmd)) {
                bufferDataProvider.feedback(haveAckTransmitSerialNumber, 0, 2, BillDataStatus.ack, true);
            } else {
                bufferDataProvider.feedback(haveAckTransmitSerialNumber, Integer.MAX_VALUE, 2, BillDataStatus.ack, false);
            }
        }
        return new JSONObject(resultInfo).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeStatusBack4DeleteRecords(Map<String, String> params, String reqBody) throws Exception {
        String checkLicenceMsg = BaseDataServlet.checkLicence(this.ctx);
        if (!StringUtils.isEmpty((String)checkLicenceMsg)) {
            return checkLicenceMsg;
        }
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        HashMap errorMap = new HashMap();
        String haveAckTransmitSerialNumber = "";
        String cmd = params.get("cmd");
        JSONArray deleteArray = JSONArray.parseArray((String)params.get("deleteMap"));
        for (int i = 0; i < deleteArray.size(); ++i) {
            com.alibaba.fastjson.JSONObject tmpObj = (com.alibaba.fastjson.JSONObject)deleteArray.get(i);
            String tableName = tmpObj.getString("tableName");
            String deleteIds = tmpObj.getString("deleteList");
            BaseDataSynTableCollection baseDataSynTableColl = BaseDataSynTableFactory.getLocalInstance(this.ctx).getBaseDataSynTableCollection(" where tableName='" + tableName + "'");
            if (baseDataSynTableColl == null || baseDataSynTableColl.size() <= 0) continue;
            BaseDataSynTableInfo tableInfo = baseDataSynTableColl.get(0);
            try (BufferedBillDataProvider bufferDataProvider = new BufferedBillDataProvider(tableInfo);){
                bufferDataProvider.open(this.ctx);
                if (!StringUtils.isEmpty((String)cmd) && "delete".equals(cmd)) {
                    bufferDataProvider.feedback(deleteIds, BillDataStatus.ack, true);
                    continue;
                }
                bufferDataProvider.feedback(haveAckTransmitSerialNumber, Integer.MAX_VALUE, 2, BillDataStatus.ack, false);
                continue;
            }
        }
        JSONObject obj = new JSONObject(resultInfo);
        obj.put("errorMap", errorMap);
        return obj.toString();
    }

    public String transfer(Map<String, String> params, String reqBody) throws Exception {
        String checkLicenceMsg = BaseDataServlet.checkLicence(this.ctx);
        if (!StringUtils.isEmpty((String)checkLicenceMsg)) {
            return checkLicenceMsg;
        }
        JSONObject reqJSON = new JSONObject(reqBody);
        String tableId = reqJSON.getString("tableId");
        String ids = reqJSON.getString("ids");
        int pageSize = BaseDataSynServlet.string2List(ids, ",").size();
        boolean isMainTable = Boolean.valueOf(reqJSON.getString("isMaintable"));
        String transmitSerialNumber = reqJSON.getString("transmitSerialNumber");
        int transmitChunkedNumber = Integer.valueOf(reqJSON.getString("transactionTrunkNumber"));
        BaseDataRunner baseDataRunner = null;
        HashMap<String, Object> mappingJson = new HashMap<String, Object>();
        BaseDataSynTableInfo baseDataSynTableInfo = null;
        IObjectPK pk = null;
        try {
            IBaseDataSynTable tableInstance = BaseDataSynTableFactory.getLocalInstance(this.ctx);
            try {
                pk = CommonUtil.convert2PK(tableId);
            }
            catch (Exception e) {
                ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_ERROR.clone();
                mappingJson.put("transmitSerialNumber", transmitSerialNumber);
                mappingJson.put("entrys", new ArrayList());
                resultInfo.setData(mappingJson);
                JSONObject json = new JSONObject(resultInfo);
                return json.toString();
            }
            baseDataSynTableInfo = tableInstance.getBaseDataSynTableInfo(pk);
            baseDataRunner = new BaseDataRunner(baseDataSynTableInfo, this.ctx, true, ids, transmitSerialNumber, transmitChunkedNumber, isMainTable);
            baseDataRunner.startRunBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseDataSynSender dataSender = null;
        try {
            dataSender = new BaseDataSynSender(this.getResponse(), this.encryptKey, this.encoding, baseDataRunner, transmitSerialNumber, transmitChunkedNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSender.send();
    }

    public String transferChangeData(Map<String, String> params, String reqBody) throws Exception {
        String checkLicenceMsg = BaseDataServlet.checkLicence(this.ctx);
        if (!StringUtils.isEmpty((String)checkLicenceMsg)) {
            return checkLicenceMsg;
        }
        JSONObject reqJSON = new JSONObject(reqBody);
        String type = reqJSON.getString("type");
        String tableId = reqJSON.getString("tableId");
        String updateIds = reqJSON.getString("ids");
        String transmitSerialNumber = reqJSON.getString("transmitSerialNumber");
        int transmitChunkedNumber = 1;
        try {
            transmitChunkedNumber = Integer.parseInt(reqJSON.getString("transactionTrunkNumber"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseDataRunner baseDataRunner = null;
        HashMap<String, Object> mappingJson = new HashMap<String, Object>();
        BaseDataSynTableInfo baseDataSynTableInfo = null;
        IObjectPK pk = null;
        try {
            IBaseDataSynTable tableInstance = BaseDataSynTableFactory.getLocalInstance(this.ctx);
            try {
                pk = CommonUtil.convert2PK(tableId);
            }
            catch (Exception e) {
                ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_OBJECT_NOT_FOUND.clone();
                mappingJson.put("transmitSerialNumber", transmitSerialNumber);
                mappingJson.put("entrys", new ArrayList());
                resultInfo.setData(mappingJson);
                JSONObject json = new JSONObject(resultInfo);
                return json.toString();
            }
            baseDataSynTableInfo = tableInstance.getBaseDataSynTableInfo(pk);
            baseDataRunner = new BaseDataRunner(baseDataSynTableInfo, this.ctx, true, updateIds, transmitSerialNumber, transmitChunkedNumber, type);
            baseDataRunner.startRunChange();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseDataSynSender dataSender = null;
        try {
            dataSender = new BaseDataSynSender(this.getResponse(), this.encryptKey, this.encoding, baseDataRunner, transmitSerialNumber, transmitChunkedNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSender.send4Change();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    private String getMainTableFIDS(String mainTbId) throws Exception {
        StringBuffer mainIDs = new StringBuffer();
        IBaseDataSynTable tableInstance = BaseDataSynTableFactory.getLocalInstance(this.ctx);
        IObjectPK pk = CommonUtil.convert2PK(mainTbId);
        BaseDataSynTableInfo tableInfo = tableInstance.getBaseDataSynTableInfo(pk);
        BaseDataRunner baseDataRunner = new BaseDataRunner(tableInfo, this.ctx, 0, Integer.MAX_VALUE, false, "", tableInfo.getSrcWhere(), tableInfo.getRelateSQL(), true, "");
        UserInfo userInfo = null;
        for (Object obj : this.ctx.getUserDefineFieldKeySet()) {
            if (!(this.ctx.get(obj) instanceof UserInfo)) continue;
            userInfo = (UserInfo)this.ctx.get(obj);
            break;
        }
        EipUserInfo eipUserInfo = BaseDataServlet.getEipUser(this.ctx);
        String ksql = baseDataRunner.initQuerySql(tableInfo.getTableName(), eipUserInfo.getId().toString());
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        boolean count = false;
        try {
            String s2222222 = "";
            conn = DBUtils.getConnection(this.ctx);
            s2222222 = !(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)this.getDBType(conn)) : ksql;
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(s2222222);
            while (resultSet.next()) {
                mainIDs.append("'" + resultSet.getObject("FID") + "',");
            }
        }
        catch (SqlTranslateException s2222222) {
            SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
        }
        catch (SQLException s2222222) {
            SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        String result = "";
        result = mainIDs.lastIndexOf(",") > -1 ? mainIDs.deleteCharAt(mainIDs.lastIndexOf(",")).toString() : mainIDs.toString();
        return result.toString();
    }

    public String monitorLog(Map<String, String> params, String reqBody) throws Exception {
        String number = params.get("number");
        String transmitSerialNumber = params.get("transmitSerialNumber");
        try {
            SrcToMidBillMonitorLogInfo monitorLogInfo = MonitorManager.enterSrcToMidBill(this.ctx, "\u5ba2\u6237\u7aef\u4ee3\u7406/Web", number, transmitSerialNumber);
            if (StringUtils.isEmpty((String)transmitSerialNumber)) {
                throw new Exception("miss parameter '" + transmitSerialNumber + "'");
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            MonitorManager.error(e);
            throw new Error(e);
        }
        finally {
            MonitorManager.exit(this.ctx);
            DynamicBillBatchInsertHelper.close();
        }
    }

    private static File getCacheDir() {
        return new File("W:" + File.pathSeparator + "Cathe");
    }

    public static String list2String(List<String> list, String sperate) {
        StringBuffer result = new StringBuffer();
        for (int j = 0; j < list.size(); ++j) {
            String tmpId = list.get(j);
            result.append(tmpId + sperate);
        }
        if (result.lastIndexOf(sperate) > -1) {
            result.deleteCharAt(result.lastIndexOf(sperate));
        }
        return result.toString();
    }

    public static List<String> string2List(String str, String sperate) {
        Object[] mainIdArray = new String[]{};
        if (!StringUtils.isEmpty((String)str)) {
            mainIdArray = str.split(sperate);
        }
        return Arrays.asList((Object[])mainIdArray);
    }
}

