/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.app.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.csinterface.app.IORMRPCEIPLicenseService;
import com.kingdee.eas.csinterface.app.ORMRPCEIPServiceService;
import java.util.Map;

public class EIPORMServiceUtil {
    public static final String LICENSE_SERVER_LOCATION = "license";
    public static final String EIPLICENSEOBJECT = "EIPLICENSEOBJECT";

    public static void canAddLicenseOnceMore(Context ctx) throws BOSException {
        try {
            EIPORMServiceUtil.getORMRPCBosObject()._canAddLicenseOnceMore(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkLicenseEnough(Context ctx) throws BOSException {
        try {
            EIPORMServiceUtil.getORMRPCBosObject()._checkLicenseEnough(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void addLicense(Context ctx) throws BOSException {
        try {
            EIPORMServiceUtil.getORMRPCBosObject()._addLicense(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void releaseLicense(Context ctx) throws BOSException {
        try {
            EIPORMServiceUtil.getORMRPCBosObject()._releaseLicense(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, String> getLicense(Context ctx) throws BOSException {
        try {
            return EIPORMServiceUtil.getORMRPCBosObject()._getLicenseDetail(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getORMRPCServerURL() throws BOSException {
        ORMServiceLocation loc = new ORMServiceLocation(LICENSE_SERVER_LOCATION);
        try {
            return loc.getServiceURL();
        }
        catch (Exception err) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!", (Throwable)err);
        }
    }

    private static IORMRPCEIPLicenseService getORMRPCBosObject() throws BOSException {
        String url = EIPORMServiceUtil.getORMRPCServerURL();
        ORMRPCEIPServiceService bosObject = null;
        bosObject = url == null || url.trim().equals("") || url.equalsIgnoreCase("tcp://127.0.0.1") ? new ORMRPCEIPServiceService() : RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.csinterface.app.ORMRPCEIPServiceService", IORMRPCEIPLicenseService.class);
        return bosObject;
    }

    public static String getLicenseInfo(Context ctx, boolean isRefresh) throws BOSException {
        String licenseInfo = "";
        try {
            licenseInfo = EIPORMServiceUtil.getORMRPCBosObject().getLicenseInfo(ctx, isRefresh);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return licenseInfo;
    }
}

