/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.task;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.async.AsyncTaskFactory;
import com.kingdee.eas.csinterface.async.AsyncTaskInfo;
import com.kingdee.eas.csinterface.async.AsyncTaskStatus;
import com.kingdee.eas.csinterface.async.AsyncTaskTreeCollection;
import com.kingdee.eas.csinterface.async.AsyncTaskTreeFactory;
import com.kingdee.eas.csinterface.async.AsyncTaskTreeInfo;
import com.kingdee.eas.csinterface.async.SourceSystem;
import com.kingdee.eas.csinterface.async.app.task.AsyncBgTaskImpl;
import com.kingdee.eas.csinterface.async.app.task.AsyncTaskExecute;
import com.kingdee.eas.csinterface.async.app.task.model.ResultInfo;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleFacade;
import com.kingdee.eas.csinterface.util.AES;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class AsyncOrderTaskUtil
extends AsyncTaskExecute {
    private static Logger logger = Logger.getLogger(AsyncOrderTaskUtil.class);
    private static boolean hasLoaded = false;
    public static final String TASKID = "taskId";
    public static final String DATA = "data";
    public static final String ASYNTYPE = "asynType";
    public static final String RETRYCOUNT = "retryCount";
    public static final String CHECKSQL = "checkSQL";
    private static ThreadLocal<AsyncTaskInfo> task = new ThreadLocal();

    public static AsyncTaskInfo getCurrentTask() {
        return task.get();
    }

    public static void setCurrentTask(AsyncTaskInfo taskInfo) {
        task.set(taskInfo);
    }

    public static void orderTask(Context ctx, String aysncType, String data, String checkSQL, String description) throws BOSException {
        String taskId = AsyncOrderTaskUtil.saveAsyncTask(ctx, aysncType, data, checkSQL, description);
        JSONObject jsonData = JSONObject.parseObject((String)data);
        jsonData.put(TASKID, (Object)taskId);
        AsyncOrderTaskUtil.orderSmallTask(ctx, aysncType, jsonData.toJSONString(), taskId, 0, checkSQL);
    }

    public static ResultInfo execute(Context ctx, Job job, String jobData) throws BOSException {
        ResultInfo result = null;
        JSONObject dataObj = JSONObject.parseObject((String)jobData);
        String taskId = dataObj.getString(TASKID);
        String data = dataObj.getString(DATA);
        String aysncType = dataObj.getString(ASYNTYPE);
        Integer retryCount = dataObj.getInteger(RETRYCOUNT);
        String checkSQL = dataObj.getString(CHECKSQL);
        boolean hasCommited = AsyncOrderTaskUtil.hasCommited(ctx, taskId, checkSQL);
        if (!hasCommited) {
            Boolean isDestroy = AsyncOrderTaskUtil.isDestroy(retryCount);
            if (!isDestroy.booleanValue()) {
                Integer n = retryCount;
                Integer n2 = retryCount = Integer.valueOf(retryCount + 1);
                AsyncOrderTaskUtil.orderSmallTask(ctx, aysncType, data, taskId, n, checkSQL);
            }
            result = new ResultInfo(false, false, "retry task, retryCount=" + retryCount, null, null);
        } else {
            AsyncTaskExecute.execute(ctx, job, taskId, data, aysncType, result);
        }
        return result;
    }

    private static boolean hasCommited(Context ctx, String taskId, String checkSQL) throws BOSException {
        Boolean isExists = false;
        try {
            IRowSet rowSet;
            isExists = StringUtils.isEmpty((String)checkSQL) ? Boolean.valueOf(AsyncTaskFactory.getLocalInstance(ctx).exists(CommonUtil.convert2PK(taskId))) : Boolean.valueOf((rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSQL)).size() != 0);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return isExists;
    }

    private static String saveAsyncTask(Context ctx, String aysncType, String data, String checkSQL, String description) throws BOSException {
        if (!hasLoaded) {
            AsyncOrderTaskUtil.getAllAsynConfig(ctx);
        }
        AsyncTaskTreeInfo treeInfo = (AsyncTaskTreeInfo)asyncClassMap.get(aysncType);
        AsyncTaskInfo taskInfo = new AsyncTaskInfo();
        JSONObject saveData = new JSONObject();
        saveData.put(DATA, (Object)data);
        saveData.put(CHECKSQL, (Object)checkSQL);
        saveData.put(ASYNTYPE, (Object)aysncType);
        taskInfo.setData(saveData.toJSONString());
        taskInfo.setDescription(description);
        taskInfo.setTreeid(treeInfo);
        String ctxStr = ctx.getUserName() + "_" + ctx.getAIS() + "_" + ctx.getContextID();
        String encryptData = null;
        try {
            encryptData = AES.encryptToString(ctxStr, "EIP");
        }
        catch (Exception exception) {
            // empty catch block
        }
        taskInfo.setContext(encryptData);
        taskInfo.setSystem(SourceSystem.local);
        taskInfo.setStatus(AsyncTaskStatus.waitting);
        taskInfo.setUser(ctx.getUserName());
        try {
            AsyncTaskFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)taskInfo);
            AsyncOrderTaskUtil.setCurrentTask(taskInfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return taskInfo.getId().toString();
    }

    private static void orderSmallTask(Context ctx, String aysncType, String data, String taskId, int retryCount, String checkSQL) throws BOSException {
        BPOption bpOption = new BPOption();
        bpOption.setPersistent(false);
        bpOption.setImmediately(false);
        try {
            bpOption.setDataCenter(ctx.getAIS());
            JSONObject taskData = new JSONObject();
            taskData.put(TASKID, (Object)taskId);
            taskData.put(DATA, (Object)data);
            taskData.put(ASYNTYPE, (Object)aysncType);
            taskData.put(RETRYCOUNT, (Object)retryCount);
            taskData.put(CHECKSQL, (Object)checkSQL);
            AsyncBgTaskImpl handler = new AsyncBgTaskImpl(taskData);
            JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)handler, true, true, 0, AsyncOrderTaskUtil.getMutex(aysncType, data), null, Configuration.defaultJobIsolationLevel());
            Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + 100L);
            String instanceName = Configuration.instanceId();
            Job job1 = new Job(ctx, "EIP\u5f02\u6b65\u4efb\u52a1\u6c60_" + instanceName, cfg, null, scheduledTime);
            String isolation = ScheduleFacade.getIsolation("EIP", ctx);
            if (isolation != null) {
                job1.setIsolationBoundary(isolation);
            }
            JobServiceFactory.getLocalInstance((Context)ctx).createJobInstance(job1);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean isDestroy(int retryCount) {
        boolean isDestroy = false;
        try {
            if (retryCount > -1 && retryCount < 8) {
                Thread.sleep(2000L);
            } else if (retryCount > 7 && retryCount < 15) {
                Thread.sleep(5000L);
            } else if (retryCount > 14 && retryCount < 21) {
                Thread.sleep(8000L);
            } else {
                isDestroy = true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return isDestroy;
    }

    private static String getMutex(String asyncType, String data) {
        return asyncType + "_" + data.hashCode();
    }

    public static synchronized void getAllAsynConfig(Context ctx) throws BOSException {
        if (hasLoaded) {
            return;
        }
        asyncClassMap = new ConcurrentHashMap();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sels = new SelectorItemCollection();
        sels.add(new SelectorItemInfo("id"));
        sels.add(new SelectorItemInfo("number"));
        sels.add(new SelectorItemInfo("implClass"));
        view.setSelector(sels);
        AsyncTaskTreeCollection coll = AsyncTaskTreeFactory.getLocalInstance(ctx).getAsyncTaskTreeCollection(view);
        Iterator ite = coll.iterator();
        AsyncTaskTreeInfo treeInfo = null;
        Object className = null;
        while (ite.hasNext()) {
            treeInfo = (AsyncTaskTreeInfo)ite.next();
            asyncClassMap.put(treeInfo.getNumber(), treeInfo);
        }
        hasLoaded = true;
    }
}

