/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.task.mq;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.rabbitmq.consumer.ack.MessageAcker;
import com.kingdee.bos.rabbitmq.consumer.subscribe.MessageConsumer;
import com.kingdee.eas.csinterface.async.AsyncTaskFactory;
import com.kingdee.eas.csinterface.async.AsyncTaskInfo;
import com.kingdee.eas.csinterface.async.AsyncTaskStatus;
import com.kingdee.eas.csinterface.async.IAsyncTask;
import com.kingdee.eas.csinterface.async.app.mq.EASMQExtends;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class MQCallBackConsumer
extends MessageConsumer {
    private Context ctx = null;
    private static final Logger logger = Logger.getLogger(MQCallBackConsumer.class);

    public void initContext(JSONObject extend, String messageId, boolean resend, MessageAcker ack) {
        try {
            EASMQExtends.execute(extend);
        }
        catch (Exception e) {
            logger.error((Object)("\u767b\u5f55\u4fe1\u606f\u5f02\u5e38,\u767b\u5f55\u4fe1\u606f\uff1a" + extend), (Throwable)e);
            ack.ack(messageId, null);
        }
    }

    public void onMessage(String body, String messageId, boolean resend, MessageAcker acker) {
        String taskId = null;
        try {
            this.ctx = SessionUtil.getContext();
            JSONObject resultObj = JSONObject.parseObject((String)body);
            taskId = resultObj.getString("taskId");
            Boolean isSuccess = resultObj.getBoolean("success");
            String trace = resultObj.getString("trace");
            String message = resultObj.getString("message");
            IAsyncTask instance = AsyncTaskFactory.getLocalInstance(this.ctx);
            AsyncTaskInfo taskInfo = null;
            try {
                taskInfo = instance.getAsyncTaskInfo(CommonUtil.convert2PK(taskId));
            }
            catch (Exception e) {
                logger.error((Object)("taskId:" + taskId + ".message:" + ThrowableHelper.toString(e)));
                acker.ack(messageId, null);
                return;
            }
            taskInfo.setStatus(isSuccess != false ? AsyncTaskStatus.success : AsyncTaskStatus.fail);
            taskInfo.setMessage(message);
            if (trace != null) {
                taskInfo.setTrace(trace);
            }
            instance.save((CoreBaseInfo)taskInfo);
            acker.ack(messageId, null);
        }
        catch (Throwable e) {
            logger.error((Object)("taskId:" + taskId + ".message:" + ThrowableHelper.toString(e) + ".data:" + body));
            acker.ack(messageId, null);
        }
    }
}

