/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.task.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherInfo;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationCollection;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationFactory;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SaveDataRelationUtil {
    public static OpenDataRelationCollection getDataRelations(Context ctx, Set<String> otherIds) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", otherIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("destBillId", otherIds, CompareType.INCLUDE));
        filter.setMaskString("#0 or #1");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("sourceBillId"));
        selectors.add(new SelectorItemInfo("dynaBillId"));
        selectors.add(new SelectorItemInfo("destBillId"));
        view.setSelector(selectors);
        OpenDataRelationCollection relations = OpenDataRelationFactory.getLocalInstance(ctx).getOpenDataRelationCollection(view);
        return relations;
    }

    public static List<String> getEASIDByOtherId(Context ctx, Set<String> otherIds) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", otherIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("destBillId", otherIds, CompareType.INCLUDE));
        filter.setMaskString("#0 or #1");
        OpenDataRelationCollection relations = OpenDataRelationFactory.getLocalInstance(ctx).getOpenDataRelationCollection(view);
        Iterator ite = relations.iterator();
        while (ite.hasNext()) {
            OpenDataRelationInfo relation = (OpenDataRelationInfo)ite.next();
            String srcId = relation.getSourceBillId();
            String destId = relation.getDestBillId();
            if (otherIds.contains(srcId)) {
                idList.add(destId);
                continue;
            }
            if (!otherIds.contains(srcId)) continue;
            idList.add(srcId);
        }
        return idList;
    }

    public static void save(Context ctx, Object botResult, Map<String, String> srcId2MidIdMap, String sourceEntity, String dynaBillEntity, String destEntity, OpenAPIDispatcherInfo openAPIDispatcher) throws Exception {
        CoreBaseCollection relatioColl = new CoreBaseCollection();
        BOTRelationCollection relations = null;
        relations = botResult instanceof BTPTransformResult ? ((BTPTransformResult)botResult).getBOTRelationCollection() : ((DAPTransformResult)botResult).getRelationCollection();
        Iterator ite = relations.iterator();
        BOTRelationInfo relation = null;
        while (ite.hasNext()) {
            relation = (BOTRelationInfo)ite.next();
            String srcObjId = relation.getSrcObjectID();
            String destObjId = relation.getDestObjectID();
            String descEntityId = relation.getDestEntityID();
            BOTRelationEntryCollection entryColl = relation.getRelationEntries();
            if (entryColl != null && entryColl.size() > 0) {
                Iterator entryIte = entryColl.iterator();
                BOTRelationEntryInfo entryRel = null;
                while (entryIte.hasNext()) {
                    entryRel = (BOTRelationEntryInfo)entryIte.next();
                    String srcEntryId = entryRel.getSrcEntryID();
                    String destEntryId = entryRel.getDestObjectID();
                    OpenDataRelationInfo dataRelation = new OpenDataRelationInfo();
                    dataRelation.setOpenService(openAPIDispatcher);
                    dataRelation.setSourceBillId(srcId2MidIdMap.get(srcObjId));
                    dataRelation.setSourceBillEntryId(srcId2MidIdMap.get(srcEntryId));
                    dataRelation.setSourceEntityId(sourceEntity);
                    dataRelation.setDynaBillId(srcObjId);
                    dataRelation.setDynaBillEntryId(srcEntryId);
                    dataRelation.setDynaBillType(dynaBillEntity);
                    dataRelation.setDestBillId(destObjId);
                    dataRelation.setDestBillEntryId(destEntryId);
                    dataRelation.setDestEntityId(descEntityId);
                    relatioColl.add((CoreBaseInfo)dataRelation);
                }
                continue;
            }
            OpenDataRelationInfo dataRelation = new OpenDataRelationInfo();
            dataRelation.setOpenService(openAPIDispatcher);
            dataRelation.setSourceBillId(srcId2MidIdMap.get(srcObjId));
            dataRelation.setSourceEntityId(sourceEntity);
            dataRelation.setDynaBillId(srcObjId);
            dataRelation.setDynaBillType(dynaBillEntity);
            dataRelation.setDestBillId(destObjId);
            dataRelation.setDestEntityId(destEntity);
            relatioColl.add((CoreBaseInfo)dataRelation);
        }
        OpenDataRelationFactory.getLocalInstance(ctx).saveBatchData(relatioColl);
    }

    private static void dealBotp() {
    }

    private static void dealDap() {
    }
}

