/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.standardImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.csinterface.async.app.task.handler.IApiUserHandler;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserImplDispatcherService {
    private static final Logger logger = Logger.getLogger(UserImplDispatcherService.class);
    private static List<String> processorPkgs = new ArrayList<String>();
    private static Map<String, IApiUserHandler> processors;

    private static synchronized void initProcessors() {
        if (processors != null) {
            return;
        }
        processors = new HashMap<String, IApiUserHandler>();
        for (String pkg : processorPkgs) {
            List<Object> classList = new ArrayList();
            try {
                classList = ClassUtil.findPackageClasses(pkg);
            }
            catch (IOException e) {
                logger.warn((Object)"\u52a0\u8f7d\u6240\u6709\u7684\u7528\u6237\u5b9e\u4e60\u7c7b\u5931\u8d25", (Throwable)e);
            }
            for (Class clazz : classList) {
                if (!IApiUserHandler.class.isAssignableFrom(clazz)) continue;
                IApiUserHandler rp = (IApiUserHandler)ClassUtil.getNewInstance(clazz);
                if (rp == null) {
                    logger.warn((Object)(clazz.getName() + " newInstance fail!"));
                    continue;
                }
                processors.put(rp.getBosType(), rp);
            }
        }
    }

    public static IApiUserHandler getClass(String bosType, String className) throws BOSException {
        IApiUserHandler userClass = null;
        try {
            if (!StringUtils.isEmpty((String)className)) {
                Class<?> clazz = Class.forName(className);
                userClass = (IApiUserHandler)ClassUtil.getNewInstance(clazz);
            } else {
                userClass = UserImplDispatcherService.getUserClass(bosType.toString());
            }
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5904\u7406\u7c7b\u6216\u5c06\u975e\u5408\u6cd5\u7684\u5904\u7406\u7c7b\uff1a" + className);
        }
        return userClass;
    }

    public static IApiUserHandler getUserClass(String bosType) {
        UserImplDispatcherService.initProcessors();
        return processors.get(bosType);
    }

    static {
        processorPkgs.add("com.kingdee.eas.csinterface.async.standardImpl.impl");
    }
}

