/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;

public class BOSEntityUtil {
    public static Class getFactoryByBosType(Context ctx, String bosTypeStr) throws BOSException {
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeStr);
        EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bosType);
        String factoryName = eoi.getBusinessImplName() + "Factory";
        int splitIndex = eoi.getBusinessImplName().lastIndexOf(".") + 1;
        String objName = eoi.getBusinessImplName().substring(splitIndex);
        Class<?> entityFactory = null;
        try {
            entityFactory = Thread.currentThread().getContextClassLoader().loadClass(factoryName);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("\u627e\u4e0d\u5230" + bosTypeStr + "\u5bf9\u5e94\u7684\u5de5\u5382\u7c7b");
        }
        return entityFactory;
    }

    public static Object getLocalInstance(Context ctx, String bosTypeStr) throws BOSException {
        Class factory = BOSEntityUtil.getFactoryByBosType(ctx, bosTypeStr);
        Object entityMethodObj = null;
        try {
            Method method = factory.getMethod("getLocalInstance", Context.class);
            entityMethodObj = method.invoke((Object)factory, ctx);
        }
        catch (Exception e) {
            throw new BOSException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5de5\u5382\u5904\u7406\u7c7b\uff1a" + bosTypeStr);
        }
        return entityMethodObj;
    }

    public static void reSaveBill(Context ctx, ICoreBase instance, Object botResult, String action) throws BOSException {
        if (!"save".equalsIgnoreCase(action) && !"submit".equalsIgnoreCase(action)) {
            return;
        }
        BOTRelationCollection relations = null;
        CoreBaseCollection colls = null;
        relations = botResult instanceof BTPTransformResult ? ((BTPTransformResult)botResult).getBOTRelationCollection() : ((DAPTransformResult)botResult).getRelationCollection();
        Iterator ite = relations.iterator();
        Object relation = null;
        HashSet<String> idSet = new HashSet<String>(relations.size());
        while (ite.hasNext()) {
            idSet.add(((BOTRelationInfo)ite.next()).getDestObjectID());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        try {
            if ("save".equalsIgnoreCase(action)) {
                colls = instance.getCollection(view);
                instance.saveBatchData(colls);
            } else if ("submit".equalsIgnoreCase(action)) {
                instance.submit(instance.getCollection(view));
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

