/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.base.cache.session.impl;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.csinterface.agent.service.base.util.AES;
import com.kingdee.eas.csinterface.agent.service.base.util.MD5;
import com.kingdee.eas.csinterface.base.cache.session.IORMRPCSessionCache;
import com.kingdee.eas.csinterface.webservice.app.constant.WSConstant;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ORMRPCSessionCache
implements IORMRPCSessionCache {
    private static final Logger logger = Logger.getLogger(ORMRPCSessionCache.class);
    private static Map<String, String> cache = new HashMap<String, String>();
    public static ThreadLocal<Context> currentContext = new ThreadLocal();

    public static Context getContext() {
        return currentContext.get();
    }

    public static void setContext(Context ctx) {
        currentContext.set(ctx);
    }

    @Override
    public String _getTokenId(String user, String password, String dataCenter, String language, String solution, String userAuthPattern) throws BOSException {
        String sessionId = this.innerLogin(user, password, dataCenter, language, solution, userAuthPattern);
        return ORMRPCSessionCache.getToken(sessionId);
    }

    @Override
    public Context _getContextBySession(String sessionId) throws BOSException {
        Context context = null;
        Object newCtx = null;
        SessionInfo sessionInfo = SessionManager.getInstance().getSession(sessionId);
        if (sessionInfo == null || sessionInfo.getContext() == null) {
            return null;
        }
        context = sessionInfo.getContext();
        context.setClientHostIP("127.0.0.1");
        return context;
    }

    @Override
    public Context _getContextByToken(String tokenId) throws BOSException {
        String sessionId = ORMRPCSessionCache.getSessionId(tokenId);
        return this._getContextBySession(sessionId);
    }

    @Override
    public Context _login(String user, String password, String dataCenter, String language, String solution, String userAuthPattern) throws BOSException {
        String sessionId = this.innerLogin(user, password, dataCenter, language, solution, userAuthPattern);
        return this._getContextBySession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String innerLogin(String user, String password, String dataCenter, String language, String solution, String userAuthPattern) throws BOSException {
        String user_key;
        String sessionId = null;
        if (StringUtils.isEmpty((String)solution)) {
            solution = "eas";
        }
        if (StringUtils.isEmpty((String)(sessionId = cache.get(user_key = ORMRPCSessionCache.getUserkey(user, password, dataCenter, language, solution))))) {
            String string = user_key;
            synchronized (string) {
                sessionId = this.relogin(user, password, dataCenter, language, solution, userAuthPattern);
            }
        }
        SessionInfo sessionInfo = SessionManager.getInstance().getSession(sessionId);
        if (sessionInfo == null || sessionInfo.getContext() == null) {
            String string = user_key;
            synchronized (string) {
                sessionId = this.relogin(user, password, dataCenter, language, solution, userAuthPattern);
            }
        }
        return sessionId;
    }

    private String relogin(String user, String password, String dataCenter, String language, String solution, String userAuthPattern) throws BOSException {
        SessionInfo sessionInfo;
        String user_key = null;
        user_key = userAuthPattern != null ? ORMRPCSessionCache.getUserkey(user, userAuthPattern, dataCenter, language, solution) : ORMRPCSessionCache.getUserkey(user, password, dataCenter, language, solution);
        String sessionId = cache.get(user_key);
        String loginUrl = ORMRPConfig.getRPCListeningURL((boolean)false);
        if (!StringUtils.isEmpty((String)sessionId) && (sessionInfo = SessionManager.getInstance().getSession(sessionId)) != null && sessionInfo.getContext() != null) {
            return sessionId;
        }
        try {
            ILoginModule loginModule = LoginModuleFactory.getLocalInstance(null);
            String encodePwd = this.encodePassword(user, password);
            Locale locale = new Locale(language);
            LoginContext ctx = new LoginContext(user, encodePwd, solution, dataCenter, locale);
            ctx.setLoginType(LoginType.WEBSERVICE);
            ctx.put("SwitchToNewLoginFlow", (Object)"true");
            if (userAuthPattern == null) {
                userAuthPattern = "BaseDB";
            }
            ctx.put("UserAuthPattern", (Object)userAuthPattern);
            try {
                Context cttc = loginModule.fullLogin(ctx);
                sessionId = cttc.getContextID();
            }
            catch (RPCConnectException rpce) {
                logger.error((Object)rpce);
                RemoteBOSObjectFactory.getInstance((String)loginUrl).clearSession();
                sessionId = loginModule.login(ctx);
            }
            cache.put(user_key, sessionId);
        }
        catch (Exception e) {
            JSONObject obj = new JSONObject();
            obj.put("user", (Object)user);
            obj.put("password", (Object)password);
            obj.put("dataCenter", (Object)dataCenter);
            obj.put("solution", (Object)solution);
            logger.error((Object)"web api login error.", (Throwable)e);
            logger.error((Object)obj.toJSONString());
            throw new BOSException((Throwable)e);
        }
        return sessionId;
    }

    private String encodePassword(String userName, String password) throws BOSException {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            logger.error((Object)e);
        }
        if (StringUtils.isEmpty((String)encodedPassword)) {
            throw new BOSException("\u52a0\u5bc6\u5bc6\u7801\u5931\u8d25\uff01\u5bc6\u7801\u4e0d\u80fd\u8bbe\u5b9a\u4e3a\u7a7a\u5b57\u7b26\u4e32\u3002");
        }
        return encodedPassword;
    }

    private static String getToken(String sessionId) {
        String token = null;
        try {
            token = AES.encryptToString(sessionId, WSConstant.getEntryKey(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return token;
    }

    private static String getSessionId(String token) {
        if (!StringUtils.isEmpty((String)token)) {
            try {
                return AES.decryptToString(token, WSConstant.getEntryKey(null));
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    private static String getUserkey(String user, String password, String dataCenter, String language, String solution) {
        String user_key = "";
        try {
            user_key = MD5.code(user + password + dataCenter + language + solution);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user_key;
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }
}

