/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.FlatDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataSynSender;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.AbstractBaseDataSynExecuteFacadeControllerBean;
import com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice.BaseDataSynFacadeByWSService;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataDownExecutor;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleFacade;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseDataSynExecuteFacadeControllerBean
extends AbstractBaseDataSynExecuteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.basedatasyn.app.BaseDataSynExecuteFacadeControllerBean");
    public static final String STATUS_SUCCESS = "success";
    public static final String STATUS_FAILURE = "failure";
    public static final String STATUS_EXIST = "exist";

    @Override
    protected String _AssignSaveDataTaskToAgent(Context ctx, EipUserInfo eipUser, String synNumber, String[] synTables) throws BOSException, EASBizException {
        if (synNumber == null) {
            return "\u540c\u6b65\u7f16\u7801\u4e3a\u7a7a";
        }
        if (synTables == null) {
            return "\u540c\u6b65\u8868\u4e3a\u7a7a";
        }
        EipTaskManager.orderBaseDataSynTaskToAgent(ctx, eipUser, synTables, synNumber);
        return null;
    }

    @Override
    protected String _orderOnceTaskToAgent(Context ctx, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        String msg = EipTaskManager.orderOnceTaskToAgent(ctx, headInfo);
        return msg;
    }

    @Override
    protected String _orderOnceTaskToDB(Context ctx, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        String result = null;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("headInfoId", headInfo.getId().toString());
        param.putAll(headInfo.getExtendedProperties());
        boolean flag = ScheduleFacade.triggerProcessBaseDataTask(ctx, param);
        if (!flag) {
            result = "\u6570\u636e\u63d0\u4ea4\u540e\u53f0\u5931\u8d25\uff01";
        }
        return result;
    }

    @Override
    protected String _orderOnceTask(Context ctx, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        try {
            EIPLicenseCheckUtil.checkLicenseEnough(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        IObjectPK pk = CommonUtil.convert2PK(headInfo.getId().toString());
        BaseDataSynHeadFactory.getLocalInstance(ctx).update(pk, headInfo);
        String extConnId = headInfo.getExtendedProperty("extConnId");
        String extAgentId = headInfo.getExtendedProperty("extAgentId");
        String extWsserviceId = headInfo.getExtendedProperty("extWsserviceId");
        String extWebServiceId = headInfo.getExtendedProperty("extWebServiceId");
        if (extAgentId != null) {
            return this._orderOnceTaskToAgent(ctx, headInfo);
        }
        if (extConnId != null || extWsserviceId != null || extWebServiceId != null) {
            return this._orderOnceTaskToDB(ctx, headInfo);
        }
        return "\u4e0d\u6b63\u786e\u7684\u76ee\u6807\u6570\u636e\u7c7b\u578b\uff01";
    }

    public static final int getNumberCount(String obj) {
        int count = 0;
        if (StringUtils.isEmpty((String)obj)) {
            return count;
        }
        try {
            count = obj.split(",").length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    protected void _execPlanNoSyn(Context ctx, BaseDataSynHeadInfo headInfo, String mainSQL, String mainPKList, String execType) throws BOSException, EASBizException {
        try {
            List<String> pkList;
            String number = headInfo.getNumber();
            BaseDataDownExecutor executor = new BaseDataDownExecutor(ctx);
            if (StringUtils.equals((String)"add", (String)execType)) {
                List<String> pkList2 = BaseDataSynUtil.getMainPKListForAdd(ctx, number, mainSQL, true);
                if (pkList2.size() > 0) {
                    executor.execBaseDataDown(headInfo, pkList2);
                }
            } else if (StringUtils.equals((String)"update", (String)execType) && (pkList = BaseDataSynUtil.getMainPKListForUpdate(ctx, number, mainSQL, true)).size() > 0) {
                executor.execBaseDataUpdate(headInfo, pkList);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _execPlanPatch(Context ctx, String connectionId, List mainPKList, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo, String monitorLogId, String oprtTye) throws BOSException, EASBizException {
        boolean isServiceSyn;
        BaseDataDownMonitorLogInfo baseDataDownMonitorLogInfo = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
        baseDataDownMonitorLogInfo.getRecordBaseDataLog().recordTableInfo(tableInfo, oprtTye);
        String agent4http = ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getExtendedProperty("agentId4http");
        boolean bl = isServiceSyn = !StringUtils.isEmpty((String)agent4http);
        if (isServiceSyn) {
            this.execPlanPatchWSService(ctx, agent4http, mainPKList, headInfo, tableInfo, monitorLogId, oprtTye);
        } else {
            this.execPlanPatchJDBC(ctx, connectionId, mainPKList, headInfo, tableInfo, monitorLogId, oprtTye);
        }
    }

    private void execPlanPatchWSService(Context ctx, String agent4http, List mainPKList, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo, String monitorLogId, String oprtTye) throws BOSException, EASBizException {
        BaseDataDownMonitorLogInfo baseDataDownMonitorLogInfo = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
        baseDataDownMonitorLogInfo.getRecordBaseDataLog().recordTableInfo(tableInfo, oprtTye);
        if ("add".equals(oprtTye)) {
            BaseDataSynFacadeByWSService.porcessAdd(ctx, agent4http, mainPKList, headInfo, tableInfo, monitorLogId);
        } else if ("update".equals(oprtTye)) {
            BaseDataSynFacadeByWSService.porcessUpdate(ctx, agent4http, mainPKList, headInfo, tableInfo, monitorLogId);
        } else if ("delete".equals(oprtTye)) {
            BaseDataSynFacadeByWSService.processDelete(ctx, agent4http, mainPKList, headInfo, tableInfo, monitorLogId);
        }
    }

    private void execPlanPatchJDBC(Context ctx, String connectionId, List mainPKList, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo, String monitorLogId, String oprtTye) throws BOSException, EASBizException {
        BaseDataDownMonitorLogInfo baseDataDownMonitorLogInfo = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
        baseDataDownMonitorLogInfo.getRecordBaseDataLog().recordTableInfo(tableInfo, oprtTye);
        if ("add".equals(oprtTye)) {
            this._porcessAdd(ctx, connectionId, mainPKList, headInfo, tableInfo, monitorLogId);
        } else if ("update".equals(oprtTye)) {
            this._porcessUpdate(ctx, connectionId, mainPKList, headInfo, tableInfo, monitorLogId);
        } else if ("delete".equals(oprtTye)) {
            this._porcessDelete(ctx, connectionId, mainPKList, headInfo, tableInfo, monitorLogId);
        }
    }

    protected void _porcessAdd(Context ctx, String connectionId, List mainPKList, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo, String monitorLogId) throws BOSException, EASBizException {
        StringBuffer mainPKBuffer = new StringBuffer();
        int total = mainPKList.size();
        for (int i = 0; i < total; ++i) {
            mainPKBuffer.append("'" + mainPKList.get(i) + "',");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        BaseDataRunner baseDataRunner = null;
        try {
            boolean hasNext = true;
            Integer pageSize = 5000;
            while (hasNext) {
                baseDataRunner = tableInfo.isMainTable() ? new BaseDataRunner(tableInfo, ctx, 0, (int)pageSize, true, mainPKBuffer.toString(), tableInfo.getSrcWhere(), tableInfo.getRelateSQL(), true, "", connectionId) : new BaseDataRunner(tableInfo, ctx, 0, (int)pageSize, true, mainPKBuffer.toString(), tableInfo.getSrcWhere(), tableInfo.getRelateSQL(), false, "", connectionId);
                baseDataRunner.startRunBaseJDBCAdd();
                boolean bl = hasNext = baseDataRunner.bufferDataProvider.getSendDataRows().size() != 0;
                if (!hasNext) {
                    return;
                }
                BaseDataSynSender dataSender = null;
                dataSender = new BaseDataSynSender(baseDataRunner, resultMap, connectionId);
                dataSender.sendJDBC();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (baseDataRunner != null) {
                baseDataRunner.clear();
            }
        }
    }

    protected void _porcessUpdate(Context ctx, String connectionId, List mainPKList, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo, String monitorLogId) throws BOSException, EASBizException {
        FlatDataModel flatDataModel = new FlatDataModel();
        flatDataModel.setMainUpdateIds(mainPKList);
        StringBuffer mainPKBuffer = new StringBuffer();
        int total = mainPKList.size();
        for (int i = 0; i < total; ++i) {
            if (i > 0) {
                mainPKBuffer.append(",");
            }
            mainPKBuffer.append("'" + mainPKList.get(i) + "'");
        }
        Object logInfo = null;
        Map<Object, Object> resultMap = new HashMap();
        String planNumber = headInfo.getNumber();
        BaseDataRunner baseDataRunner = null;
        try {
            String connId = MonitorManager.getCurrent().getExtendedProperty("connId");
            ConnectionInfo connection = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connId));
            String specialSQL = tableInfo.getSrcWhere();
            baseDataRunner = tableInfo.isMainTable() ? new BaseDataRunner(tableInfo, ctx, 1, Integer.MAX_VALUE, true, mainPKBuffer.toString(), specialSQL, tableInfo.getRelateSQL(), true, connId, flatDataModel) : new BaseDataRunner(tableInfo, ctx, 1, Integer.MAX_VALUE, true, mainPKBuffer.toString(), specialSQL, tableInfo.getRelateSQL(), true, connId, flatDataModel);
            baseDataRunner.startRunBaseJDBCUpdate();
            resultMap = baseDataRunner.getResultMap();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (baseDataRunner != null) {
                baseDataRunner.clear();
            }
        }
    }

    protected void _porcessDelete(Context ctx, String connectionId, List mainPKList, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo, String monitorLogId) throws BOSException, EASBizException {
        StringBuffer mainPKBuffer = new StringBuffer();
        int total = mainPKList.size();
        for (int i = 0; i < total; ++i) {
            mainPKBuffer.append("'" + mainPKList.get(i) + "',");
        }
        SubMonitorLogInfo logInfo = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String planNumber = headInfo.getNumber();
        BaseDataRunner baseDataRunner = null;
        try {
            baseDataRunner = tableInfo.isMainTable() ? new BaseDataRunner(tableInfo, ctx, 0, Integer.MAX_VALUE, true, mainPKBuffer.toString(), tableInfo.getSrcWhere(), tableInfo.getRelateSQL(), true, "", connectionId) : new BaseDataRunner(tableInfo, ctx, 0, Integer.MAX_VALUE, true, mainPKBuffer.toString(), tableInfo.getSrcWhere(), tableInfo.getRelateSQL(), false, "", connectionId);
            baseDataRunner.startRunBaseJDBCAdd();
            BaseDataSynSender dataSender = null;
            dataSender = new BaseDataSynSender(baseDataRunner, resultMap, connectionId);
            dataSender.sendJDBC();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (baseDataRunner != null) {
                baseDataRunner.clear();
            }
            logInfo = new SubMonitorLogInfo();
            try {
                String successNumber = String.valueOf(resultMap.get(STATUS_SUCCESS));
                String failureNumber = String.valueOf(resultMap.get(STATUS_FAILURE));
                String existNumber = String.valueOf(resultMap.get(STATUS_EXIST));
                int successCount = BaseDataSynExecuteFacadeControllerBean.getNumberCount(successNumber);
                int failureCount = BaseDataSynExecuteFacadeControllerBean.getNumberCount(failureNumber);
                int existCount = BaseDataSynExecuteFacadeControllerBean.getNumberCount(existNumber);
                logInfo.setCmd("add");
                logInfo.setSuccess(successNumber);
                logInfo.setFailure(failureNumber);
                logInfo.setTableName(tableInfo.getTableName());
                logInfo.setMonitorLogId(monitorLogId);
                logInfo.setSuccessCount(successCount);
                logInfo.setFailureCount(failureCount);
                logInfo.setExistCount(existCount);
                logInfo.setMainTable(tableInfo.isMainTable());
                logInfo.setPlanNumber(planNumber);
                SubMonitorLogFactory.getLocalInstance(ctx).addnew(logInfo);
            }
            catch (Exception e) {
                logger.error((Object)"EIP\u751f\u6210\u5b50\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void addSubMonitorLog(Context ctx, String type, SubMonitorLogInfo logInfo, boolean isMainTable, String tableName, String planNumber, String monitorLogId, Map<String, String> resultMap) throws Exception {
        String successNumber = String.valueOf(resultMap.get(STATUS_SUCCESS));
        String failureNumber = String.valueOf(resultMap.get(STATUS_FAILURE));
        String existNumber = String.valueOf(resultMap.get(STATUS_EXIST));
        int successCount = BaseDataSynExecuteFacadeControllerBean.getNumberCount(successNumber);
        int failureCount = BaseDataSynExecuteFacadeControllerBean.getNumberCount(failureNumber);
        int existCount = BaseDataSynExecuteFacadeControllerBean.getNumberCount(existNumber);
        logInfo.setCmd(type);
        logInfo.setSuccess(successNumber);
        logInfo.setFailure(failureNumber);
        logInfo.setTableName(tableName);
        logInfo.setMonitorLogId(monitorLogId);
        logInfo.setSuccessCount(successCount);
        logInfo.setFailureCount(failureCount);
        logInfo.setExistCount(existCount);
        logInfo.setMainTable(isMainTable);
        logInfo.setPlanNumber(planNumber);
        SubMonitorLogFactory.getLocalInstance(ctx).addnew(logInfo);
    }

    private void addSubMonitorLog(Context ctx, String type, SubMonitorLogInfo logInfo, boolean isMainTable, String tableName, String planNumber, String monitorLogId) throws Exception {
        logInfo.setCmd(type);
        logInfo.setTableName(tableName);
        logInfo.setMonitorLogId(monitorLogId);
        logInfo.setMainTable(isMainTable);
        logInfo.setPlanNumber(planNumber);
        SubMonitorLogFactory.getLocalInstance(ctx).addnew(logInfo);
    }

    @Override
    protected void _exexBaseDataDown(Context ctx, String scheduleId, String specialSQL, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        String number = headInfo.getNumber();
        boolean needInvalidLog = true;
        MonitorManager.setOperatorSource("EAS\u5ba2\u6237\u7aef");
        MonitorManager.enterBaseData(ctx, null, number, scheduleId, headInfo, "\u57fa\u7840\u8d44\u6599\u540c\u6b65");
        ArrayList<String> pkList = new ArrayList();
        try {
            pkList = BaseDataSynUtil.getMainPKList(ctx, number);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pkList.size() > 0) {
            BaseDataDownExecutor executor = new BaseDataDownExecutor(ctx);
            try {
                executor.execBaseDataDown(headInfo, pkList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String createTmpTable(Context ctx, List<String> mainPKList) throws BOSException {
        TableManager manager = null;
        String tableName = null;
        Connection conn = null;
        PreparedStatement state = null;
        try {
            conn = DBUtils.getConnection((Context)ctx);
            manager = TableManager.getTableManager((Context)ctx);
            tableName = manager.getTableName("EipBaseDataTmpTable");
            String createSql = "create table " + tableName + " (fid varchar(80))";
            manager.createTable(createSql);
            String insertTmpSql = "insert into " + tableName + " (fid) values(?)";
            state = conn.prepareStatement(insertTmpSql);
            int total = mainPKList.size();
            for (int i = 0; i < total; ++i) {
                state.setString(1, mainPKList.get(i));
                state.addBatch();
            }
            state.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                if (manager != null && tableName != null) {
                    manager.releaseTable(tableName);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
        if (manager != null && tableName != null) {
            manager.releaseTable(tableName);
        }
        return tableName;
    }

    protected String _execPlanForInterface(Context ctx, String planNumber, String specialSQL, String actionType, String connectionNumber, String agentNumber) throws BOSException, EASBizException {
        String result = null;
        return result;
    }
}

