/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynHead;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynTable;
import com.kingdee.eas.csinterface.basedatasyn.SynDirection;
import com.kingdee.eas.csinterface.basedatasyn.app.AbstractBaseDataSynPublisherFacadeControllerBean;
import com.kingdee.eas.csinterface.basedatasyn.app.util.KeyTableUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseDataSynPublisherFacadeControllerBean
extends AbstractBaseDataSynPublisherFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.basedatasyn.app.BaseDataSynPublisherFacadeControllerBean");
    private Map<String, String> pkTableMap = new HashMap<String, String>();

    @Override
    protected Object _publish(Context ctx, String id) throws BOSException, EASBizException {
        String name = "";
        try {
            if (StringUtils.isEmpty((String)id)) {
                Map<String, String> map = this.pkTableMap;
                return map;
            }
            IObjectPK pk = CommonUtil.convert2PK(id);
            IBaseDataSynHead instance = BaseDataSynHeadFactory.getLocalInstance(ctx);
            BaseDataSynHeadInfo info = instance.getBaseDataSynHeadInfo(pk);
            name = info.getName();
            this.createPKTable(ctx, instance, info);
            this.updateInfo2Published(instance, info);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            logger.info((Object)("EIP finished publishing the metadata{[" + id + "],[" + name + "]}"));
        }
        return this.pkTableMap;
    }

    private void updateInfo2Published(IBaseDataSynHead instance, BaseDataSynHeadInfo info) throws BOSException, EASBizException {
        info.setPublished(true);
        instance.save((CoreBaseInfo)info);
    }

    private void createPKTable(Context ctx, IBaseDataSynHead instance, BaseDataSynHeadInfo headInfo) throws EASBizException, BOSException, SQLException, DIPException {
        IBaseDataSynTable tbInstance = BaseDataSynTableFactory.getLocalInstance(ctx);
        BaseDataSynTableCollection tables = headInfo.getTableEntrys();
        if (SynDirection.ParentToBranch.equals((Object)headInfo.getDirection())) {
            Iterator itr = tables.iterator();
            while (itr.hasNext()) {
                BaseDataSynTableInfo tableInfo = (BaseDataSynTableInfo)itr.next();
                String pkTableName = BaseDataSynHelper.calc2PkTableName(tableInfo.getTableName());
                this.createKeyTableIfNotExist(ctx, tableInfo);
                tableInfo.setPkTableName(pkTableName);
                tbInstance.save((CoreBaseInfo)tableInfo);
                this.pkTableMap.put(tableInfo.getTableName(), pkTableName);
            }
        } else if (SynDirection.BranchToParent.equals((Object)headInfo.getDirection())) {
            Iterator itr = tables.iterator();
            while (itr.hasNext()) {
                BaseDataSynTableInfo tableInfo = (BaseDataSynTableInfo)itr.next();
                String pkTableName = BaseDataSynHelper.calc2PkTableName(tableInfo.getTableName());
                tableInfo.setPkTableName(pkTableName);
            }
        } else {
            throw new BOSException("unsupported Direction Type : " + (Object)((Object)headInfo.getDirection()));
        }
    }

    private void createKeyTableIfNotExist(Context ctx, BaseDataSynTableInfo tableInfo) throws BOSException {
        try {
            if (!KeyTableUtil.existKeyTable(ctx, tableInfo)) {
                KeyTableUtil.createKeyTable(ctx, tableInfo);
                KeyTableUtil.createStatusIndexIfNeed(ctx, tableInfo.getPkTableName());
            }
            if (!tableInfo.isMainTable()) {
                KeyTableUtil.createMainPKIndexIfNeed(ctx, tableInfo.getPkTableName());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _checkHasPublish(Context ctx, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        if (headInfo.getId() == null) {
            return null;
        }
        BaseDataSynTableCollection tables = headInfo.getTableEntrys();
        Iterator itr = tables.iterator();
        while (itr.hasNext()) {
            BaseDataSynTableInfo tableInfo = (BaseDataSynTableInfo)itr.next();
            String pkTableName = tableInfo.getPkTableName();
            if (!StringUtils.isEmpty((String)pkTableName) && !StringUtils.isEmpty((String)pkTableName.replaceAll("\"", ""))) continue;
            return "\u5b58\u5728\u90e8\u5206\u8868\u672a\u53d1\u5e03\uff0c\u8bf7\u5148\u53d1\u5e03\u3002";
        }
        return null;
    }
}

