/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.newsync.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TableManager;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.app.TransactionBlock;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynExecuteFacadeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.cache.BaseDataSynCacheHelper;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.util.GetExecuteIDHelper;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ExecuteEachTransactionBlock
implements TransactionBlock {
    private Context ctx;
    private static final Logger logger = Logger.getLogger(ExecuteEachTransactionBlock.class);
    private BaseDataSynHeadInfo baseDataSyninfo;
    private List<String> mainPKList;

    public ExecuteEachTransactionBlock(Context ctx, List<String> mainPKList, BaseDataSynHeadInfo baseDataSyninfo) {
        this.ctx = ctx;
        this.mainPKList = mainPKList;
        this.baseDataSyninfo = baseDataSyninfo;
    }

    @Override
    public Object doTransaction() throws Exception {
        ExecuteEachTransactionBlock.executeEachPlan(this.ctx, this.mainPKList, this.baseDataSyninfo);
        return null;
    }

    public static void executeEachPlan(Context ctx, List<String> mainPKList, BaseDataSynHeadInfo baseDataSyninfo) throws Exception {
        String monitorLogId = MonitorManager.getCurrentBaseDataDown().getId().toString();
        String connId = BaseDataSynCacheHelper.getCurrent().getConnInfo().getId().toString();
        List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSyninfo);
        for (BaseDataSynTableInfo tableInfo : sortedTableColl) {
            BaseDataRunner.deleteInvalidRecord(ctx, tableInfo.getPkTableName(), connId);
            TableManager manager = null;
            String tableName = null;
            try {
                manager = TableManager.getTableManager((Context)ctx);
                if (manager != null) {
                    tableName = manager.getTableName("permissionBatch");
                    String createSql = "create table " + tableName + " (FPageSize int, FID varchar(200), MAINPK varchar(200))";
                    manager.createTable(createSql);
                }
                StringBuffer sql = new StringBuffer().append("insert into " + tableName + "(fid, MAINPK) ").append(GetExecuteIDHelper.getQuerySQLForFId(ctx, tableName, tableInfo, mainPKList, tableName));
                DbUtil.execute((Context)ctx, (String)sql.toString());
                String getIDSQL = GetExecuteIDHelper.getQuerySQLForFId(ctx, tableName, tableInfo, mainPKList, tableName);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getIDSQL);
                while (rs.next()) {
                }
                BaseDataSynExecuteFacadeFactory.getLocalInstance(ctx).execPlanPatch(connId, mainPKList, baseDataSyninfo, tableInfo, monitorLogId, "add");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (manager == null || tableName == null) continue;
                manager.releaseTable(tableName);
            }
        }
    }
}

