/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogCollection;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BaseDataSynInvokeHelper {
    private static ThreadLocal<List<Class>> invokeClassList = new ThreadLocal();
    private static Logger logger = Logger.getLogger(BaseDataSynInvokeHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(Context ctx, BaseDataSynHeadInfo planInfo, String errorMsg) {
        MonitorLogInfo logInfo = MonitorManager.getCurrent();
        if (logInfo == null) {
            return;
        }
        ArrayList<String> failureList = new ArrayList<String>();
        HashSet successSet = new HashSet();
        ArrayList<String> successList = new ArrayList<String>();
        HashSet<String> failureSet = new HashSet<String>();
        String tempSucId = null;
        String tempFailId = null;
        List tempSuccIdList = null;
        List tempFailIdList = null;
        String sourceBillIds = null;
        String failureIds = null;
        JSONObject resultObj = null;
        String monitorLogId = logInfo.getId().toString();
        String implClass = planInfo.getImplClass();
        try {
            if (!StringUtils.isEmpty((String)implClass)) {
                List<String> list;
                String resultJSON = logInfo.getExtendedProperty("interfaceResult");
                resultObj = !StringUtils.isEmpty((String)resultJSON) ? new JSONObject(resultJSON) : new JSONObject();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemCollection itemColl = new FilterItemCollection();
                itemColl.add(new FilterItemInfo("monitorLogId", (Object)monitorLogId, CompareType.EQUALS));
                itemColl.add(new FilterItemInfo("planNumber", (Object)planInfo.getNumber(), CompareType.EQUALS));
                itemColl.add(new FilterItemInfo("mainTable", (Object)true, CompareType.EQUALS));
                filter.getFilterItems().addObjectCollection((IObjectCollection)itemColl);
                viewInfo.setFilter(filter);
                SelectorItemCollection selcors = new SelectorItemCollection();
                selcors.add(new SelectorItemInfo("success"));
                selcors.add(new SelectorItemInfo("failure"));
                selcors.add(new SelectorItemInfo("cmd"));
                selcors.add(new SelectorItemInfo("tableName"));
                viewInfo.setSelector(selcors);
                SubMonitorLogCollection coll = SubMonitorLogFactory.getLocalInstance(ctx).getSubMonitorLogCollection(viewInfo);
                Iterator it = coll.iterator();
                String tableName = null;
                String cmd = null;
                while (it.hasNext()) {
                    SubMonitorLogInfo subLogInfo = (SubMonitorLogInfo)it.next();
                    if (tableName == null) {
                        tableName = subLogInfo.getTableName();
                    }
                    if (cmd == null) {
                        cmd = subLogInfo.getCmd().toUpperCase();
                    }
                    if ((tempSucId = subLogInfo.getSuccess()) != null && tempSucId.length() > 0) {
                        tempSuccIdList = Arrays.asList((Object[])tempSucId.split(","));
                        successSet.addAll(tempSuccIdList);
                    }
                    if ((tempFailId = subLogInfo.getFailure()) == null || tempFailId.length() <= 0) continue;
                    tempFailIdList = Arrays.asList((Object[])tempFailId.split(","));
                    failureSet.addAll(tempFailIdList);
                }
                if (!StringUtils.isEmpty((String)logInfo.getStackTrace()) && (list = BaseDataResourceholder.getSubMainpkList()) != null && list.size() > 0) {
                    failureSet.addAll(list);
                }
                boolean isSuccess = StringUtils.isEmpty((String)errorMsg) || "null".equals(errorMsg);
                resultObj.put("isSuccess", isSuccess);
                resultObj.put("errorMsg", isSuccess ? "" : errorMsg);
                successList.addAll(successSet);
                sourceBillIds = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(successList, ",", "");
                resultObj.put("sourceBillIds", sourceBillIds);
                resultObj.put("successIds", sourceBillIds);
                failureList.addAll(failureSet);
                failureIds = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(failureList, ",", "");
                resultObj.put("failureIds", failureIds);
                resultObj.put("tableName", tableName);
                resultObj.put("action", cmd);
                resultObj.put("logId", monitorLogId);
                Class<?> ReverseClass = Class.forName(implClass);
                List<Class> classes = invokeClassList.get();
                if (classes == null) {
                    classes = new ArrayList<Class>();
                }
                classes.add(ReverseClass);
                Method method = ReverseClass.getMethod("_updateReturnVal", Context.class, String.class);
                method.invoke(ReverseClass.newInstance(), ctx, resultObj.toString());
            }
        }
        catch (Exception e) {
            String reverseResult = "\r\n\u8c03\u7528\u5b9e\u73b0\u7c7b(" + implClass + ")\u53cd\u9988\u57fa\u7840\u8d44\u6599\u540c\u6b65\u6267\u884c\u7ed3\u679c\u5f02\u5e38:" + e.getMessage();
            logInfo.setContent(errorMsg + reverseResult);
            logger.error((Object)e);
        }
        finally {
            failureList = null;
            successSet = null;
            successList = null;
            failureSet = null;
            tempSuccIdList = null;
            tempFailIdList = null;
            tempSucId = null;
            tempFailId = null;
            sourceBillIds = null;
            failureIds = null;
        }
    }

    public static void fixLogId(String newLogId) {
        List<Class> classes = invokeClassList.get();
        if (classes == null) {
            return;
        }
        Class clazz = null;
        int len = classes.size();
        for (int i = 0; i < len; ++i) {
            try {
                clazz = classes.get(i);
                Method method = clazz.getMethod("_setNewLogId", String.class);
                method.invoke(clazz.newInstance(), newLogId);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

