/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.util.ThrowableHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataDownExecutor;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataFunUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataPage;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataSynParam;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadSortedTableInfo;
import com.kingdee.eas.csinterface.billmapping.app.util.ThreadUtil;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ThreadBaseDataExector {
    private Logger logger = Logger.getLogger(ThreadBaseDataExector.class);
    public String connectionId;
    public String agentId4http;
    public List<String> mainPKList;
    private BaseDataDownExecutor executor;
    public int pageSize;
    public int headPkCount;
    private AtomicInteger atomInt = new AtomicInteger(-1);
    private ThreadBaseDataFunUtil threadUtil;
    private BaseDataDownMonitorLogInfo monitorLogInfo;
    private int pageCount;
    private AtomicInteger callBackCount = new AtomicInteger(0);
    private ThreadBaseDataInfo baseDataDownInfo;
    private ThreadSortedTableInfo sortedTableInfo;
    private AtomicInteger parentPage = new AtomicInteger(0);
    private Boolean avoidDeadLoop = false;
    public int parentTotalPage;
    private Context ctx;

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Boolean getAvoidDeadLoop() {
        return this.avoidDeadLoop;
    }

    public void setAvoidDeadLoop(Boolean avoidDeadLoop) {
        this.avoidDeadLoop = avoidDeadLoop;
    }

    public AtomicInteger getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(AtomicInteger parentPage) {
        this.parentPage = parentPage;
    }

    public AtomicInteger getAtomInt() {
        return this.atomInt;
    }

    public void setAtomInt(AtomicInteger atomInt) {
        this.atomInt = atomInt;
    }

    public ThreadSortedTableInfo getSortedTableInfo() {
        return this.sortedTableInfo;
    }

    public void setSortedTableInfo(ThreadSortedTableInfo sortedTableInfo) {
        this.sortedTableInfo = sortedTableInfo;
    }

    public ThreadBaseDataInfo getBaseDataDownInfo() {
        return this.baseDataDownInfo;
    }

    public void setBaseDataDownInfo(ThreadBaseDataInfo baseDataDownInfo) {
        this.baseDataDownInfo = baseDataDownInfo;
    }

    public BaseDataDownExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(BaseDataDownExecutor executor) {
        this.executor = executor;
    }

    public ThreadBaseDataFunUtil getThreadUtil() {
        return this.threadUtil;
    }

    public void setThreadUtil(ThreadBaseDataFunUtil threadUtil) {
        this.threadUtil = threadUtil;
    }

    public BaseDataDownMonitorLogInfo getMonitorLogInfo() {
        return this.monitorLogInfo;
    }

    public void setMonitorLogInfo(BaseDataDownMonitorLogInfo monitorLogInfo) {
        this.monitorLogInfo = monitorLogInfo;
    }

    public ThreadBaseDataExector(BaseDataDownExecutor executor, List<String> mainPKList, int pageSize, int headPkCount, ThreadBaseDataFunUtil threadUtil, BaseDataDownMonitorLogInfo monitorLogInfo) {
        this.executor = executor;
        this.mainPKList = mainPKList;
        this.pageSize = pageSize;
        this.headPkCount = headPkCount;
        this.threadUtil = threadUtil;
        this.monitorLogInfo = monitorLogInfo;
        this.pageCount = (headPkCount - 1) / pageSize + 1;
    }

    public void execBaseData(BaseDataSynHeadInfo baseDataSyninfo) throws Exception {
        if (this.callBackCount.addAndGet(1) == this.pageCount) {
            this.mainPKList.clear();
            try {
                this.executor.execBaseDataByType(this.baseDataDownInfo.getBaseDataSynInfo(), this.mainPKList, this.baseDataDownInfo.getMainTableInfo(), this.baseDataDownInfo.getExtendSQL(), this.monitorLogInfo, false, this);
            }
            catch (Exception e) {
                this.logger.error((Object)("\u56de\u8c03\u603b\u5206\u9875\u6279\u5f02\u5e38" + e + ThreadUtil.logCallStatck()));
                throw e;
            }
            return;
        }
        for (int i = 0; i < 2; ++i) {
            int pageCounter = this.atomInt.addAndGet(1);
            if (pageCounter >= this.pageCount) {
                return;
            }
            ThreadBaseDataSynParam.pageExec.submit(new ThreadBaseDataPage(baseDataSyninfo, this.cacl(pageCounter), this.baseDataDownInfo.getConnectionId(), this, false, this.monitorLogInfo.getExecType()));
        }
    }

    private List<String> cacl(int pageCounter) {
        int toIndexTmp = (pageCounter + 1) * this.pageSize;
        int toIndex = toIndexTmp > this.headPkCount ? this.headPkCount : toIndexTmp;
        return this.mainPKList.subList(pageCounter * this.pageSize, toIndex);
    }

    public void logExceptionInfo(Exception e, BaseDataSynHeadInfo baseDataSynInfo) {
        this.logger.error((Object)("\u57fa\u7840\u8d44\u6599\u5916\u53d1\u5f02\u5e38 \u4e2d\u6b62\u9519\u8bef" + e + "\u7ebf\u7a0b\u5806\u6808" + ThrowableHelper.toString((Throwable)e)));
        MonitorLogInfo current = MonitorManager.getCurrent();
        String errorMsg = current.getExtendedProperty("errorMsg");
        errorMsg = errorMsg + "\r\n" + ThreadUtil.logCallStatck(e);
        current.setExtendedProperty("errorMsg", errorMsg);
        current.setStatus("\u5f02\u5e38");
        MonitorManager.exitByMulti(this.getCtx(), baseDataSynInfo);
    }
}

