/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.billmapping.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BackgroundProcess;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.billmapping.app.AbstractMidBillDataProcessFacadeControllerBean;
import com.kingdee.eas.csinterface.billmapping.app.util.BillFunMetuxUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleTaskAction;
import com.kingdee.eas.csinterface.schedule.app.service.util.EIPBackgroundServiceProvider;
import com.kingdee.eas.csinterface.schedule.app.service.util.EipBPJob;
import com.kingdee.eas.csinterface.schedule.app.service.util.JobUtil;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationCollection;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationFactory;
import com.kingdee.eas.csinterface.syncdatabase.IEIPRelation;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.BaseDataMappingUtil;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MidBillDataProcessFacadeControllerBean
extends AbstractMidBillDataProcessFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.billmapping.app.MidBillDataProcessFacadeControllerBean");
    public static boolean synStatusByVoucer = false;

    @Override
    protected void _deleteMidBillData(Context ctx, String billMappingNumber, String[] headpks) throws BOSException {
        logger.info((Object)"--\u8c03\u7528 \u4e86\u4e2d\u95f4\u5355\u636e\u5220\u9664\u63a5\u53e3--");
        if (StringUtils.isEmpty((String)billMappingNumber)) {
            throw new BOSException("\u5355\u636e\u6620\u5c04\u7684\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u4efb\u52a1\u3002");
        }
        if (null == headpks || headpks.length == 0) {
            throw new BOSException("\u5355\u636e\u5934IDs\u6570\u7ec4\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u4efb\u52a1\u3002");
        }
        logger.info((Object)("\u53c2\u6570\u6570\u636e\uff1abillMappingNumber=" + billMappingNumber + ";headpks=" + Arrays.toString(headpks)));
        IBillMapping instance = BillMappingFactory.getLocalInstance(ctx);
        BillMappingInfo billMappingInfo = null;
        try {
            billMappingInfo = instance.getBillMappingInfo("where number = '" + billMappingNumber + "'");
        }
        catch (EASBizException e) {
            throw new BOSException("\u67e5\u8be2\u5355\u636e\u6620\u5c04[number=" + billMappingNumber + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (null == billMappingInfo) {
            throw new BOSException("\u65e0\u6cd5\u627e\u5230\u7f16\u53f7\u4e3a\u3010" + billMappingNumber + "\u3011\u7684\u5355\u636e\u6620\u5c04\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u4efb\u52a1.");
        }
        HashSet<String> headpkSet = new HashSet<String>();
        for (String s : headpks) {
            if (StringUtils.isEmpty((String)s)) continue;
            headpkSet.add(s);
        }
        Set<String> idSet = MidBillDataProcessFacadeControllerBean.selectFid(ctx, billMappingInfo, headpkSet);
        try {
            DIPMetadata dm = new DIPMetadata(billMappingNumber);
            MetaDataPK pk = MetaDataPK.create((String)dm.getHeaderEntityPK());
            IDynamicBillTemplate dynamicBillTemplate = (IDynamicBillTemplate)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)pk);
            Object[] successPKs = dynamicBillTemplate.deleteBatchMidBill(billMappingNumber, idSet.toArray(new String[0]), false);
            logger.info((Object)("\u5220\u9664\u8fd4\u56de\u503c\uff1a" + Arrays.toString(successPKs)));
        }
        catch (EASBizException e) {
            logger.info((Object)("\u5220\u9664\u4e2d\u95f4\u5355\u636e\u5f02\u5e38\uff1a" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
    }

    private static Set<String> selectFid(Context ctx, BillMappingInfo billMappingInfo, Set<String> headpkSet) throws BOSException {
        int i;
        HashSet<String> fidSet = new HashSet<String>();
        String midBillTable = billMappingInfo.getMidBillTable();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        String headId = "cfheadpk";
        StringBuffer headIds = new StringBuffer();
        for (i = 0; i < headpkSet.size(); ++i) {
            if (i > 0) {
                headIds.append(",");
            }
            headIds.append("?");
        }
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("select  fid from " + midBillTable + " where " + headId + " in (" + headIds.toString() + ")");
            i = 0;
            Iterator<String> it = headpkSet.iterator();
            while (it.hasNext()) {
                preparedStatement.setObject(i + 1, it.next());
                ++i;
            }
            rs = preparedStatement.executeQuery();
            Object temp = null;
            while (rs.next()) {
                temp = rs.getObject(1);
                if (null == temp) continue;
                fidSet.add(temp.toString());
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
        return fidSet;
    }

    private static void deleteMidData(Context ctx, BillMappingInfo billMappingInfo, Set<String> headpkSet) throws BOSException {
        String midBillTable = billMappingInfo.getMidBillTable();
        String midBillEntryTable = billMappingInfo.getMidBillEntryTable();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        String headId = "cfheadpk";
        StringBuffer headIds = new StringBuffer();
        for (int i = 0; i < headpkSet.size(); ++i) {
            if (i > 0) {
                headIds.append(",");
            }
            headIds.append("?");
        }
        HashSet<String> fidSet = new HashSet<String>();
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("select  fid from " + midBillTable + " where " + headId + " in (" + headIds.toString() + ")");
            int i = 0;
            Iterator<String> it = headpkSet.iterator();
            while (it.hasNext()) {
                preparedStatement.setObject(i + 1, it.next());
                ++i;
            }
            rs = preparedStatement.executeQuery();
            Iterator temp = null;
            while (rs.next()) {
                temp = rs.getObject(1);
                if (null == temp) continue;
                fidSet.add(temp.toString());
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u67e5\u8be2\u4e2d\u95f4\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
        try {
            connection = DBUtils.getConnection(ctx);
            String delHeadStr = "delete from " + midBillTable + " where fid=?";
            preparedStatement = connection.prepareStatement(delHeadStr);
            for (String fid : fidSet) {
                preparedStatement.setObject(1, fid);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            String delEntryStr = "delete from " + midBillEntryTable + " where fparentid=?";
            preparedStatement = connection.prepareStatement(delEntryStr);
            for (String fid : fidSet) {
                preparedStatement.setObject(1, fid);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception e1) {
            logger.error((Object)"\u5220\u9664\u4e2d\u95f4\u8868\u5f02\u5e38\uff1a", (Throwable)e1);
            throw new BOSException("\u5220\u9664\u4e2d\u95f4\u8868\u5f02\u5e38\uff1a" + e1.getMessage());
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
        }
    }

    private static void deletePkTableData(Context ctx, BillMappingInfo billMappingInfo, Set<String> headpkSet) throws BOSException {
        Connection connection = null;
        PreparedStatement deleteStatement = null;
        try {
            boolean isAgent = DataSourceType.agent.equals((Object)billMappingInfo.getDsType());
            if (isAgent) {
                String[] headpks = headpkSet.toArray(new String[0]);
                EipTaskManager.orderDeleteBillData(ctx, billMappingInfo, headpks, headpks);
                return;
            }
            ConnectionInfo conInfo = billMappingInfo.getSrcDBConn();
            if (null == conInfo) {
                throw new BOSException("\u5220\u9664 \u589e\u91cf\u8868[" + billMappingInfo.getPkTableName() + "]\u5f02\u5e38\uff1a\u6e90\u7cfb\u7edf\u8fde\u63a5\u914d\u7f6e\u4e3a\u7a7a.");
            }
            String id = conInfo.getId().toString();
            IObjectPK pk = CommonUtil.convert2PK(id);
            conInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(pk);
            connection = KSQLUtil.getConnection(conInfo);
            deleteStatement = connection.prepareStatement("delete from " + billMappingInfo.getPkTableName() + " where " + "headpk" + " = ?");
            for (String headpk : headpkSet) {
                deleteStatement.setObject(1, headpk);
                deleteStatement.addBatch();
            }
            deleteStatement.executeBatch();
            SQLUtils.cleanup((Statement)deleteStatement, (Connection)connection);
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u4e2d\u95f4\u8868\u5f02\u5e38:", (Throwable)e);
            throw new BOSException("\u5220\u9664 \u589e\u91cf\u8868[" + billMappingInfo.getPkTableName() + "]\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            SQLUtils.cleanup(deleteStatement, connection);
        }
    }

    @Override
    protected Object _setMidBillStatus(Context ctx, String midBillTableName, String[] srcObjectIDs) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (StringUtils.isEmpty((String)midBillTableName)) {
            throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff1amidBillTableName\uff08\u4e2d\u95f4\u8868\u540d\uff09\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (null == srcObjectIDs || srcObjectIDs.length == 0) {
            result.put("srcIdRealNum", 0);
            return result;
        }
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < srcObjectIDs.length; ++i) {
            if (StringUtils.isEmpty((String)srcObjectIDs[i])) continue;
            srcIdSet.add(srcObjectIDs[i].trim());
        }
        result.put("srcIdRealNum", srcIdSet.size());
        if (srcIdSet.size() < 1) {
            return result;
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)StringUtils.arrayToString((Object[])srcIdSet.toArray(), (String)","), CompareType.INCLUDE));
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        HashSet<String> exitSrcIdSet = new HashSet<String>();
        int relationSize = relations.size();
        String[] destIDs = new String[relationSize];
        HashMap<String, String> srcMapDest = new HashMap<String, String>();
        if (relations != null && relationSize > 0) {
            int i = 0;
            for (BOTRelationInfo relation : relations) {
                String srcID = relation.getSrcObjectID();
                String destID = relation.getDestObjectID();
                exitSrcIdSet.add(srcID);
                destIDs[i] = destID;
                srcMapDest.put(destID, srcID);
                ++i;
            }
        }
        if (synStatusByVoucer) {
            try {
                Map<String, CoreBaseInfo> map = BaseDataMappingUtil.convertFid2CoreBase(ctx, destIDs);
                Set<String> keySet = map.keySet();
                Iterator<String> itera = keySet.iterator();
                HashSet existSrcIDSet = new HashSet();
                while (itera.hasNext()) {
                    existSrcIDSet.add(srcMapDest.get(itera.next()));
                }
                exitSrcIdSet.clear();
                exitSrcIdSet.addAll(existSrcIDSet);
            }
            catch (EASBizException e) {
                logger.error((Object)"EASBizException", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"BOSException", (Throwable)e);
            }
        }
        HashSet<String> notexitSrcIdSet = new HashSet<String>();
        for (String id : srcIdSet) {
            if (!exitSrcIdSet.contains(id)) {
                notexitSrcIdSet.add(id);
                continue;
            }
            System.out.println(id + "\u5df2\u7ecf\u5b58\u5728\u8be5ID[" + id + "]\uff0c\u5df2\u751f\u6210\u76ee\u6807\u5355\u636e!");
        }
        if (exitSrcIdSet.size() > 0) {
            this.updateMidBillStatus(ctx, midBillTableName, 1, exitSrcIdSet);
            this.updateBotRelationStatus(ctx, exitSrcIdSet);
        }
        if (notexitSrcIdSet.size() > 0) {
            this.updateMidBillStatus(ctx, midBillTableName, 0, notexitSrcIdSet);
        }
        result.put("srcIdExitNum", exitSrcIdSet.size());
        result.put("srcIdNotExitNum", notexitSrcIdSet.size());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBotRelationStatus(Context ctx, Set<String> fidSet) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("update T_BOT_RELATION set fiseffected=1 where fsrcObjectID=?");
            for (String id : fidSet) {
                preparedStatement.setObject(1, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u8bbe\u7f6e\u5173\u8054\u751f\u6210\u8868\u6709\u6548\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)preparedStatement, (Connection)connection);
        }
        SQLUtils.cleanup(rs, (Statement)preparedStatement, (Connection)connection);
    }

    private Set<String> getFidByNull(Context ctx, String tableName) throws BOSException {
        HashSet<String> hashSet;
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        HashSet<String> fidSet = new HashSet<String>();
        try {
            connection = DBUtils.getConnection(ctx);
            stm = connection.createStatement();
            rs = stm.executeQuery("select fid from " + tableName + " where fmidbillstatus is null");
            String id = null;
            while (rs.next()) {
                id = rs.getString(1);
                if (!StringUtils.isEmpty((String)id)) continue;
                fidSet.add(id);
            }
            hashSet = fidSet;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u83b7\u53d6\u4e2d\u95f4\u5355\u636e" + tableName + "\u8868\u7684fmidbillstatus\u5b57\u6bb5\u4e3anull\u7684Fid\u5f02\u5e38.\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u83b7\u53d6\u4e2d\u95f4\u5355\u636e" + tableName + "\u8868\u7684fmidbillstatus\u5b57\u6bb5\u4e3anull\u7684Fid\u5f02\u5e38.\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stm, (Connection)connection);
        return hashSet;
    }

    private void updateMidBillStatus(Context ctx, String tableName, int status, Set<String> fidSet) throws BOSException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("update " + tableName + " set fmidbillstatus=?,ffivouchered=?  where fid=?");
            for (String id : fidSet) {
                preparedStatement.setObject(1, status);
                preparedStatement.setObject(2, status);
                preparedStatement.setObject(3, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement = connection.prepareStatement("update " + tableName + "Entry set fentryStatus=? where fparentid =?");
            for (String id : fidSet) {
                preparedStatement.setObject(1, status);
                preparedStatement.setObject(2, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)preparedStatement, (Connection)connection);
    }

    @Override
    protected void _addColumnIfNeed(Context ctx, String tableName, String colName) throws BOSException {
        Connection connection = null;
        ResultSet rs = null;
        Statement stm = null;
        try {
            connection = DBUtils.getConnection(ctx);
            boolean exitCollFlag = false;
            String sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME='" + tableName + "'";
            stm = connection.createStatement();
            if (!StringUtils.isEmpty((String)tableName) && !StringUtils.isEmpty((String)colName)) {
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    if (!colName.equalsIgnoreCase(rs.getString(1))) continue;
                    exitCollFlag = true;
                    break;
                }
            }
            if (!exitCollFlag) {
                stm = connection.createStatement();
                stm.executeUpdate("ALTER TABLE " + tableName + " ADD " + colName + " INT");
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u68c0\u67e5\u6216\u65b0\u589e\u4e2d\u95f4\u8868" + tableName + "\u662f\u5426\u5b58\u5728" + colName + "\u5217\u5f02\u5e38.\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u68c0\u67e5\u6216\u65b0\u589e\u4e2d\u95f4\u8868" + tableName + "\u662f\u5426\u5b58\u5728" + colName + "\u5217\u5f02\u5e38." + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stm, (Connection)connection);
    }

    @Override
    protected Object _setMidBillEntryStatus(Context ctx, String midBillEntryTableName, String[] srcObjectIds) throws BOSException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = DBUtils.getConnection(ctx);
            String jobNumber = "";
            if (MonitorManager.getCurrentMidBillToDest() != null) {
                jobNumber = MonitorManager.getCurrentMidBillToDest().getAssignNumber();
            }
            StringBuilder queryString = new StringBuilder();
            queryString.append(" update ").append(midBillEntryTableName).append(" set ").append(" FAssignmentNumber = '").append(jobNumber).append("' ,").append(" fentryStatus = ? ").append(" where fid = ?");
            preparedStatement = connection.prepareStatement(queryString.toString());
            for (String id : srcObjectIds) {
                preparedStatement.setObject(1, 1);
                preparedStatement.setObject(2, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
        catch (Exception e) {
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                logger.error((Object)("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u5206\u5f55\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u8868\u5206\u5f55\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)preparedStatement, (Connection)connection);
        return "SUCCESS";
    }

    @Override
    protected Object _checkMidStatuForBaseData(Context ctx, String billMappingNumber, String[] headpks) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            if (StringUtils.isEmpty((String)billMappingNumber)) {
                throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff1abillMappingNumber\uff08\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u7f16\u7801\uff09\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            if (null == headpks || headpks.length == 0) {
                result.put("srcIdRealNum", 0);
                result.put("srcIdExitNum", 0);
                result.put("srcIdNotExitNum", 0);
                return result;
            }
            HashSet<String> srcIdSet = new HashSet<String>();
            for (int i = 0; i < headpks.length; ++i) {
                if (StringUtils.isEmpty((String)headpks[i])) continue;
                srcIdSet.add(headpks[i].trim());
            }
            result.put("srcIdRealNum", srcIdSet.size());
            if (srcIdSet.size() < 1) {
                return result;
            }
            MetaDataPK metaPk = new MetaDataPK(new DIPMetadata(billMappingNumber).getHeaderEntityPK());
            EntityObjectInfo entity = UictUtils.loadEntity((IMetaDataPK)metaPk);
            if (entity == null || entity.getType() == null) {
                throw new BOSException("\u8bbe\u7f6e\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u5f02\u5e38,\u67e5\u8be2\u7f16\u7801\u4e3a" + billMappingNumber + "\u4e1a\u52a1\u5355\u636e\u6620\u5c04BOSTYPE\u5931\u8d25");
            }
            String bostype = entity.getType().toString();
            IEIPRelation instance = EIPRelationFactory.getLocalInstance(ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterBill = new FilterInfo();
            viewInfo.setFilter(filterBill);
            filterBill.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)bostype, CompareType.EQUALS));
            filterBill.getFilterItems().add(new FilterItemInfo("headpk", srcIdSet, CompareType.INCLUDE));
            EIPRelationCollection coll = instance.getEIPRelationCollection(viewInfo);
            HashMap<String, String> headpkDestIdMap = new HashMap<String, String>();
            String[] destIDs = new String[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                destIDs[i] = coll.get(i).getDestObjectID();
                headpkDestIdMap.put(coll.get(i).getHeadpk(), coll.get(i).getDestObjectID());
            }
            Map<String, CoreBaseInfo> map = BaseDataMappingUtil.convertFid2CoreBase(ctx, destIDs);
            ArrayList<Object[]> exists = new ArrayList<Object[]>();
            ArrayList<Object[]> noexists = new ArrayList<Object[]>();
            HashSet<String> needDeleteRelation = new HashSet<String>();
            for (String headpk : headpks) {
                if (headpkDestIdMap.containsKey(headpk)) {
                    String destID = (String)headpkDestIdMap.get(headpk);
                    if (map.containsKey(destID)) {
                        exists.add(new Object[]{1, headpk});
                        continue;
                    }
                    needDeleteRelation.add(headpk);
                    noexists.add(new Object[]{0, headpk});
                    continue;
                }
                noexists.add(new Object[]{0, headpk});
            }
            String tableName = DBUtils.createTableName(billMappingNumber);
            String updateSql = "update " + tableName + " set fmidbillstatus=? where cfheadpk=?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, exists);
            DbUtil.executeBatch((Context)ctx, (String)updateSql, noexists);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)bostype, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("headpk", needDeleteRelation, CompareType.INCLUDE));
            instance.delete(filter);
            result.put("srcIdExitNum", exists.size());
            result.put("srcIdNotExitNum", noexists.size());
        }
        catch (Exception e) {
            logger.error((Object)"\u3010EIP\u3011\u4fee\u590d\u4e2d\u95f4\u5355\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _checkDataChange(Context ctx, String midBillNumber, String filter) throws BOSException {
        BillMappingInfo billMappingInfo = null;
        MutexParameter retParam = null;
        try {
            billMappingInfo = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo("where number= '" + midBillNumber + "'");
            if (null != billMappingInfo && billMappingInfo.isIsBillRequestMutex()) {
                if (BillFunMetuxUtil.isRequstFunMutex(ctx, billMappingInfo, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316")) {
                    retParam = BillFunMetuxUtil.requestFunMutex(ctx, (CoreBaseInfo)billMappingInfo, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316");
                    this.innerCheckDataChange(ctx, billMappingInfo, filter);
                } else {
                    BillFunMetuxUtil.triggerBillDelayTask4Client(ctx, null, filter, billMappingInfo, null, null, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316", 10000L);
                }
            } else {
                this.innerCheckDataChange(ctx, billMappingInfo, filter);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u624b\u52a8\u70b9\u51fb\u68c0\u6d4b\u53d8\u5316\u6309\u94ae\u68c0\u6d4b\u6570\u636e\u53d8\u5316\uff1a\u68c0\u6d4b\u6570\u636e\u53d8\u5316\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != retParam) {
                BillFunMetuxUtil.releaseFunctionMutex(ctx, retParam.getRequestId());
            }
        }
    }

    private void innerCheckDataChange(Context ctx, BillMappingInfo billMappingInfo, String filter) throws BOSException {
        try {
            EipUserInfo agent;
            ConnectionInfo connInfo = billMappingInfo.getSrcDBConn();
            if (connInfo != null) {
                billMappingInfo.setSrcDBConn(ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connInfo.getId())));
            }
            if ((agent = billMappingInfo.getAgentUser()) != null) {
                billMappingInfo.setAgentUser(EipUserFactory.getLocalInstance(ctx).getEipUserInfo(CommonUtil.convert2PK(agent.getId())));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"\u624b\u52a8\u70b9\u51fb\u68c0\u6d4b\u53d8\u5316\u6309\u94ae\u68c0\u6d4b\u6570\u636e\u53d8\u5316\uff1a\u83b7\u53d6\u4e2d\u95f4\u5355\u636e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            new ScheduleTaskAction().processDataChange(ctx, null, billMappingInfo, filter);
        }
        catch (Exception e) {
            logger.error((Object)"\u624b\u52a8\u70b9\u51fb\u68c0\u6d4b\u53d8\u5316\u6309\u94ae\u68c0\u6d4b\u6570\u636e\u53d8\u5316\uff1a\u68c0\u6d4b\u6570\u636e\u53d8\u5316\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean triggerProcessSnapShot(Context ctx, BillMappingInfo billMappingInfo) throws BOSException, EASBizException {
        MutexParameter retParam = null;
        boolean b = false;
        try {
            if (null != billMappingInfo && billMappingInfo.isIsBillRequestMutex()) {
                if (BillFunMetuxUtil.isRequstFunMutex(ctx, billMappingInfo, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316")) {
                    retParam = BillFunMetuxUtil.requestFunMutex(ctx, (CoreBaseInfo)billMappingInfo, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316");
                    b = MidBillDataProcessFacadeControllerBean.innerSnapShot(ctx, billMappingInfo);
                } else {
                    BillFunMetuxUtil.triggerBillDelayTask4Client(ctx, null, null, billMappingInfo, null, null, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316", 10000L);
                }
            } else {
                b = MidBillDataProcessFacadeControllerBean.innerSnapShot(ctx, billMappingInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u91cd\u7f6e\u5feb\u7167\u8fc7\u7a0b\u5f02\u5e38\uff01", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != retParam) {
                BillFunMetuxUtil.releaseFunctionMutex(ctx, retParam.getRequestId());
            }
        }
        return b;
    }

    private static boolean innerSnapShot(Context ctx, BillMappingInfo billMappingInfo) throws BOSException, EASBizException {
        String billId = billMappingInfo.getId().toString();
        boolean isJDBC = DataSourceType.jdbc.getValue().equals(billMappingInfo.getDsType().getValue());
        if (isJDBC) {
            Method processMidBillMethod;
            BPOption bpOption = new BPOption();
            bpOption.setPersistent(false);
            bpOption.setImmediately(true);
            try {
                processMidBillMethod = ScheduleTaskAction.class.getMethod("processDataChange", Context.class, Job.class, BillMappingInfo.class, String.class);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            Object[] paramValues = new Object[]{ctx, billMappingInfo, null};
            EipBPJob bpJob = new EipBPJob(StringUtils.isEmpty((String)ctx.getClientHostIP()) ? "\u8c03\u5ea6\u7b56\u7565" : "EAS\u5ba2\u6237\u7aef");
            bpOption.setDataCenter(ctx.getAIS());
            BackgroundProcess bp = new BackgroundProcess(ctx, bpOption, (IBOSObject)ScheduleTaskAction.getInstance(), processMidBillMethod, paramValues);
            bpJob.setBp(bp);
            EIPBackgroundServiceProvider.getInstance().submit(ctx, bpJob, JobUtil.getMidBillMutex(ctx, billId));
        }
        return true;
    }
}

