/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.billmapping.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingType;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.billmapping.IReportField;
import com.kingdee.eas.csinterface.billmapping.ReportFieldCollection;
import com.kingdee.eas.csinterface.billmapping.ReportFieldFactory;
import com.kingdee.eas.csinterface.billmapping.ReportFieldInfo;
import com.kingdee.eas.csinterface.billmapping.app.util.TempTableUtil;
import com.kingdee.eas.csinterface.billmapping.app.util.ThreadUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class BillMappingUtil {
    static Logger logger = Logger.getLogger(BillMappingUtil.class);
    public static int repairCount = 10000;
    public static int repairPageSize = 1000;
    public static boolean isOpenBak = false;

    public static SelectorItemCollection getFullSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("feedback.*");
        selector.add("srcDBConn.*");
        selector.add("assistAccountType.*");
        selector.add("assistAccountType.entrys.*");
        selector.add("assistAccountType.entrys.baseDataType.*");
        selector.add("assistAccountType.entrys.baseDataType.destBaseData.*");
        selector.add("Entrys.*");
        selector.add("Entrys.baseDataType.*");
        selector.add("Entrys.baseDataType.destBaseData.*");
        return selector;
    }

    public static Map<String, String> getReportFieldForColumn(Context ctx, String billNumber) throws Exception {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        BillMappingInfo billInfo = null;
        IBillMapping instance = null;
        IReportField reportInstance = null;
        if (ctx == null) {
            instance = BillMappingFactory.getRemoteInstance();
            reportInstance = ReportFieldFactory.getRemoteInstance();
        } else {
            instance = BillMappingFactory.getLocalInstance(ctx);
            reportInstance = ReportFieldFactory.getLocalInstance(ctx);
        }
        billInfo = instance.getBillMappingInfo("where number='" + billNumber + "'");
        if (billInfo == null) {
            throw new BOSException("EIP-\u67e5\u8be2\u7684\u5355\u636e\u7f16\u7801\uff08" + billNumber + "\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002");
        }
        if (BillMappingType.reportMapping.equals((Object)billInfo.getMappingType())) {
            DIPMetadata dm = new DIPMetadata(billInfo.getNumber());
            EntityObjectInfo headEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
            EntityObjectInfo entryEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
            if (headEntityInfo == null) {
                throw new BOSException("EIP-\u5355\u636e\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u3002");
            }
            BillMappingEntryCollection entrys = BillMappingUtil.getUnDropedEntry(billInfo);
            Iterator entryIte = entrys.iterator();
            BillMappingEntryInfo entryInfo = null;
            String midName = null;
            PropertyInfo prot = null;
            String dbColumnName = null;
            ReportFieldInfo report = null;
            while (entryIte.hasNext()) {
                entryInfo = (BillMappingEntryInfo)entryIte.next();
                boolean isHead = entryInfo.isHead();
                midName = entryInfo.getMidFieldName();
                report = entryInfo.getReportField();
                if (report == null) continue;
                report = reportInstance.getReportFieldInfo(CommonUtil.convert2PK(entryInfo.getReportField().getId().toString()));
                prot = isHead ? headEntityInfo.getPropertyByName(midName) : entryEntityInfo.getPropertyByName(midName);
                dbColumnName = prot.getMappingField().getName();
                fieldMap.put(report.getNumber().toLowerCase(), dbColumnName);
            }
        }
        return fieldMap;
    }

    public static Map<String, String> getReportFieldForProperty(Context ctx, String billNumber) throws Exception {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        BillMappingInfo billInfo = null;
        IBillMapping instance = null;
        IReportField reportInstance = null;
        if (ctx == null) {
            instance = BillMappingFactory.getRemoteInstance();
            reportInstance = ReportFieldFactory.getRemoteInstance();
        } else {
            instance = BillMappingFactory.getLocalInstance(ctx);
            reportInstance = ReportFieldFactory.getLocalInstance(ctx);
        }
        billInfo = instance.getBillMappingInfo("where number='" + billNumber + "'");
        if (billInfo == null) {
            throw new BOSException("EIP-\u67e5\u8be2\u7684\u5355\u636e\u7f16\u7801\uff08" + billNumber + "\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002");
        }
        if (BillMappingType.reportMapping.equals((Object)billInfo.getMappingType())) {
            DIPMetadata dm = new DIPMetadata(billInfo.getNumber());
            EntityObjectInfo headEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
            EntityObjectInfo entryEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
            if (headEntityInfo == null) {
                throw new BOSException("EIP-\u5355\u636e\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u3002");
            }
            BillMappingEntryCollection entrys = BillMappingUtil.getUnDropedEntry(billInfo);
            Iterator entryIte = entrys.iterator();
            BillMappingEntryInfo entryInfo = null;
            String midName = null;
            PropertyInfo prot = null;
            String fieldName = null;
            ReportFieldInfo report = null;
            HashMap<String, ReportFieldInfo> reportMap = new HashMap<String, ReportFieldInfo>();
            ReportFieldCollection reportColl = reportInstance.getReportFieldCollection();
            Iterator reportIte = reportColl.iterator();
            while (reportIte.hasNext()) {
                ReportFieldInfo reprotInfo = (ReportFieldInfo)reportIte.next();
                reportMap.put(reprotInfo.getId().toString(), reprotInfo);
            }
            while (entryIte.hasNext()) {
                entryInfo = (BillMappingEntryInfo)entryIte.next();
                boolean isHead = entryInfo.isHead();
                midName = entryInfo.getMidFieldName();
                report = entryInfo.getReportField();
                if (report == null || (report = (ReportFieldInfo)reportMap.get(entryInfo.getReportField().getId().toString())) == null) continue;
                prot = isHead ? headEntityInfo.getPropertyByName(midName) : entryEntityInfo.getPropertyByName(midName);
                fieldName = prot.getName();
                fieldMap.put(report.getNumber().toLowerCase(), fieldName);
            }
        }
        return fieldMap;
    }

    public static BillMappingEntryCollection getUnDropedEntry(BillMappingInfo billInfo) throws Exception {
        BillMappingEntryCollection entrys = billInfo.getEntrys();
        Iterator entryIte = entrys.iterator();
        BillMappingEntryInfo entryInfo = null;
        while (entryIte.hasNext()) {
            entryInfo = (BillMappingEntryInfo)entryIte.next();
            if (!entryInfo.isDropped()) continue;
            entryIte.remove();
        }
        return entrys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean synDataFromSrcAndDest(Context ctx, Set<String> billPkSet) throws BOSException {
        Connection curConnect;
        Iterator<String> iter = billPkSet.iterator();
        try {
            curConnect = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e1) {
            logger.error((Object)"\u83b7\u53d6\u5f53\u524d\u7684\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5\u5931\u8d25\uff01");
            return false;
        }
        Connection connection = null;
        PreparedStatement curStatement = null;
        PreparedStatement statement = null;
        RowSet curRs = null;
        ResultSet rs = null;
        while (iter.hasNext()) {
            String idPk = iter.next();
            if (StringUtils.isEmpty(idPk)) {
                logger.error((Object)"\u4f20\u5165\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                continue;
            }
            BillMappingInfo billInfo = null;
            IBillMapping instance = null;
            boolean isNumber = true;
            try {
                instance = ctx == null ? BillMappingFactory.getRemoteInstance() : BillMappingFactory.getLocalInstance(ctx);
                try {
                    billInfo = instance.getBillMappingInfo("where number='" + idPk + "'");
                }
                catch (Exception e) {
                    isNumber = false;
                    logger.error((Object)(idPk + "\u975enumber\u5b57\u6bb5\u503c,\u8f6cID\u67e5\u8be2"));
                }
                billInfo = DataModelUtil.readBillMappingInfo(ctx, isNumber ? billInfo.getId().toString() : idPk);
                String pkTableName = billInfo.getPkTableName();
                String midBillTable = billInfo.getMidBillTable();
                ConnectionInfo connect = billInfo.getSrcDBConn();
                connection = KSQLUtil.getConnection(connect);
                connection.setAutoCommit(true);
                ArrayList<String> listPk = new ArrayList<String>();
                int upCount = 0;
                statement = connection.prepareStatement("select distinct headpk from " + pkTableName);
                rs = statement.executeQuery();
                while (rs.next()) {
                    listPk.add(rs.getString(1));
                }
                upCount = listPk.size();
                if (upCount <= repairCount) {
                    RowSet rowset = SQLUtils.getJdbcRowSet((Connection)curConnect, (String)("select cfheadpk from " + midBillTable));
                    HashSet<String> setMidBill = new HashSet<String>();
                    while (rowset.next()) {
                        setMidBill.add(rowset.getString(1));
                    }
                    listPk.removeAll(setMidBill);
                    BillMappingUtil.synDiffData(billInfo, pkTableName, connection, listPk);
                } else {
                    BillMappingUtil.createSrcHeadpkTable(curConnect, midBillTable);
                    String insertSql = "insert into T_EIP_SRCHEADPK values(?)";
                    curStatement = curConnect.prepareStatement(insertSql);
                    int pageSize = repairPageSize;
                    int pageCount = (upCount - 1) / pageSize + 1;
                    for (int j = 0; j < pageCount; ++j) {
                        int beginIndex = j * pageSize;
                        int endIndex = (j + 1) * pageSize;
                        if (j == pageCount - 1) {
                            endIndex = upCount;
                        }
                        for (int i = beginIndex; i < endIndex; ++i) {
                            curStatement.setString(1, (String)listPk.get(i));
                            curStatement.addBatch();
                        }
                        curStatement.executeBatch();
                        curStatement.clearBatch();
                    }
                    String diffSql = "select m.headpk from T_EIP_SRCHEADPK  m where not exists (select 1 from " + midBillTable + " t where t.cfheadpk =  m.headpk)";
                    curRs = SQLUtils.getJdbcRowSet((Connection)curConnect, (String)diffSql);
                    HashSet<String> diffSet = new HashSet<String>();
                    while (curRs.next()) {
                        diffSet.add(curRs.getString(1));
                    }
                    BillMappingUtil.synDiffData(billInfo, pkTableName, connection, diffSet);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        SQLUtils.execute((Connection)curConnect, (String)"delete from T_EIP_SRCHEADPK");
                    }
                    catch (SQLException e2) {
                        logger.error((Object)("T_EIP_SRCHEADPK \u6e05\u9664\u5931\u8d25" + e2));
                    }
                    SQLUtils.cleanup(curRs, curStatement, (Connection)curConnect);
                    SQLUtils.cleanup(rs, statement, connection);
                    throw throwable;
                }
            }
            try {
                SQLUtils.execute((Connection)curConnect, (String)"delete from T_EIP_SRCHEADPK");
            }
            catch (SQLException e) {
                logger.error((Object)("T_EIP_SRCHEADPK \u6e05\u9664\u5931\u8d25" + e));
            }
            SQLUtils.cleanup(curRs, (Statement)curStatement, (Connection)curConnect);
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSrcHeadpkTable(Connection curConnect, String midBillTable) throws SQLException {
        ResultSet rowSet = null;
        Statement statement = null;
        String dbType = "";
        try {
            statement = curConnect.createStatement();
            dbType = curConnect.getMetaData().getDatabaseProductName();
            String sql = "select top 10 * from T_EIP_SRCHEADPK";
            if ("MySql".equalsIgnoreCase(dbType)) {
                sql = "select count(1) from T_EIP_SRCHEADPK";
            }
            rowSet = statement.executeQuery(sql);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"T_EIP_SRCHEADPK \u672a\u521b\u5efa");
                logger.error((Object)ThreadUtil.logCallStatck(e));
                String createSql = "";
                if ("SqlServer".equalsIgnoreCase(dbType)) {
                    String rule = TempTableUtil.checkSortRule(curConnect, midBillTable);
                    createSql = "create table  T_EIP_SRCHEADPK (headpk VARCHAR(50) collate " + rule + " primary key)";
                } else {
                    createSql = "create table T_EIP_SRCHEADPK (headpk VARCHAR(50) primary key)";
                }
                statement = curConnect.createStatement();
                statement.execute(createSql);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowSet, (Statement)statement);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
        }
        SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int synDiffData(BillMappingInfo billInfo, String pkTableName, Connection connection, Collection<String> diffSet) throws SQLException {
        int deleteCount = 0;
        if (!diffSet.isEmpty()) {
            StringBuilder strBufDel = new StringBuilder();
            strBufDel.append("delete from " + pkTableName + " where headpk in ( ");
            Iterator<String> iterPk = diffSet.iterator();
            int index = 1;
            while (iterPk.hasNext()) {
                if (index > 1) {
                    strBufDel.append(",'" + iterPk.next() + "'");
                } else {
                    strBufDel.append("'" + iterPk.next() + "'");
                }
                ++index;
            }
            strBufDel.append(" )");
            String strDel = strBufDel.toString();
            logger.error((Object)("\u5220\u9664SQL\u8bb0\u5f55\uff1a" + strDel));
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(strDel);
                deleteCount = statement.executeUpdate();
                logger.error((Object)("\u5220\u9664\u8868" + billInfo.getPkTableName() + "\u7684\u6570\u636e" + deleteCount + "\u6761"));
            }
            finally {
                SQLUtils.cleanup((Statement)statement);
            }
        }
        return deleteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distinctTable(Context ctx, String targetCn, String tableName) {
        Connection connection = null;
        try {
            ConnectionInfo connInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(targetCn));
            connection = KSQLUtil.getConnection(connInfo);
            connection.setAutoCommit(true);
            String dbType = connection.getMetaData().getDatabaseProductName();
            String distinctSql = "";
            if ("MySql".equalsIgnoreCase(dbType)) {
                distinctSql = "delete from " + tableName + " where";
            } else if ("Oracle ".equalsIgnoreCase(dbType)) {
                distinctSql = "delete from " + tableName + " ms    where rowid in (select aa.rid from (select rowid as rid,  row_number() over(partition by s.headpk order by s.createTime) as nu  from " + tableName + " s) aa where aa.nu > 1) ";
            }
            SQLUtils.execute((Connection)connection, (String)distinctSql);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u589e\u91cf\u8868\u53bb\u91cd\u62a5\u9519", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(connection);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)connection);
        }
        SQLUtils.cleanup((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixIncreTable(Context ctx, String idPk) {
        block14: {
            Connection targetCn = null;
            Connection currCn = null;
            PreparedStatement statement = null;
            try {
                BillMappingInfo billInfo = BillMappingUtil.getBillMappingInfo(ctx, idPk);
                String pkTableName = billInfo.getPkTableName();
                String midBillTable = billInfo.getMidBillTable();
                ConnectionInfo connect = billInfo.getSrcDBConn();
                targetCn = KSQLUtil.getConnection(connect);
                currCn = DbConnector.getConnection((Context)ctx);
                String qrySql = "select cfheadpk  from " + midBillTable;
                RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)currCn, (String)qrySql);
                HashSet<String> set = new HashSet<String>();
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
                String bakTable = TempTableUtil.filterStr(pkTableName);
                if (isOpenBak) {
                    Calendar rightNow = Calendar.getInstance();
                    int mouth = rightNow.get(2) + 1;
                    String bakSql = "create table " + bakTable + "_bak" + mouth + rightNow.get(5) + " select * from " + pkTableName;
                    SQLUtils.execute((Connection)targetCn, (String)bakSql);
                }
                String tempTable = bakTable.replace("T_", "");
                String sql = "create table " + tempTable + " select * from " + pkTableName + " where 1=2";
                String clearTab = "truncate table " + tempTable;
                try {
                    SQLUtils.execute((Connection)targetCn, (String)sql);
                }
                catch (Exception e) {
                    logger.error((Object)"\u5f53\u524d\u8868\u5df2\u7ecf\u5b58\u5728,\u8d70\u8868\u6e05\u7a7a");
                    SQLUtils.execute((Connection)targetCn, (String)clearTab);
                }
                String insertSql = "insert into " + tempTable + " select m.headpk ,sysdate(),m.hashCode from (select distinct headpk,hashCode from " + pkTableName + ") m";
                SQLUtils.execute((Connection)targetCn, (String)insertSql);
                String delSql = "delete from " + tempTable + " where hashCode is null";
                SQLUtils.execute((Connection)targetCn, (String)delSql);
                String truncateSql = "truncate table " + pkTableName;
                SQLUtils.execute((Connection)targetCn, (String)truncateSql);
                String backSql = "insert into " + pkTableName + " select * from " + tempTable;
                SQLUtils.execute((Connection)targetCn, (String)backSql);
                String srcQrySql = "select headpk from " + pkTableName;
                RowSet srcRowSet = SQLUtils.getJdbcRowSet((Connection)targetCn, (String)srcQrySql);
                HashSet<String> srcSet = new HashSet<String>();
                while (srcRowSet.next()) {
                    srcSet.add(srcRowSet.getString(1));
                }
                if (srcSet.size() >= set.size()) {
                    logger.info((Object)"\u5f53\u524d\u6e90\u7cfb\u7edf\u7684\u589e\u91cf\u8868\u6570\u636e\u5927\u4e8e\u6216\u7b49\u4e8e\u4e2d\u95f4\u8868\u7684\u6570\u636e");
                } else {
                    set.removeAll(srcSet);
                }
                if (set.size() > 0) {
                    String synSql = "insert into " + pkTableName + "(headpk,createTime,hashCode) values (?,?,?)";
                    statement = targetCn.prepareStatement(synSql);
                    for (String headpk : set) {
                        statement.setString(1, headpk);
                        statement.setDate(2, new Date(System.currentTimeMillis()));
                        statement.setString(3, "a001");
                        statement.addBatch();
                    }
                    statement.executeBatch();
                }
                SQLUtils.cleanup(statement);
            }
            catch (Exception e) {
                logger.error((Object)"\u4fee\u590d\u589e\u91cf\u8868\u5931\u8d25\uff1a", (Throwable)e);
                break block14;
            }
            finally {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup(currCn);
                SQLUtils.cleanup(targetCn);
            }
            SQLUtils.cleanup((Connection)currCn);
            SQLUtils.cleanup((Connection)targetCn);
        }
    }

    public static BillMappingInfo getBillMappingInfo(Context ctx, String idPk) throws Exception {
        boolean isNumber = true;
        BillMappingInfo billInfo = null;
        IBillMapping instance = ctx == null ? BillMappingFactory.getRemoteInstance() : BillMappingFactory.getLocalInstance(ctx);
        try {
            billInfo = instance.getBillMappingInfo("where number='" + idPk + "'");
        }
        catch (Exception e) {
            isNumber = false;
            logger.error((Object)(idPk + "\u975enumber\u5b57\u6bb5\u503c,\u8f6cID\u67e5\u8be2"));
        }
        billInfo = DataModelUtil.readBillMappingInfo(ctx, isNumber ? billInfo.getId().toString() : idPk);
        return billInfo;
    }
}

