/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.mapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.biz.MappingInfo;
import com.kingdee.eas.csinterface.biz.MappingResultEntryCollection;
import com.kingdee.eas.csinterface.biz.MappingResultInfo;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.mapping.IDataMapping;
import com.kingdee.eas.csinterface.biz.model.Pair;
import com.kingdee.eas.csinterface.biz.model.SQLBuilder;
import com.kingdee.eas.csinterface.biz.util.DBUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractDataMapping
implements IDataMapping {
    public TableData getDataFromConn(boolean isSrc) throws BOSException, SQLException {
        Object notInFilter;
        SQLBuilder.Table table;
        Context ctx = EIPContext.getInstance().getContext();
        MappingResultInfo mappingResultInfo = this.getMappingResult();
        MappingInfo mappingInfo = mappingResultInfo.getMapping();
        List<Pair<String, String>> queryColumns = mappingInfo.getQueryColumns();
        Pair<String, String> pkColumn = mappingInfo.getPKColumn();
        SQLBuilder dataSql = SQLBuilder.getInstance();
        TableData tableData = new TableData();
        MappingResultEntryCollection resultEntrys = mappingResultInfo.getEntrys();
        if (isSrc) {
            table = dataSql.addATable(mappingInfo.getSrcTable());
            for (Pair<String, String> queryColumn : queryColumns) {
                table.addColumn(queryColumn.getK());
                tableData.addColumn(queryColumn.getK());
            }
            table.appendFilter(mappingResultInfo.getSrcWhere());
            if (resultEntrys.size() > 0) {
                notInFilter = new StringBuilder(pkColumn.getK()).append(" NOT IN (");
                for (int i = 0; i < resultEntrys.size(); ++i) {
                    String srcIdValue = resultEntrys.get(i).getSrcID();
                    ((StringBuilder)notInFilter).append("'").append(srcIdValue).append("'");
                    if (i >= resultEntrys.size() - 1) continue;
                    ((StringBuilder)notInFilter).append(",");
                }
                table.appendFilter(((StringBuilder)notInFilter).append(")").toString());
            }
        } else {
            table = dataSql.addATable(mappingInfo.getDestTable());
            for (Pair<String, String> queryColumn : queryColumns) {
                table.addColumn(queryColumn.getV());
                tableData.addColumn(queryColumn.getV());
            }
            table.appendFilter(mappingResultInfo.getDestWhere());
            if (resultEntrys.size() > 0) {
                notInFilter = new StringBuilder(pkColumn.getV()).append(" NOT IN (");
                for (int i = 0; i < resultEntrys.size(); ++i) {
                    String destIdValue = resultEntrys.get(i).getDestID();
                    ((StringBuilder)notInFilter).append("'").append(destIdValue).append("'");
                    if (i >= resultEntrys.size() - 1) continue;
                    ((StringBuilder)notInFilter).append(",");
                }
                table.appendFilter(((StringBuilder)notInFilter).append(")").toString());
            }
        }
        String connid = isSrc ? mappingInfo.getConn().getId().toString() : "";
        IRowSet rowset = null;
        rowset = StringUtils.isEmpty((String)connid) ? DBUtils.executeQuery(ctx, dataSql.toSql()) : DBUtils.executeQuery(ctx, connid, dataSql.toSql());
        int size = tableData.getCloumnModels().size();
        while (rowset.next()) {
            for (int i = 0; i < size; ++i) {
                tableData.addData(rowset.getString(i + 1));
            }
            tableData.enter();
        }
        SQLUtils.cleanup((ResultSet)rowset);
        return tableData;
    }

    public TableData getDataFromQuery() throws BOSException, ParserException {
        MappingResultEntryCollection resultEntrys;
        Context ctx = EIPContext.getInstance().getContext();
        MappingResultInfo mappingResultInfo = this.getMappingResult();
        MappingInfo mappingInfo = mappingResultInfo.getMapping();
        List<Pair<String, String>> queryColumns = mappingInfo.getQueryColumns();
        Pair<String, String> pkColumn = mappingInfo.getPKColumn();
        String queryName = mappingInfo.getDestBaseData().getQueryName();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)MetaDataPK.create((String)queryName));
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = (SubEntityInfo)mainObjectInfo;
        BOSObjectType type = mainEntityInfo.getEntityRef().getType();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        TableData tableData = new TableData();
        for (Pair<String, String> queryColumn : queryColumns) {
            coll.add(new SelectorItemInfo(queryColumn.getV()));
            tableData.addColumn(queryColumn.getV());
        }
        entityViewInfo.setSelector(coll);
        if (!StringUtils.isEmpty((String)mappingResultInfo.getDestWhere())) {
            entityViewInfo.setFilter(mappingResultInfo.getDestWhere());
        }
        if ((resultEntrys = mappingResultInfo.getEntrys()).size() > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < resultEntrys.size(); ++i) {
                String destIdValue = resultEntrys.get(i).getDestID();
                if (StringUtils.isEmpty((String)destIdValue)) continue;
                idSet.add(destIdValue);
            }
            entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo(pkColumn.getV(), idSet, CompareType.NOTINCLUDE));
        }
        if (!StringUtils.isEmpty((String)mappingInfo.getDestOrgField()) && !StringUtils.isEmpty((String)mappingResultInfo.getOrgUnit())) {
            entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo(mappingInfo.getDestOrgField(), (Object)mappingResultInfo.getOrgUnit(), CompareType.EQUALS));
        }
        IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(type, entityViewInfo);
        int size = tableData.getCloumnModels().size();
        for (int i = 0; i < collection.size(); ++i) {
            for (int j = 0; j < size; ++j) {
                String columnName = tableData.getColumnModel(j).getName();
                if (columnName.indexOf(46) < 0) {
                    tableData.addData(collection.getObject(i).getString(columnName));
                    continue;
                }
                String[] cns = columnName.split("\\.");
                if (collection.getObject(i).getObjectValue(cns[0]) == null) continue;
                tableData.addData(collection.getObject(i).getObjectValue(cns[0]).getString(cns[1]));
            }
            tableData.enter();
        }
        return tableData;
    }
}

