/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.transform;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.EIPRelationCollection;
import com.kingdee.eas.csinterface.biz.EIPRelationFactory;
import com.kingdee.eas.csinterface.biz.EIPRelationInfo;
import com.kingdee.eas.csinterface.biz.ProjectEntryCollection;
import com.kingdee.eas.csinterface.biz.ProjectEntryInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.exception.EIPException;
import com.kingdee.eas.csinterface.biz.extract.OperateStatus;
import com.kingdee.eas.csinterface.biz.model.Pair;
import com.kingdee.eas.csinterface.biz.transform.IDataTransformHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IdentifyTransformHandler
implements IDataTransformHandler {
    private static final Logger logger = Logger.getLogger(IdentifyTransformHandler.class);

    @Override
    public void handle(Map<String, Object> ctx) {
        JSONArray destData = (JSONArray)ctx.get("destData");
        if (destData == null || destData.isEmpty()) {
            return;
        }
        OperateStatus status = (OperateStatus)((Object)ctx.get("status"));
        List<Pair<String, BOSObjectType>> entrysType = this.getEntrysType();
        ctx.put("entrysType", entrysType);
        switch (status) {
            case ADDNEW: {
                this.generateID(destData, entrysType);
                break;
            }
            case UPDATE: 
            case DELETE: {
                this.mappingID(destData, entrysType);
                break;
            }
        }
    }

    private List<Pair<String, BOSObjectType>> getEntrysType() {
        ArrayList<Pair<String, BOSObjectType>> entrysType = new ArrayList<Pair<String, BOSObjectType>>();
        EIPContext eipContext = EIPContext.getInstance();
        Map dataSourceResult = (Map)eipContext.get("dataSourceResult");
        ProjectInfo projectInfo = (ProjectInfo)eipContext.get("projectInfo");
        Map<String, BOSObjectType> entryTypes = this.parseEntity(eipContext.getContext(), projectInfo.getTargetObj());
        String headPK = (String)dataSourceResult.get("headpk");
        String entryPK = (String)dataSourceResult.get("entrypk");
        ArrayList<String> srcFields = new ArrayList<String>();
        srcFields.add(headPK);
        if (!StringUtils.isEmpty((String)entryPK)) {
            srcFields.addAll(Arrays.asList(entryPK.split(",")));
        }
        ProjectEntryCollection entys = projectInfo.getEntrys();
        for (int i = 0; i < entys.size(); ++i) {
            ProjectEntryInfo entry = entys.get(i);
            for (String srcField : srcFields) {
                if (!srcField.equals(entry.getSrcField())) continue;
                String targetField = entry.getTargetField();
                if (entry.getParentField() != null) {
                    entrysType.add(new Pair<String, BOSObjectType>(entry.getParentField() + "." + targetField, entryTypes.get(entry.getParentField())));
                    continue;
                }
                entrysType.add(0, new Pair<String, BOSObjectType>(targetField, entryTypes.get(targetField)));
            }
        }
        return entrysType;
    }

    private Map<String, BOSObjectType> parseEntity(Context ctx, String targetObj) {
        HashMap<String, BOSObjectType> entrysObj = new HashMap<String, BOSObjectType>();
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)targetObj));
        PropertyCollection propertyCols = entityObjectInfo.getInheritedProperties();
        for (int i = 0; i < propertyCols.size(); ++i) {
            EntityObjectInfo childEntity;
            LinkPropertyInfo link;
            RelationshipInfo relation;
            PropertyInfo propertyInfo = propertyCols.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo) || (relation = (link = (LinkPropertyInfo)propertyInfo).getRelationship()) == null || !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relation.getSupplierCardinality()) && !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relation.getSupplierCardinality()) || (childEntity = relation.getSupplierObject()) == null) continue;
            entrysObj.put(propertyInfo.getName(), childEntity.getType());
        }
        entrysObj.put(entityObjectInfo.getLogicalKey().getName(), BOSObjectType.create((String)targetObj));
        return entrysObj;
    }

    private void generateID(JSONArray destData, List<Pair<String, BOSObjectType>> entrysType) {
        HashMap<String, String> srcToDest = new HashMap<String, String>();
        for (int i = 0; i < entrysType.size(); ++i) {
            Pair<String, BOSObjectType> entryType = entrysType.get(i);
            String columnName = entryType.getK();
            for (int j = 0; j < destData.size(); ++j) {
                if (i == 0) {
                    JSONObject jsonObj = destData.getJSONObject(j);
                    String srcId = jsonObj.getString(columnName);
                    String destId = (String)srcToDest.get(srcId);
                    if (destId == null) {
                        destId = BOSUuid.create((BOSObjectType)entryType.getV()).toString();
                        srcToDest.put(srcId, destId);
                    }
                    jsonObj.put(columnName, (Object)destId);
                    continue;
                }
                String destId = BOSUuid.create((BOSObjectType)entryType.getV()).toString();
                destData.getJSONObject(j).put(columnName, (Object)destId);
            }
        }
        EIPContext.getInstance().put("srcToDest", srcToDest);
    }

    private void mappingID(JSONArray destData, List<Pair<String, BOSObjectType>> entrysType) {
        DataSourceInfo dataSourceInfo = (DataSourceInfo)EIPContext.getInstance().get("dataSourceInfo");
        Context ctx = EIPContext.getInstance().getContext();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < entrysType.size(); ++i) {
            Pair<String, BOSObjectType> entryType = entrysType.get(i);
            String columnName = entryType.getK();
            for (int j = 0; j < destData.size(); ++j) {
                if (i == 0) {
                    idSet.add(destData.getJSONObject(j).getString(columnName));
                    continue;
                }
                String destId = BOSUuid.create((BOSObjectType)entryType.getV()).toString();
                destData.getJSONObject(i).put(columnName, (Object)destId);
            }
        }
        String targetObj = entrysType.get(0).getV().toString();
        String headFieldName = entrysType.get(0).getK();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("srcObjectID");
        selectors.add("destObjectID");
        entityViewInfo.setSelector(selectors);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("identificationCode", (Object)dataSourceInfo.getIdentify(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)targetObj, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        try {
            int i;
            EIPRelationCollection colls = EIPRelationFactory.getLocalInstance(ctx).getEIPRelationCollection(entityViewInfo);
            HashMap<String, String> srcToDest = new HashMap<String, String>();
            for (i = 0; i < colls.size(); ++i) {
                EIPRelationInfo info = colls.get(i);
                srcToDest.put(info.getSrcObjectID(), info.getDestObjectID());
            }
            for (i = 0; i < destData.size(); ++i) {
                JSONObject data = destData.getJSONObject(i);
                String srcId = data.getString(headFieldName);
                String destId = (String)srcToDest.get(srcId);
                if (srcId == null) {
                    destId = BOSUuid.create((String)targetObj).toString();
                    srcToDest.put(srcId, destId);
                }
                destData.getJSONObject(i).put(headFieldName, (Object)destId);
            }
            EIPContext.getInstance().put("srcToDest", srcToDest);
        }
        catch (BOSException e) {
            logger.error((Object)"\u3010EIP\u3011\u83b7\u53d6\u751f\u6210\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
            throw new EIPException("\u3010EIP\u3011\u83b7\u53d6\u751f\u6210\u8bb0\u5f55\u51fa\u9519", e);
        }
    }
}

