/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.IConnection;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class DBUtils {
    private static final Logger logger = Logger.getLogger(DBUtils.class);

    private DBUtils() {
    }

    public static ConnectionInfo getEIPCOnnectionInfo(Context ctx, String connId) {
        try {
            return ConnectionFactory.getLocalInstance(ctx).getConnectionInfo((IObjectPK)new ObjectStringPK(connId));
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u8fde\u63a5\u4fe1\u606f\u5931\u8d25\uff1a" + connId), (Throwable)e);
            return null;
        }
    }

    public static IRowSet executeQuery(Context ctx, String connId, String sql) throws BOSException {
        if (!StringUtils.isEmpty((String)connId)) {
            ConnectionInfo info;
            IConnection connection = ConnectionFactory.getLocalInstance(ctx);
            try {
                info = connection.getConnectionInfo((IObjectPK)new ObjectStringPK(connId));
            }
            catch (EASBizException e) {
                logger.error((Object)("\u83b7\u53d6\u8fde\u63a5\u4fe1\u606f\u5931\u8d25\uff1a" + connId), (Throwable)e);
                return null;
            }
            return DBUtils.executeQuery(info, sql);
        }
        return null;
    }

    public static IRowSet executeQuery(ConnectionInfo info, String sql) throws BOSException {
        if (info.getDBType() == null) {
            Context ctx = EIPContext.getInstance().getContext();
            return DBUtils.executeQuery(ctx, info.getId().toString(), sql);
        }
        String dbType = info.getDBType().toString();
        String ip = info.getIP();
        Integer port = info.getPort();
        String dbName = info.getInstance();
        String userName = info.getUsername();
        String pwd = info.getPassword();
        return KSQLUtil.executeQuery(DataBaseType.valueOf(dbType), ip, port, dbName, userName, pwd, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeAdd(ConnectionInfo info, String sql, List<Object> params) {
        PreparedStatement statement = null;
        Connection conn = null;
        try {
            conn = KSQLUtil.getConnection(info);
            statement = conn.prepareStatement(sql);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("\u6267\u884cSQL\u5931\u8d25\uff1a" + sql), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeCreateTable(ConnectionInfo info, String tableName, String sql) {
        Connection conn;
        Statement statement;
        block5: {
            boolean bl;
            statement = null;
            conn = null;
            try {
                conn = KSQLUtil.getConnection(info);
                if (!DBUtils.existsTable(conn, tableName)) {
                    statement = conn.createStatement();
                    statement.execute(sql);
                    break block5;
                }
                bl = false;
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    logger.error((Object)("\u6267\u884cSQL\u5931\u8d25\uff1a" + sql), (Throwable)e);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(null, statement, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
                return bl2;
            }
            SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsTable(Connection conn, String tableName) {
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            String ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME = '" + tableName + "'";
            logger.info((Object)("execute dataBase PKTable Query ksql :" + ksql));
            rs = statement.executeQuery(ksql);
            IRowSet rowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
            if (!rowSet.next()) {
                ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME like 'T_EIP_Z_%'";
                rs = statement.executeQuery(ksql);
                rowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
                while (rowSet.next()) {
                    if (!tableName.equalsIgnoreCase(rowSet.getString(1))) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return false;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        try {
            return SQLFacadeFactory.getLocalInstance(ctx).getRowset(sql);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static int getDbType(DBType dbType) {
        return DbType.getValue((String)dbType.getAlias());
    }
}

