/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.editor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.GroupType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.IEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DynQueryEntityTreeModel;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DynQueryFieldModel;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DynQueryLinkType;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DynQueryModel;
import com.kingdee.eas.csinterface.bizbill.metadata.info.FieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DynQueryUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.TranslateLocalUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.common.DIP_MainQueryParseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QueryEditor
implements IEditor {
    private static final Logger logger = Logger.getLogger(QueryEditor.class);
    private DynQueryModel model;
    private QueryInfo queryInfo;
    private EntityObjectInfo entityInfo;
    private EntityObjectInfo entryEntityInfo;

    public QueryEditor(QueryInfo queryInfo, EntityObjectInfo entityInfo, EntityObjectInfo entryEntityInfo) throws DIP_MainQueryParseException {
        this.queryInfo = queryInfo;
        this.entityInfo = entityInfo;
        this.entryEntityInfo = entryEntityInfo;
        try {
            this.initModel();
        }
        catch (DIP_MainQueryParseException e) {
            logger.error((Object)"QueryEditor init error! ", (Throwable)e);
            throw e;
        }
    }

    public void initModel() throws DIP_MainQueryParseException {
        this.model = new DynQueryModel(this.queryInfo);
    }

    private DynQueryEntityTreeModel getParentEntityModel(FieldInfo fieldInfo) {
        if ("entrys".equals(fieldInfo.getNamePrefix())) {
            DynQueryEntityTreeModel rootEntity = this.model.getRootEntityNode();
            for (int i = 0; i < rootEntity.getChildrenCount(); ++i) {
                DynQueryEntityTreeModel child = rootEntity.getChild(i);
                if (!"entrys".equals(child.getEntityName())) continue;
                return child;
            }
        } else {
            return this.model.getRootEntityNode();
        }
        return null;
    }

    private void prepareLinkedObject(EntityObjectInfo supplier, FieldInfo fieldInfo) throws DIPException {
        PropertyInfo prop = this.getEntityProperty(fieldInfo);
        DynQueryEntityTreeModel entityModel = new DynQueryEntityTreeModel();
        entityModel.setSystem(false);
        entityModel.setBosObjectId(supplier.getType().toString());
        entityModel.setEntityAlias(supplier.getAlias());
        String spplierName = "";
        if (StringUtils.isEmpty((String)supplier.getName())) {
            spplierName = Uuid.create().toString();
            spplierName = spplierName.substring(spplierName.length() - 5);
        }
        String uniqueName = fieldInfo.getName();
        entityModel.setEntityName(uniqueName);
        entityModel.setLinkType(DynQueryLinkType.LeftJoin);
        entityModel.setSubmited(false);
        DynQueryEntityTreeModel parentEntityModel = this.getParentEntityModel(fieldInfo);
        EntityObjectInfo rightValue = supplier;
        QueryInfo queryInfo = this.model.getMainQuery();
        if (queryInfo instanceof JoinQueryInfo) {
            JoinQueryInfo joinQueryInfo = (JoinQueryInfo)queryInfo;
            JoinInfo joinInfo = new JoinInfo(joinQueryInfo);
            joinInfo.setName(joinQueryInfo.getNewJoinName());
            joinInfo.setJoinType(DynQueryLinkType.LeftJoin.toBOS());
            joinInfo.setFormulaString("#0");
            SubObjectInfo leftObject = parentEntityModel.getSubObjectInfo();
            joinInfo.setLeftObject(leftObject);
            if (rightValue instanceof EntityObjectInfo) {
                SubEntityInfo rightObjInfo = new SubEntityInfo(queryInfo, rightValue);
                rightObjInfo.setName(entityModel.getEntityName());
                rightObjInfo.setConfigured(true);
                joinInfo.setRightObject((SubObjectInfo)rightObjInfo);
                entityModel.setSubObjectInfo((SubObjectInfo)rightObjInfo);
                entityModel.setJoinInfo(joinInfo);
                this.importRightEntity(entityModel, leftObject, (SubObjectInfo)rightObjInfo, prop, joinInfo);
            }
        } else {
            return;
        }
        parentEntityModel.addChild(entityModel);
    }

    private PropertyInfo getEntityProperty(FieldInfo fieldInfo) throws DIPException {
        EntityObjectInfo entityObjectInfo = this.getEntityForField(fieldInfo);
        PropertyCollection props = entityObjectInfo.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            PropertyInfo pInfo = props.get(i);
            if (!pInfo.getName().equals(fieldInfo.getRealName())) continue;
            return pInfo;
        }
        throw new DIPException("property '" + fieldInfo.getRealName() + "' not found in '" + entityObjectInfo + "'");
    }

    private EntityObjectInfo getEntityForField(FieldInfo fieldInfo) {
        EntityObjectInfo entityObjectInfo = null;
        entityObjectInfo = "entrys".equals(fieldInfo.getNamePrefix()) ? this.entryEntityInfo : this.entityInfo;
        return entityObjectInfo;
    }

    private void importRightEntity(DynQueryEntityTreeModel entityModel, SubObjectInfo leftObjectInfo, SubObjectInfo rightObjectInfo, PropertyInfo prop, JoinInfo joinInfo) {
        JoinItemInfo item = new JoinItemInfo(joinInfo);
        item.setName(joinInfo.getNewJoinItemName());
        PropertyUnitInfo leftField = new PropertyUnitInfo(this.model.getMainQuery());
        leftField.setName(Uuid.create().toString());
        PropertyUnitInfo rightField = new PropertyUnitInfo(this.model.getMainQuery());
        rightField.setName(Uuid.create().toString());
        item.setLeftField(leftField);
        item.setRightField(rightField);
        item.setCompareType(CompareType.EQUALS);
        PropertyRefInfo leftpref = new PropertyRefInfo(item.getLeftField(), (SubEntityInfo)leftObjectInfo, prop);
        leftField.getPropertyRefs().add(leftpref);
        PropertyInfo rightpropertyInfo = QueryEditor.getSubObjProByName(rightObjectInfo);
        PropertyRefInfo rightpref = new PropertyRefInfo(item.getRightField(), (SubEntityInfo)rightObjectInfo, rightpropertyInfo);
        rightField.getPropertyRefs().add(rightpref);
        JoinItemCollection newCollection = new JoinItemCollection();
        entityModel.removeAllConditions();
        newCollection.add(item);
        entityModel.submitJoinInfo(newCollection);
        joinInfo.getJoinItems().add(item);
    }

    private static PropertyInfo getSubObjProByName(SubObjectInfo rightObjectInfo) {
        String rightProName = "id";
        EntityObjectInfo entity = ((SubEntityInfo)rightObjectInfo).getEntityRef();
        PropertyCollection collection = entity.getInheritedNoDuplicatedProperties();
        return (PropertyInfo)collection.getObject((Object)rightProName);
    }

    private boolean hasSameName(String name, DynQueryEntityTreeModel rootNode) {
        if (StringUtil.equalsIgnoreCase((String)name, (String)rootNode.getEntityName())) {
            return true;
        }
        int c = rootNode.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            DynQueryEntityTreeModel node = rootNode.getChild(i);
            if (!this.hasSameName(name, node)) continue;
            return true;
        }
        return false;
    }

    private String getUniqueName(String entityName) {
        DynQueryEntityTreeModel rootNode = this.model.getRootEntityNode();
        String number = entityName;
        int postfix = 0;
        boolean loop = true;
        while (loop) {
            loop = this.hasSameName(number, rootNode);
            if (!loop) continue;
            number = entityName + ++postfix;
        }
        return number;
    }

    @Override
    public void add(FieldInfo fieldInfo) throws Exception {
        DynQueryFieldModel[] fields;
        EntityObjectInfo baseDataEntityInfo = null;
        if (!StringUtils.isEmpty((String)fieldInfo.getBaseDataType())) {
            baseDataEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(fieldInfo.getBaseDataType()));
            this.prepareLinkedObject(baseDataEntityInfo, fieldInfo);
        }
        String realFieldName = fieldInfo.getRealName();
        DynQueryEntityTreeModel rootEntity = this.model.getRootEntityNode();
        DynQueryEntityTreeModel foundEntityNode = this.findEntityNode(rootEntity, fieldInfo);
        QueryFieldInfo queryFieldInfo = null;
        if (baseDataEntityInfo == null) {
            fields = foundEntityNode.getAllFields();
            if (fields != null && fields.length > 0) {
                for (int i = 0; i < fields.length; ++i) {
                    if (!realFieldName.equals(fields[i].getFieldName())) continue;
                    queryFieldInfo = this.createQueryFieldInfo(foundEntityNode, fields[i]);
                    PropertyUnitCollection unitColleciton = this.model.getMainQuery().getUnits();
                    unitColleciton.add((PropertyUnitInfo)queryFieldInfo);
                }
            }
        } else {
            fields = foundEntityNode.getAllFields();
            String baseDataDisplay = fieldInfo.getBaseDataDisplayName();
            if (!StringUtils.isEmpty((String)baseDataDisplay) && baseDataDisplay.indexOf(".") > 0) {
                baseDataDisplay = baseDataDisplay.split("\\.")[1];
            }
            for (DynQueryFieldModel field : fields) {
                if (!baseDataDisplay.equalsIgnoreCase(field.getFieldName())) continue;
                queryFieldInfo = this.createQueryFieldInfo(foundEntityNode, field);
                PropertyUnitCollection unitColleciton = this.model.getMainQuery().getUnits();
                unitColleciton.add((PropertyUnitInfo)queryFieldInfo);
                break;
            }
        }
        if (queryFieldInfo != null) {
            String displayName = fieldInfo.getQueryDisplayName();
            if ("number".equalsIgnoreCase(fieldInfo.getBaseDataDisplayName())) {
                displayName = displayName + "_\u7f16\u7801";
            }
            if (!StringUtils.isEmpty((String)displayName)) {
                queryFieldInfo.setDisplayName(displayName);
                queryFieldInfo.setDisplayName(TranslateLocalUtil.getSimplified(displayName), new Locale("l2"));
                queryFieldInfo.setDisplayName(TranslateLocalUtil.getTraditional(displayName), new Locale("l3"));
            }
        }
    }

    private DynQueryEntityTreeModel findEntityNode(DynQueryEntityTreeModel rootEntity, FieldInfo fieldInfo) throws DIPException {
        DynQueryEntityTreeModel found;
        String prefix;
        String toFind = prefix = fieldInfo.getNamePrefix();
        if (!StringUtils.isEmpty((String)fieldInfo.getBaseDataType())) {
            toFind = fieldInfo.getName();
        }
        if ((found = this._findEntityNode(rootEntity, toFind)) == null) {
            return rootEntity;
        }
        return found;
    }

    private DynQueryEntityTreeModel _findEntityNode(DynQueryEntityTreeModel currentModel, String toFind) {
        if (StringUtils.isEmpty((String)toFind) || currentModel.getChildrenCount() < 1) {
            return null;
        }
        DynQueryEntityTreeModel _currentFind = null;
        for (int i = 0; i < currentModel.getChildrenCount(); ++i) {
            _currentFind = currentModel.getChild(i);
            if (toFind.equals(_currentFind.getEntityName())) {
                return _currentFind;
            }
            if ((_currentFind = this._findEntityNode(_currentFind, toFind)) == null) continue;
            return _currentFind;
        }
        return null;
    }

    private QueryFieldInfo createQueryFieldInfo(DynQueryEntityTreeModel entityNode, DynQueryFieldModel fieldNode) {
        boolean grouping;
        QueryFieldInfo field = new QueryFieldInfo(this.model.getMainQuery());
        field.setIsSelector(true);
        field.setIsFilter(true);
        field.setExtendedProperty("isCommonQueryFilter", "true");
        field.setExtendedProperty("isCommonQuerySorter", "true");
        String mainObjectName = null;
        if (this.model.getMainQuery() instanceof JoinQueryInfo) {
            try {
                mainObjectName = QueryUtil.getMainObject((JoinQueryInfo)((JoinQueryInfo)this.model.getMainQuery())).getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (grouping = DynQueryUtil.isGrouping(this.model.getMainQuery())) {
            field.setGroupType(GroupType.GROUPING);
        }
        String unitName = "newUnitName";
        SubObjectInfo subObjectInfo = entityNode.getSubObjectInfo();
        if (subObjectInfo instanceof SubEntityInfo) {
            PropertyInfo p = fieldNode.getPropertyInfo();
            if (p instanceof OwnPropertyInfo) {
                OwnPropertyInfo prop = (OwnPropertyInfo)p;
                if (ContextUtils.getLocaleFromEnv().equals(new Locale("l1"))) {
                    field.setDisplayName(prop.getAlias());
                } else {
                    field.setDisplayName(TranslateLocalUtil.getSimplified(prop.getAlias()), new Locale("l2"));
                    field.setDisplayName(TranslateLocalUtil.getTraditional(prop.getAlias()), new Locale("l3"));
                }
                if (prop.getDataType().equals((Object)DataType.ENUM)) {
                    ConstDataType fieldType = null;
                    String metadataRef = prop.getMetaDataRef();
                    if (metadataRef != null) {
                        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)metadataRef);
                        BizEnumInfo enumItem = UictUtils.loadBizEnum(pk);
                        if (enumItem != null) {
                            BizEnumValueType valueType = enumItem.getDataType();
                            if (valueType.equals((Object)BizEnumValueType.INTEGER) || valueType.equals((Object)BizEnumValueType.LONG)) {
                                fieldType = ConstDataType.INT;
                            } else if (valueType.equals((Object)BizEnumValueType.FLOAT) || valueType.equals((Object)BizEnumValueType.DOUBLE)) {
                                fieldType = ConstDataType.NUMBER;
                            } else if (valueType.equals((Object)BizEnumValueType.STRING)) {
                                fieldType = ConstDataType.STRING;
                            }
                        }
                        if (fieldType != null) {
                            field.setReturnType(fieldType);
                        }
                    }
                }
                PropertyRefInfo refInfo = new PropertyRefInfo((PropertyUnitInfo)field, (SubEntityInfo)subObjectInfo, (PropertyInfo)prop);
                field.getPropertyRefs().add(refInfo);
                unitName = mainObjectName != null && mainObjectName.equals(refInfo.getSubEntity().getName()) ? refInfo.getRefProperty().getName() : refInfo.getSubEntity().getName() + "." + refInfo.getRefProperty().getName();
            }
        } else if (subObjectInfo instanceof SubQueryInfo) {
            SubQueryInfo query = (SubQueryInfo)subObjectInfo;
            QueryFieldInfo queryField = fieldNode.getQueryFieldInfo();
            if (queryField instanceof QueryFieldInfo) {
                PropertyRefInfo refInfo = new PropertyRefInfo();
                refInfo.setRefUnit((PropertyUnitInfo)queryField);
                refInfo.setSubQuery(query);
                field.getPropertyRefs().add(refInfo);
                if (ContextUtils.getLocaleFromEnv().equals(new Locale("l1"))) {
                    field.setDisplayName(queryField.getDisplayName());
                } else {
                    field.setDisplayName(TranslateLocalUtil.getSimplified(queryField.getDisplayName()), new Locale("l2"));
                    field.setDisplayName(TranslateLocalUtil.getTraditional(queryField.getDisplayName()), new Locale("l3"));
                }
                unitName = refInfo.getSubQuery().getName() + "." + refInfo.getRefUnit().getName();
            }
        }
        field.setName(unitName);
        try {
            if (field.getReturnType() != null) {
                field.setReturnType(field.getReturnType());
            }
        }
        catch (BOSException err) {
            field.setReturnType(ConstDataType.OBJECT);
        }
        field.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        field.setConfigured(true);
        return field;
    }

    public QueryInfo getQueryInfo() {
        QueryInfo query = this.model.getMainQuery();
        return query;
    }

    @Override
    public void delete(FieldInfo fieldInfo) throws Exception {
        String realFieldName = StringUtils.isEmpty((String)fieldInfo.getBaseDataType()) ? fieldInfo.getRealName() : fieldInfo.getBaseDataDisplayName();
        DynQueryEntityTreeModel rootEntity = this.model.getRootEntityNode();
        DynQueryEntityTreeModel foundEntityNode = this.findEntityNode(rootEntity, fieldInfo);
        DynQueryFieldModel[] fields = foundEntityNode.getAllFields();
        if (fields != null && fields.length > 0) {
            block0: for (int i = 0; i < fields.length; ++i) {
                if (!realFieldName.equals(fields[i].getFieldName())) continue;
                QueryFieldInfo queryFieldInfo = this.createQueryFieldInfo(foundEntityNode, fields[i]);
                if (!StringUtils.isEmpty((String)fieldInfo.getBaseDataType())) {
                    SubObjectCollection subObjects;
                    if (this.model.getMainQuery() instanceof JoinQueryInfo) {
                        JoinQueryInfo queryInfo = (JoinQueryInfo)this.model.getMainQuery();
                        JoinCollection joinCollection = queryInfo.getJoins();
                        for (int j = 0; j < joinCollection.size(); ++j) {
                            JoinInfo joinInfo = joinCollection.get(j);
                            if (!fieldInfo.getName().equals(joinInfo.getRightObject().getName())) continue;
                            JoinItemInfo joinItem = joinInfo.getJoinItems().get(0);
                            queryInfo.getUnits().remove(joinItem.getLeftField());
                            queryInfo.getUnits().remove(joinItem.getRightField());
                            joinCollection.removeObject(j);
                            break;
                        }
                    }
                    if ((subObjects = this.model.getMainQuery().getSubObjects()) != null && subObjects.size() > 0) {
                        for (int j = 0; j < subObjects.size(); ++j) {
                            SubObjectInfo subObjectInfo = subObjects.get(j);
                            if (!fieldInfo.getName().equals(subObjectInfo.getName())) continue;
                            subObjects.removeObject(j);
                            break;
                        }
                    }
                }
                PropertyUnitCollection unitColleciton = this.model.getMainQuery().getUnits();
                for (int j = 0; j < unitColleciton.size(); ++j) {
                    PropertyUnitInfo puInfo = unitColleciton.get(j);
                    if (!(puInfo instanceof QueryFieldInfo)) continue;
                    QueryFieldInfo _queryFieldInfo = (QueryFieldInfo)puInfo;
                    if (!queryFieldInfo.getName().equals(_queryFieldInfo.getName())) continue;
                    DynQueryUtil.deleteFromQuery(this.queryInfo, queryFieldInfo);
                    break block0;
                }
                break;
            }
        }
        fieldInfo.setBaseDataDisplayName("number");
        this.deleteNumber(fieldInfo);
    }

    public void deleteNumber(FieldInfo fieldInfo) throws Exception {
        String realFieldName = StringUtils.isEmpty((String)fieldInfo.getBaseDataType()) ? fieldInfo.getRealName() : fieldInfo.getBaseDataDisplayName();
        DynQueryEntityTreeModel rootEntity = this.model.getRootEntityNode();
        DynQueryEntityTreeModel foundEntityNode = this.findEntityNode(rootEntity, fieldInfo);
        DynQueryFieldModel[] fields = foundEntityNode.getAllFields();
        if (fields != null && fields.length > 0) {
            block0: for (int i = 0; i < fields.length; ++i) {
                if (!realFieldName.equals(fields[i].getFieldName())) continue;
                QueryFieldInfo queryFieldInfo = this.createQueryFieldInfo(foundEntityNode, fields[i]);
                if (!StringUtils.isEmpty((String)fieldInfo.getBaseDataType())) {
                    SubObjectCollection subObjects;
                    if (this.model.getMainQuery() instanceof JoinQueryInfo) {
                        JoinQueryInfo queryInfo = (JoinQueryInfo)this.model.getMainQuery();
                        JoinCollection joinCollection = queryInfo.getJoins();
                        for (int j = 0; j < joinCollection.size(); ++j) {
                            JoinInfo joinInfo = joinCollection.get(j);
                            if (!fieldInfo.getName().equals(joinInfo.getRightObject().getName())) continue;
                            JoinItemInfo joinItem = joinInfo.getJoinItems().get(0);
                            queryInfo.getUnits().remove(joinItem.getLeftField());
                            queryInfo.getUnits().remove(joinItem.getRightField());
                            joinCollection.removeObject(j);
                            break;
                        }
                    }
                    if ((subObjects = this.model.getMainQuery().getSubObjects()) != null && subObjects.size() > 0) {
                        for (int j = 0; j < subObjects.size(); ++j) {
                            SubObjectInfo subObjectInfo = subObjects.get(j);
                            if (!fieldInfo.getName().equals(subObjectInfo.getName())) continue;
                            subObjects.removeObject(j);
                            break;
                        }
                    }
                }
                PropertyUnitCollection unitColleciton = this.model.getMainQuery().getUnits();
                for (int j = 0; j < unitColleciton.size(); ++j) {
                    PropertyUnitInfo puInfo = unitColleciton.get(j);
                    if (!(puInfo instanceof QueryFieldInfo)) continue;
                    QueryFieldInfo _queryFieldInfo = (QueryFieldInfo)puInfo;
                    if (!queryFieldInfo.getName().equals(_queryFieldInfo.getName())) continue;
                    DynQueryUtil.deleteFromQuery(this.queryInfo, queryFieldInfo);
                    break block0;
                }
                break;
            }
        }
    }
}

